/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.turrets;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.constants.land.abstraction.KingdomBuildingTypeRegistry;
import org.kingdoms.constants.land.turrets.TurretStyle;
import org.kingdoms.constants.land.turrets.TurretType;
import org.kingdoms.constants.land.turrets.types.TurretTypeArrow;
import org.kingdoms.constants.land.turrets.types.TurretTypeHealing;
import org.kingdoms.constants.land.turrets.types.TurretTypeInferno;
import org.kingdoms.constants.land.turrets.types.TurretTypePressureMine;
import org.kingdoms.constants.land.turrets.types.TurretTypeSoldier;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.config.FolderYamlRegistry;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.importer.YamlGlobalImporter;

public final class TurretRegistry
implements KingdomBuildingTypeRegistry<TurretType, TurretStyle> {
    private static final Map<String, TurretType> TYPES = new HashMap<String, TurretType>();
    private static final Map<String, TurretStyle> STYLES = new HashMap<String, TurretStyle>();
    private static final TurretRegistry INSTANCE = new TurretRegistry();
    protected static final NodeValidator SCHEMA = YamlContainer.parseValidator("Turret Schema", "schemas/Turrets/turret.yml");
    public static final Path TURRETS_PATH = Kingdoms.getPath("Turrets");

    private TurretRegistry() {
    }

    public static TurretRegistry get() {
        return INSTANCE;
    }

    @Override
    public TurretType registerType(TurretType type) {
        return TYPES.put(type.getName(), type);
    }

    @Override
    public TurretStyle registerStyle(TurretStyle style) {
        style.loadSettings();
        return STYLES.put(style.getName(), style);
    }

    @Override
    public void init() {
        TYPES.clear();
        this.registerType(new TurretTypeArrow());
        this.registerType(new TurretTypeHealing());
        this.registerType(new TurretTypeInferno());
        this.registerType(new TurretTypeSoldier());
        this.registerType(new TurretTypePressureMine());
        STYLES.clear();
        new FolderYamlRegistry("Turret", "Turrets", (name, adapter) -> {
            adapter.setResolveAliases(false).load();
            adapter.setImporter(YamlGlobalImporter.INSTANCE).importDeclarations();
            TurretRegistry.validate(name, adapter);
            this.registerStyle(new TurretStyle((String)name, (YamlContainer)adapter));
        }).dontUseDefaultsIfFolderExists().register();
    }

    public static void validate(String name, YamlContainer adapter) {
        ConfigManager.warnAboutValidation("Turrets/" + name, Validator.validate(adapter.getConfig().getNode(), SCHEMA, CustomConfigValidators.getValidators()));
    }

    @Override
    public TurretStyle getStyle(String turret) {
        return STYLES.get(turret);
    }

    @Override
    public Map<String, TurretType> getTypes() {
        return TYPES;
    }

    @Override
    public Map<String, TurretStyle> getStyles() {
        return STYLES;
    }

    @Override
    public TurretType getType(String name) {
        return TYPES.get(name);
    }
}

