/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures.type;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.objects.Extractor;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.items.KingdomItemInteractEvent;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.InteractiveGUIManager;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.internals.KingdomsTimings;
import org.kingdoms.utils.time.TimeFormatter;

public class StructureTypeExtractor
extends StructureType {
    public StructureTypeExtractor() {
        super("extractor");
    }

    @Override
    public InteractiveGUI open(final KingdomItemGUIContext<Structure> context) {
        InteractiveGUI gui;
        KingdomItemInteractEvent<Structure> event = context.getEvent();
        final Player player = event.getPlayer().getPlayer();
        if (player == null) {
            return null;
        }
        Extractor extractor = (Extractor)event.getKingdomItem();
        KingdomPlayer kp = event.getPlayer();
        MessagePlaceholderProvider edits = extractor.getMessageContext().raw("time", TimeFormatter.of(System.currentTimeMillis() - extractor.getLastCollected())).raw("amount", extractor.getCollectedResourcePoints()).raw("extractor-last-collector", extractor.getLastCollector() == null ? KingdomsLang.NONE : Bukkit.getOfflinePlayer((UUID)extractor.getLastCollector()).getName());
        String guiPath = "structures/" + ((StructureStyle)extractor.getStyle()).getName();
        if (!KingdomsConfig.GUIS_ENABLE_REFRESH_FEATURE.getBoolean()) {
            gui = GUIAccessor.prepare(player, guiPath, edits);
        } else {
            gui = InteractiveGUIManager.getGuis().get(player.getEntityId());
            if (gui == null || !gui.is(guiPath)) {
                KingdomsTimings.time("Extractor Refresh");
                gui = GUIAccessor.prepare(player, guiPath, edits);
                if (gui == null) {
                    return null;
                }
                final InteractiveGUI finalGui = gui;
                gui.setRefreshTask(new BukkitRunnable(){

                    public void run() {
                        InteractiveGUI curr = InteractiveGUIManager.getGuis().get(player.getEntityId());
                        if (finalGui != curr) {
                            KLogger.error("Extractor GUI instance not same as the task: " + curr);
                            finalGui.close();
                        }
                        StructureTypeExtractor.this.open(context.refresh(finalGui));
                    }
                }.runTaskTimer((Plugin)Kingdoms.get(), 20L, 20L));
            } else {
                gui.resetOptions();
                gui.setMessageContext(edits);
            }
        }
        this.pushUpgrade(gui, context, extractor.getLand().getKingdom());
        InteractiveGUI finalGui1 = gui;
        gui.push("collect", () -> {
            if (extractor.getCollectedResourcePoints() <= 0L) {
                return;
            }
            extractor.collect(kp);
            this.open(context.refresh(finalGui1));
        }, new Object[0]);
        return context.finalizeGUI(gui, context.isRefreshing());
    }

    @Override
    public Extractor build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        Extractor ex = new Extractor(builder.getStyle(), builder.getLocation());
        if (builder.getPlacedBy() != null) {
            ex.setLastCollector(builder.getPlacedBy().getId());
        }
        return ex;
    }
}

