/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.abstraction.gui.KingdomItemGUIContext;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.type.nexus.StructureTypeNationNexus;
import org.kingdoms.constants.land.structures.type.nexus.StructureTypeNexus;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.item.ItemNBT;

public abstract class StructureType
extends KingdomBuildingType<Structure, StructureStyle, StructureType> {
    public static final String METADATA = "Structure";

    public StructureType(String name) {
        super(name);
    }

    public static StructureType getType(ItemStack item) {
        String tag = (String)ItemNBT.getTag(item).get(METADATA, NBTTagType.STRING);
        return tag == null ? null : StructureRegistry.get().getType(tag);
    }

    public boolean isNationalNexus() {
        return this instanceof StructureTypeNationNexus;
    }

    public boolean isNexus() {
        return this instanceof StructureTypeNexus;
    }

    public boolean removeWhenUnclaimed() {
        return this.isNexus();
    }

    @Override
    public Structure build(KingdomItemBuilder<Structure, StructureStyle, StructureType> builder) {
        return new Structure(builder.getStyle(), builder.getLocation());
    }

    @Override
    public final String getCategoryName() {
        return "Structures";
    }

    protected void pushUpgrade(InteractiveGUI gui, KingdomItemGUIContext<Structure> context, Kingdom kingdom) {
        Player player = gui.getOwner();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Structure structure = (Structure)context.getEvent().getKingdomItem();
        gui.push("upgrade", () -> {
            KingdomsBlockUpgradeContext<Structure> upgradeContext = new KingdomsBlockUpgradeContext<Structure>(kp, structure, structure.getLevel() + 1);
            Messenger error = structure.getKingdomBlockHandler().onUpgrade(upgradeContext);
            if (error == null) {
                upgradeContext.finalizeProcess();
            } else {
                error.sendError((CommandSender)player, upgradeContext.getMessageContext());
            }
        }, new Object[0]);
    }
}

