/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.structures;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.kingdoms.config.managers.ConfigManager;
import org.kingdoms.constants.land.abstraction.KingdomBuildingTypeRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.type.StructureTypeExtractor;
import org.kingdoms.constants.land.structures.type.StructureTypeOutpost;
import org.kingdoms.constants.land.structures.type.StructureTypePowercell;
import org.kingdoms.constants.land.structures.type.StructureTypeRegulator;
import org.kingdoms.constants.land.structures.type.StructureTypeSiegeCannon;
import org.kingdoms.constants.land.structures.type.StructureTypeWarpPad;
import org.kingdoms.constants.land.structures.type.nexus.StructureTypeKingdomNexus;
import org.kingdoms.constants.land.structures.type.nexus.StructureTypeNationNexus;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.config.FolderYamlRegistry;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.importer.YamlGlobalImporter;
import org.kingdoms.utils.string.Strings;

public final class StructureRegistry
implements KingdomBuildingTypeRegistry<StructureType, StructureStyle> {
    private static final Map<String, StructureType> TYPES = new HashMap<String, StructureType>();
    private static final Map<String, StructureStyle> STYLES = new HashMap<String, StructureStyle>();
    private static final StructureRegistry INSTANCE = new StructureRegistry();
    protected static final NodeValidator SCHEMA = YamlContainer.parseValidator("Structure Schema", "schemas/Structures/structure.yml");
    public static final Path STRUCTURES_PATH = Kingdoms.getPath("Structures");

    private StructureRegistry() {
    }

    public static StructureRegistry get() {
        return INSTANCE;
    }

    @Override
    public void init() {
        TYPES.clear();
        this.registerType(new StructureTypeKingdomNexus());
        this.registerType(new StructureTypeNationNexus());
        this.registerType(new StructureTypeExtractor());
        this.registerType(new StructureTypeWarpPad());
        this.registerType(new StructureTypeRegulator());
        this.registerType(new StructureTypePowercell());
        this.registerType(new StructureTypeOutpost());
        this.registerType(new StructureTypeSiegeCannon());
        STYLES.clear();
        new FolderYamlRegistry("Structure", "Structures", (name, adapter) -> {
            adapter.setResolveAliases(false).load();
            adapter.setImporter(YamlGlobalImporter.INSTANCE).importDeclarations();
            StructureRegistry.validate(name, adapter);
            this.registerStyle(new StructureStyle((String)name, (YamlContainer)adapter));
        }).dontUseDefaultsIfFolderExists().register();
    }

    public static void validate(String name, YamlContainer adapter) {
        ConfigManager.warnAboutValidation("Structures/" + name, Validator.validate(adapter.getConfig().getNode(), SCHEMA, CustomConfigValidators.getValidators()));
    }

    @Override
    public StructureStyle registerStyle(StructureStyle style) {
        style.loadSettings();
        return STYLES.put(style.getName(), style);
    }

    @Override
    public Map<String, StructureType> getTypes() {
        return TYPES;
    }

    @Override
    public StructureType getType(String name) {
        return TYPES.get(name.toLowerCase(Locale.ENGLISH));
    }

    @Override
    public StructureType registerType(StructureType type) {
        Objects.requireNonNull(type, "Cannot register structure type with null type");
        String name = type.getName();
        name = Strings.deleteWhitespace(name.toLowerCase(Locale.ENGLISH));
        Validate.isTrue(!TYPES.containsKey(name), "Structure type '" + name + "' is already registered");
        return TYPES.put(name, type);
    }

    @Override
    public Map<String, StructureStyle> getStyles() {
        return STYLES;
    }

    @Override
    public StructureStyle getStyle(String turret) {
        return STYLES.get(turret);
    }
}

