/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.location;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.util.NumberConversions;
import org.bukkit.util.Vector;
import org.kingdoms.constants.DataStringRepresentation;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.internal.string.CommaDataSplitStrategy;

public class SimpleLocation
implements Cloneable,
BlockPoint3D,
DataStringRepresentation {
    private final @NonNull String world;
    private final int x;
    private final int y;
    private final int z;

    public SimpleLocation(@NonNull String world, int x, int y, int z) {
        this.world = Objects.requireNonNull(world, "World name cannot be null");
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static SimpleLocation of(@NonNull String world, @NonNull BlockVector3 location) {
        Objects.requireNonNull(location, "Cannot get simple location of a null location");
        return new SimpleLocation(world, location.getX(), location.getY(), location.getZ());
    }

    public static SimpleLocation of(Location location) {
        Objects.requireNonNull(location, "Cannot get simple location of a null location");
        return new SimpleLocation(location.getWorld().getName(), (int)location.getX(), (int)location.getY(), (int)location.getZ());
    }

    public static SimpleLocation of(BlockLocation3 location) {
        Objects.requireNonNull(location, "Cannot get simple location of a null location");
        return new SimpleLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ());
    }

    public static SimpleLocation of(@NonNull org.bukkit.Location location) {
        Objects.requireNonNull(location, "Cannot get simple location of a null location");
        World world = Objects.requireNonNull(location.getWorld(), "World of location is null - Either an issue with your world management plugin or the world was deleted.");
        return new SimpleLocation(world.getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static SimpleLocation of(@NonNull Block block) {
        Objects.requireNonNull(block, "Cannot get simple location of a null block");
        return new SimpleLocation(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public BlockVector3 toBlockVector() {
        return BlockVector3.of(this.x, this.y, this.z);
    }

    private static double square(int num) {
        return (double)num * (double)num;
    }

    public static boolean equalsIgnoreWorld(@Nonnull org.bukkit.Location location, @Nonnull org.bukkit.Location other) {
        if (location == other) {
            return true;
        }
        return location.getX() == other.getX() && location.getY() == other.getY() && location.getZ() == other.getY();
    }

    public static boolean equalsIgnoreWorld(@Nonnull Block block, @Nonnull Block other) {
        if (block == other) {
            return true;
        }
        return block.getX() == other.getX() && block.getY() == other.getY() && block.getZ() == other.getY();
    }

    public static Supplier<SimpleLocation> resolve(Block block) {
        return () -> SimpleLocation.of(block);
    }

    public static Supplier<SimpleLocation> resolve(Entity entity2) {
        return () -> SimpleLocation.of(entity2.getLocation());
    }

    public @NonNull SimpleChunkLocation toSimpleChunkLocation() {
        return new SimpleChunkLocation(this.world, this.x >> 4, this.z >> 4);
    }

    public @NonNull Block getBlock() {
        return this.getBukkitWorld().getBlockAt(this.x, this.y, this.z);
    }

    public @NonNull String getWorld() {
        return this.world;
    }

    public @Nullable World getBukkitWorld() {
        return Objects.requireNonNull(BukkitWorld.getWorld(this.world, (Object)this));
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    @Override
    public int getY() {
        return this.y;
    }

    public @NonNull SimpleLocation clone() {
        try {
            return (SimpleLocation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)("SimpleLocation clone failed: " + e.getLocalizedMessage()));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 14;
        result = prime * result + this.world.hashCode();
        result = prime * result + this.x;
        result = prime * result + this.y;
        result = prime * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SimpleLocation) {
            SimpleLocation loc = (SimpleLocation)obj;
            return this.x == loc.x && this.y == loc.y && this.z == loc.z && Objects.equals(this.world, loc.world);
        }
        return false;
    }

    public boolean equalsIgnoreWorld(SimpleLocation loc) {
        return this.x == loc.x && this.y == loc.y && this.z == loc.z;
    }

    public String toString() {
        return this.world + ", " + this.x + ", " + this.y + ", " + this.z;
    }

    public @NonNull Vector toVector() {
        return new Vector(this.x, this.y, this.z);
    }

    public @NonNull SimpleLocation getRelative(int x, int y, int z) {
        return new SimpleLocation(this.world, this.x + x, this.y + y, this.z + z);
    }

    public boolean validateWorld() {
        return !Strings.isNullOrEmpty((String)this.world) && this.getBukkitWorld() != null;
    }

    public double distanceSquared(@NonNull SimpleLocation location) {
        return Math.sqrt(this.distance(location));
    }

    public double distanceSquared(@NonNull org.bukkit.Location location) {
        return Math.sqrt(this.distance(location));
    }

    public double distance(@NonNull SimpleLocation location) {
        Objects.requireNonNull(location, "Cannot check distance between a null location");
        if (!Objects.equals(this.world, location.world)) {
            throw new IllegalArgumentException("Cannot measure distance between " + this.world + " and " + location.world);
        }
        return this.distanceIgnoreWorld(location);
    }

    public double distanceIgnoreWorld(@NonNull SimpleLocation location) {
        Objects.requireNonNull(location, "Cannot check distance between a null location");
        return SimpleLocation.square(this.x - location.x) + SimpleLocation.square(this.y - location.y) + SimpleLocation.square(this.z - location.z);
    }

    public double distanceSquaredIgnoreWorld(@NonNull SimpleLocation location) {
        Objects.requireNonNull(location, "Cannot check distance between a null location");
        return Math.sqrt(this.distanceIgnoreWorld(location));
    }

    public double distance(@NonNull org.bukkit.Location location) {
        Objects.requireNonNull(location, "Cannot check distance between a null location");
        World locWorld = location.getWorld();
        if (locWorld != null) {
            if (!locWorld.getName().equals(this.world)) {
                throw new IllegalArgumentException("Cannot measure distance between " + this.world + " and " + locWorld.getName());
            }
            return NumberConversions.square((double)((double)this.x - location.getX())) + NumberConversions.square((double)((double)this.y - location.getY())) + NumberConversions.square((double)((double)this.z - location.getZ()));
        }
        throw new IllegalArgumentException("Cannot measure distance to a null world");
    }

    public @NonNull org.bukkit.Location toBukkitLocation(World world) {
        return new org.bukkit.Location(world, (double)this.x, (double)this.y, (double)this.z);
    }

    public @NonNull org.bukkit.Location toBukkitLocation() {
        return this.toBukkitLocation(this.getBukkitWorld());
    }

    public static SimpleLocation fromString(@NotNull String str) {
        CommaDataSplitStrategy data = new CommaDataSplitStrategy(str, 4);
        String world = data.nextString();
        int x = data.nextInt();
        int y = data.nextInt();
        int z = data.nextInt();
        return new SimpleLocation(world, x, y, z);
    }

    @Override
    @NotNull
    public String asDataString() {
        return CommaDataSplitStrategy.toString(this.world, this.x, this.y, this.z);
    }
}

