/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building.singleblocked;

import java.time.Duration;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingArchitect;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.BuildingDemolition;
import org.kingdoms.constants.land.building.BuildingDeserializationContext;
import org.kingdoms.constants.land.building.Region;
import org.kingdoms.constants.land.building.RegionFilter;
import org.kingdoms.constants.land.building.base.AbstractBuilding;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.constants.land.building.singleblocked.SingleBlockedBuildingConstruction;
import org.kingdoms.constants.land.building.singleblocked.SingleBlockedRegion;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Direction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuilding;", "Lorg/kingdoms/constants/land/building/base/AbstractBuilding;", "origin", "Lorg/kingdoms/server/location/BlockLocation3;", "facing", "Lorg/kingdoms/server/location/Direction;", "settings", "Lorg/kingdoms/constants/land/building/info/BuildingSettings;", "<init>", "(Lorg/kingdoms/server/location/BlockLocation3;Lorg/kingdoms/server/location/Direction;Lorg/kingdoms/constants/land/building/info/BuildingSettings;)V", "demolish", "Lorg/kingdoms/constants/land/building/BuildingDemolition;", "filter", "Lorg/kingdoms/constants/land/building/RegionFilter;", "hashCode", "", "equals", "", "other", "", "_region", "Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedRegion;", "getRegion", "Lorg/kingdoms/constants/land/building/Region;", "getArchitect", "Lorg/kingdoms/constants/land/building/BuildingArchitect;", "Arch", "core"})
public final class SingleBlockedBuilding
extends AbstractBuilding {
    @NotNull
    private final SingleBlockedRegion _region;

    public SingleBlockedBuilding(@NotNull BlockLocation3 origin, @NotNull Direction facing, @NotNull BuildingSettings settings) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(origin, facing, settings);
        this._region = new SingleBlockedRegion(BlockVector3.Companion.of(origin));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public BuildingDemolition demolish(@Nullable RegionFilter filter) {
        void var2_2;
        BlockLocation3 blockLocation3 = this.getOrigin$core();
        Direction direction = this.getFacing$core();
        Duration duration = Duration.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ZERO");
        SingleBlockedBuildingConstruction it = new SingleBlockedBuildingConstruction(blockLocation3, BuildingConstructionType.DEMOLISHING, BuildingConstructionState.NONE, direction, duration, false);
        boolean bl = false;
        it.prepare(this.getSettings$core());
        return (BuildingDemolition)var2_2;
    }

    public int hashCode() {
        return this.getOrigin$core().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof BlockLocation3 && Intrinsics.areEqual((Object)this.getOrigin$core(), (Object)other);
    }

    @Override
    @NotNull
    public Region getRegion() {
        return this._region;
    }

    @Override
    @NotNull
    public BuildingArchitect getArchitect() {
        return Arch.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0015\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/constants/land/building/singleblocked/SingleBlockedBuilding$Arch;", "Lorg/kingdoms/constants/land/building/BuildingArchitect;", "<init>", "()V", "NAMESPACE", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "getNamespace", "deserialize", "Lorg/kingdoms/constants/land/building/Building;", "context", "Lorg/kingdoms/constants/land/building/BuildingDeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "core"})
    public static final class Arch
    implements BuildingArchitect {
        @NotNull
        public static final Arch INSTANCE = new Arch();
        @JvmField
        @NotNull
        public static final Namespace NAMESPACE;

        private Arch() {
        }

        @Override
        @NotNull
        public Namespace getNamespace() {
            return NAMESPACE;
        }

        @Override
        @NotNull
        public Building deserialize(@NotNull BuildingDeserializationContext<SectionableDataGetter> context) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            SectionableDataGetter $this$deserialize_u24lambda_u240 = (SectionableDataGetter)context.getDataProvider();
            boolean bl = false;
            BlockLocation3 origin = context.getOrigin();
            String string = $this$deserialize_u24lambda_u240.getString("facing");
            if (string == null) {
                string = "NORTH";
            }
            Direction direction = Direction.Companion.fromString(string);
            Intrinsics.checkNotNull((Object)direction);
            Direction facing = direction;
            return new SingleBlockedBuilding(origin, facing, context.getSettings());
        }

        static {
            Namespace namespace = Namespace.kingdoms("SINGLE_BLOCKED_FINISHED");
            Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
            NAMESPACE = namespace;
        }
    }
}

