/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building.info.block;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.TileState;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.kingdoms.constants.land.building.info.block.AbstractBlockInfo;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.Direction;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/constants/land/building/info/block/BlockDataStateBlockInfo;", "Lorg/kingdoms/constants/land/building/info/block/AbstractBlockInfo;", "skull", "Lorg/kingdoms/libs/xseries/profiles/objects/Profileable;", "blockdata", "Lorg/bukkit/block/data/BlockData;", "blockState", "Lorg/bukkit/block/BlockState;", "direction", "Lorg/kingdoms/server/location/Direction;", "<init>", "(Lcom/cryptomorin/xseries/profiles/objects/Profileable;Lorg/bukkit/block/data/BlockData;Lorg/bukkit/block/BlockState;Lorg/kingdoms/server/location/Direction;)V", "sendBlockUpdate", "", "location", "Lorg/kingdoms/server/location/BlockLocation3;", "player", "Lorg/bukkit/entity/Player;", "changeBlock", "block", "Lorg/bukkit/block/Block;", "getBlockData", "core"})
public final class BlockDataStateBlockInfo
extends AbstractBlockInfo {
    @NotNull
    private final BlockData blockdata;
    @NotNull
    private final BlockState blockState;

    public BlockDataStateBlockInfo(@Nullable Profileable skull, @NotNull BlockData blockdata, @NotNull BlockState blockState, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)blockdata, (String)"blockdata");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        super(skull, direction);
        this.blockdata = blockdata;
        this.blockState = blockState;
    }

    @Override
    public void sendBlockUpdate(@NotNull BlockLocation3 location, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Location bukkitLoc = BukkitAdapter.adapt(location);
        player.sendBlockChange(bukkitLoc, this.blockdata);
        if (this.blockState instanceof TileState) {
            player.sendBlockUpdate(bukkitLoc, (TileState)this.blockState);
        }
    }

    @Override
    public void changeBlock(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        block.setBlockData(this.blockdata);
        super.changeBlock(block);
    }

    @Override
    @NotNull
    public BlockData getBlockData() {
        return this.blockdata;
    }
}

