/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building.base;

import java.time.Duration;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionException;
import org.kingdoms.constants.land.building.BuildingConstructionListener;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.BuildingDemolition;
import org.kingdoms.constants.land.building.RegionFilter;
import org.kingdoms.constants.land.building.base.AbstractBuilding;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.functions.Function0;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.DelayedTask;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.Direction;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.time.TimeExtensions;
import org.kingdoms.utils.time.stopwatch.Stopwatch;
import org.kingdoms.utils.time.stopwatch.StopwatchState;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010@\u001a\u00020AJ\u0006\u0010B\u001a\u00020AJ\u0010\u0010C\u001a\u00020A2\u0006\u0010D\u001a\u00020\tH\u0002J\b\u0010E\u001a\u00020AH\u0005J\b\u0010F\u001a\u00020AH\u0005J\u0010\u0010G\u001a\u00020A2\u0006\u0010H\u001a\u00020IH\u0017J\b\u0010J\u001a\u00020AH\u0016J\b\u0010K\u001a\u00020%H\u0016J\u001a\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020O2\n\b\u0002\u0010P\u001a\u0004\u0018\u00010\u001dJ-\u0010Q\u001a\u00020A2\u0006\u0010R\u001a\u00020%2\f\u0010S\u001a\b\u0012\u0004\u0012\u00020O0TH\u0086\b\u00f8\u0001\u0000\u0082\u0002\b\n\u0006\b\u0000\u001a\u0002\u0010\u0001J\b\u0010U\u001a\u00020%H'J\b\u0010V\u001a\u00020AH\u0002J\b\u0010W\u001a\u00020AH\u0002J\b\u0010X\u001a\u00020AH\u0002J\b\u0010Y\u001a\u00020AH\u0017J\b\u0010Z\u001a\u00020AH\u0017J\u0010\u0010[\u001a\u00020A2\u0006\u0010\\\u001a\u00020%H\u0002J\b\u0010]\u001a\u00020AH\u0004J\b\u0010^\u001a\u00020AH\u0017J\b\u0010_\u001a\u00020AH\u0017J\u0010\u0010`\u001a\u00020%2\u0006\u0010a\u001a\u00020;H\u0017J\u0010\u0010b\u001a\u00020%2\u0006\u0010a\u001a\u00020;H\u0017J\b\u0010c\u001a\u00020dH\u0016J\u0013\u0010e\u001a\u00020%2\b\u0010f\u001a\u0004\u0018\u00010OH\u0096\u0002J\u0006\u0010g\u001a\u00020\u0007J\u0006\u0010h\u001a\u00020\tJ\u0006\u0010i\u001a\u00020%J\b\u0010j\u001a\u00020AH\u0016J\u000e\u0010k\u001a\u00020A2\u0006\u0010l\u001a\u00020\u001cJ\u0006\u0010m\u001a\u00020\u000fJ\u0006\u0010n\u001a\u00020\u000fJ\u0006\u0010o\u001a\u00020%J\b\u0010p\u001a\u00020qH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R \u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010+\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\tX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u0015\"\u0004\b2\u0010\u0017R\u001c\u00103\u001a\u0004\u0018\u000104X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R \u00109\u001a\b\u0012\u0004\u0012\u00020;0:X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006r"}, d2={"Lorg/kingdoms/constants/land/building/base/AbstractBuildingConstruction;", "Lorg/kingdoms/constants/land/building/base/AbstractBuilding;", "Lorg/kingdoms/constants/land/building/BuildingConstruction;", "Lorg/kingdoms/constants/land/building/BuildingDemolition;", "origin", "Lorg/kingdoms/server/location/BlockLocation3;", "type", "Lorg/kingdoms/constants/land/building/BuildingConstructionType;", "state", "Lorg/kingdoms/constants/land/building/BuildingConstructionState;", "regionFilter", "Lorg/kingdoms/constants/land/building/RegionFilter;", "facing", "Lorg/kingdoms/server/location/Direction;", "timePassed", "Ljava/time/Duration;", "<init>", "(Lorg/kingdoms/server/location/BlockLocation3;Lorg/kingdoms/constants/land/building/BuildingConstructionType;Lorg/kingdoms/constants/land/building/BuildingConstructionState;Lorg/kingdoms/constants/land/building/RegionFilter;Lorg/kingdoms/server/location/Direction;Ljava/time/Duration;)V", "getType$core", "()Lorg/kingdoms/constants/land/building/BuildingConstructionType;", "getState$core", "()Lorg/kingdoms/constants/land/building/BuildingConstructionState;", "setState$core", "(Lorg/kingdoms/constants/land/building/BuildingConstructionState;)V", "getRegionFilter", "()Lorg/kingdoms/constants/land/building/RegionFilter;", "listeners", "", "Lorg/kingdoms/constants/land/building/BuildingConstructionListener;", "", "getListeners", "()Ljava/util/Map;", "stopwatch", "Lorg/kingdoms/utils/time/stopwatch/Stopwatch;", "getStopwatch", "()Lorg/kingdoms/utils/time/stopwatch/Stopwatch;", "timerFinished", "", "getTimerFinished", "()Z", "setTimerFinished", "(Z)V", "buildingDuration", "lastStateChange", "getLastStateChange", "()Ljava/lang/Throwable;", "setLastStateChange", "(Ljava/lang/Throwable;)V", "lastState", "getLastState$core", "setLastState$core", "finishTimerTask", "Lorg/kingdoms/scheduler/DelayedTask;", "getFinishTimerTask", "()Lorg/kingdoms/scheduler/DelayedTask;", "setFinishTimerTask", "(Lorg/kingdoms/scheduler/DelayedTask;)V", "missingChunks", "", "Lorg/kingdoms/server/location/BlockVector2;", "getMissingChunks", "()Ljava/util/Set;", "setMissingChunks", "(Ljava/util/Set;)V", "ensurePrepared", "", "ensureNotPreview", "setState", "newState", "prepareForDemolition", "prepareAsFinished", "prepare", "settings", "Lorg/kingdoms/constants/land/building/info/BuildingSettings;", "unload", "areChunksLoaded", "error", "", "message", "", "cause", "require", "value", "lazyMessage", "Lorg/kingdoms/libs/kotlin/Function0;", "onTimerFinish", "startTimerFinishTask", "finishTask", "stopTimerTask", "start", "resume", "build", "started", "prefinishInstantly", "finish", "pause", "onChunkLoad", "chunk", "onChunkUnload", "hashCode", "", "equals", "other", "getType", "getState", "isLoaded", "continueLastState", "addListener", "listener", "getTimePassed", "getDuration", "isInstant", "toString", "", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractBuildingConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBuildingConstruction.kt\norg/kingdoms/constants/land/building/base/AbstractBuildingConstruction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n126#1,5:288\n126#1,5:293\n126#1,5:298\n126#1,5:303\n126#1,5:308\n126#1,5:313\n126#1,5:318\n126#1,5:323\n126#1,5:328\n126#1,5:333\n126#1,5:339\n126#1,5:348\n1#2:338\n1863#3,2:344\n1863#3,2:346\n*S KotlinDebug\n*F\n+ 1 AbstractBuildingConstruction.kt\norg/kingdoms/constants/land/building/base/AbstractBuildingConstruction\n*L\n42#1:288,5\n46#1:293,5\n50#1:298,5\n70#1:303,5\n71#1:308,5\n88#1:313,5\n144#1:318,5\n145#1:323,5\n146#1:328,5\n161#1:333,5\n200#1:339,5\n254#1:348,5\n232#1:344,2\n240#1:346,2\n*E\n"})
public abstract class AbstractBuildingConstruction
extends AbstractBuilding
implements BuildingConstruction,
BuildingDemolition {
    @NotNull
    private final BuildingConstructionType type;
    @NotNull
    private BuildingConstructionState state;
    @Nullable
    private final RegionFilter regionFilter;
    @NotNull
    private final Map<BuildingConstructionListener, Throwable> listeners;
    @NotNull
    private final Stopwatch stopwatch;
    private boolean timerFinished;
    private Duration buildingDuration;
    @Nullable
    private Throwable lastStateChange;
    @NotNull
    private BuildingConstructionState lastState;
    @Nullable
    private DelayedTask finishTimerTask;
    @NotNull
    private Set<BlockVector2> missingChunks;

    /*
     * WARNING - void declaration
     */
    public AbstractBuildingConstruction(@NotNull BlockLocation3 origin, @NotNull BuildingConstructionType type, @NotNull BuildingConstructionState state, @Nullable RegionFilter regionFilter, @NotNull Direction facing, @NotNull Duration timePassed) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)timePassed, (String)"timePassed");
        super(origin, facing, null, 4, null);
        this.type = type;
        this.state = state;
        this.regionFilter = regionFilter;
        this.listeners = new IdentityHashMap();
        this.stopwatch = Stopwatch.Companion.withMillisAccuracy(timePassed);
        this.lastState = BuildingConstructionState.NONE;
        this.missingChunks = new HashSet();
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state != BuildingConstructionState.CANCELLED;
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Cannot create building construction in this state: " + (Object)((Object)this.state);
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final BuildingConstructionType getType$core() {
        return this.type;
    }

    @NotNull
    public final BuildingConstructionState getState$core() {
        return this.state;
    }

    public final void setState$core(@NotNull BuildingConstructionState buildingConstructionState) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildingConstructionState), (String)"<set-?>");
        this.state = buildingConstructionState;
    }

    @Nullable
    public final RegionFilter getRegionFilter() {
        return this.regionFilter;
    }

    @NotNull
    protected final Map<BuildingConstructionListener, Throwable> getListeners() {
        return this.listeners;
    }

    @NotNull
    protected final Stopwatch getStopwatch() {
        return this.stopwatch;
    }

    protected final boolean getTimerFinished() {
        return this.timerFinished;
    }

    protected final void setTimerFinished(boolean bl) {
        this.timerFinished = bl;
    }

    @Nullable
    public final Throwable getLastStateChange() {
        return this.lastStateChange;
    }

    public final void setLastStateChange(@Nullable Throwable throwable) {
        this.lastStateChange = throwable;
    }

    @NotNull
    public final BuildingConstructionState getLastState$core() {
        return this.lastState;
    }

    public final void setLastState$core(@NotNull BuildingConstructionState buildingConstructionState) {
        Intrinsics.checkNotNullParameter((Object)((Object)buildingConstructionState), (String)"<set-?>");
        this.lastState = buildingConstructionState;
    }

    @Nullable
    protected final DelayedTask getFinishTimerTask() {
        return this.finishTimerTask;
    }

    protected final void setFinishTimerTask(@Nullable DelayedTask delayedTask) {
        this.finishTimerTask = delayedTask;
    }

    @NotNull
    public final Set<BlockVector2> getMissingChunks() {
        return this.missingChunks;
    }

    public final void setMissingChunks(@NotNull Set<BlockVector2> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.missingChunks = set;
    }

    /*
     * WARNING - void declaration
     */
    public final void ensurePrepared() {
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state.isPrepared() && this.isLoaded();
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Not prepared yet";
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void ensureNotPreview() {
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.type != BuildingConstructionType.PREVIEW;
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Cannot construct from a preview building";
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    private final void setState(BuildingConstructionState newState) {
        if (!this.state.canChangeTo(newState)) {
            this.error("Cannot change state " + (Object)((Object)this.state) + " -> " + (Object)((Object)newState), this.lastStateChange);
            throw new KotlinNothingValueException();
        }
        this.lastStateChange = new Throwable("Last state change was here: " + (Object)((Object)this.state) + " -> " + (Object)((Object)newState));
        BuildingConstructionState currentState = this.state;
        this.state = newState;
        for (BuildingConstructionListener listener : this.listeners.keySet()) {
            listener.onStateChange(currentState, newState);
        }
    }

    @MustBeInvokedByOverriders
    protected final synchronized void prepareForDemolition() {
        AbstractBuildingConstruction this_$iv;
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state.isPrepared();
        boolean $i$f$require = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Building not prepared yet to demolish";
            AbstractBuildingConstruction.error$default(this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        value$iv = this.state != BuildingConstructionState.CANCELLED;
        $i$f$require = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Building is already prepared for demolition";
            AbstractBuildingConstruction.error$default(this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        this.setState(BuildingConstructionState.CANCELLED);
        if (this.stopwatch.getState().hasStarted()) {
            this.stopwatch.stop();
            this.stopTimerTask();
        }
    }

    /*
     * WARNING - void declaration
     */
    @MustBeInvokedByOverriders
    protected final synchronized void prepareAsFinished() {
        if (!this.getRegion().getBlocks().contains(this.getOrigin$core().toVector())) {
            KLogger.warn("The building origin point is not one of the buidling's main blocks: " + this);
        }
        this.ensurePrepared();
        this.ensureNotPreview();
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state == BuildingConstructionState.FINISHED || this.state == BuildingConstructionState.FINISHED_AWAITING_CHUNK_UPDATES;
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Building not finished yet";
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public synchronized void prepare(@NotNull BuildingSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.setSettings$core(settings);
        MathExpression mathExpression = settings.getBuildDuration().get((Object)this.type);
        Intrinsics.checkNotNull((Object)mathExpression);
        Duration duration = Duration.ofMillis((long)MathUtils.eval(mathExpression, (PlaceholderProvider)settings.getMessageContext()));
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        this.buildingDuration = TimeExtensions.assertPositive(duration);
        if (!this.isLoaded()) {
            this.lastState = this.state == BuildingConstructionState.NONE ? BuildingConstructionState.PREPARED : this.state;
            this.setState(BuildingConstructionState.AWAITING_CONTINUATION);
        } else {
            this.lastState = BuildingConstructionState.PREPARED;
            this.setState(BuildingConstructionState.PREPARED);
        }
    }

    @Override
    public void unload() {
    }

    public boolean areChunksLoaded() {
        return this.missingChunks.isEmpty();
    }

    @NotNull
    public final Void error(@NotNull Object message, @Nullable Throwable cause) {
        BuildingConstructionException buildingConstructionException;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        BuildingConstructionException $this$error_u24lambda_u246 = buildingConstructionException = new BuildingConstructionException(this, message + ": " + this, cause);
        boolean bl = false;
        if (this.lastStateChange != null) {
            $this$error_u24lambda_u246.addSuppressed(this.lastStateChange);
        }
        throw (Throwable)buildingConstructionException;
    }

    public static /* synthetic */ Void error$default(AbstractBuildingConstruction abstractBuildingConstruction, Object object, Throwable throwable, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
        }
        if ((n & 2) != 0) {
            throwable = null;
        }
        return abstractBuildingConstruction.error(object, throwable);
    }

    public final void require(boolean value, @NotNull Function0<? extends Object> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        boolean $i$f$require = false;
        if (!value) {
            Object message = lazyMessage.invoke();
            AbstractBuildingConstruction.error$default(this, message, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @ApiStatus.OverrideOnly
    public abstract boolean onTimerFinish();

    private final void startTimerFinishTask() {
        AbstractBuildingConstruction this_$iv;
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = !this.timerFinished;
        boolean $i$f$require = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Timer was alreaey ran once and finished " + this.getTimePassed() + '|' + this.getTimeRemaining();
            AbstractBuildingConstruction.error$default(this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        value$iv = this.state == BuildingConstructionState.BUILDING;
        $i$f$require = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Cannot start finish timer task in current state";
            AbstractBuildingConstruction.error$default(this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        this_$iv = this;
        value$iv = this.finishTimerTask == null;
        $i$f$require = false;
        if (!value$iv) {
            boolean bl = false;
            String message$iv = "Finish timer task already running.";
            AbstractBuildingConstruction.error$default(this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.isInstant()) {
            this.finishTask();
        } else {
            this.finishTimerTask = Kingdoms.taskScheduler().sync().delayed(this.getTimeRemaining(), this::finishTask);
        }
    }

    private final void finishTask() {
        this.timerFinished = true;
        boolean isFinished = this.onTimerFinish();
        if (isFinished) {
            this.finish();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void stopTimerTask() {
        this.ensurePrepared();
        this.ensureNotPreview();
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state != BuildingConstructionState.BUILDING;
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Cannot stop finish timer task in current state";
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        if (this.finishTimerTask == null) {
            boolean bl = false;
            String string = "Finish timer task is not running.";
            throw new IllegalArgumentException(string.toString());
        }
        DelayedTask delayedTask = this.finishTimerTask;
        Intrinsics.checkNotNull((Object)delayedTask);
        delayedTask.cancel();
        this.finishTimerTask = null;
    }

    @Override
    @MustBeInvokedByOverriders
    public void start() {
        this.build(true);
    }

    @Override
    @MustBeInvokedByOverriders
    public void resume() {
        this.build(false);
    }

    private final synchronized void build(boolean started) {
        this.ensurePrepared();
        this.ensureNotPreview();
        this.setState(BuildingConstructionState.BUILDING);
        if (!this.isInstant()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.stopwatch.getState().ordinal()]) {
                case 1: {
                    Stopwatch stopwatch = this.stopwatch.start();
                    break;
                }
                case 2: {
                    Stopwatch stopwatch = this.stopwatch.resume();
                    break;
                }
                default: {
                    AbstractBuildingConstruction.error$default(this, "Unexpected stopwatch state: " + this.stopwatch, null, 2, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        this.startTimerFinishTask();
    }

    /*
     * WARNING - void declaration
     */
    protected final void prefinishInstantly() {
        this.ensurePrepared();
        this.ensureNotPreview();
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state != BuildingConstructionState.CANCELLED;
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Cannot finish in this state: CANCELLED_FOR_DEMOLITION";
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
    }

    @MustBeInvokedByOverriders
    public synchronized void finish() {
        this.ensurePrepared();
        this.ensureNotPreview();
        BuildingConstructionState newState = !this.areChunksLoaded() ? BuildingConstructionState.FINISHED_AWAITING_CHUNK_UPDATES : BuildingConstructionState.FINISHED;
        this.setState(newState);
        this.stopwatch.stop();
        if (this.finishTimerTask != null) {
            this.stopTimerTask();
        }
    }

    @Override
    @MustBeInvokedByOverriders
    public synchronized void pause() {
        this.ensurePrepared();
        this.ensureNotPreview();
        this.setState(BuildingConstructionState.PAUSED);
        this.stopwatch.pause();
        this.stopTimerTask();
    }

    @Override
    @MustBeInvokedByOverriders
    public synchronized boolean onChunkLoad(@NotNull BlockVector2 chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.ensureNotPreview();
        this.missingChunks.remove(chunk);
        Iterable $this$forEach$iv = this.listeners.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildingConstructionListener it = (BuildingConstructionListener)element$iv;
            boolean bl = false;
            it.onChunkStateChange(chunk, true);
        }
        return this.areChunksLoaded();
    }

    @Override
    @MustBeInvokedByOverriders
    public boolean onChunkUnload(@NotNull BlockVector2 chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.ensureNotPreview();
        this.missingChunks.add(chunk);
        Iterable $this$forEach$iv = this.listeners.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BuildingConstructionListener it = (BuildingConstructionListener)element$iv;
            boolean bl = false;
            it.onChunkStateChange(chunk, false);
        }
        return this.areChunksLoaded();
    }

    public int hashCode() {
        return this.getOrigin().hashCode();
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof Building && Intrinsics.areEqual((Object)((Building)other).getOrigin(), (Object)this.getOrigin());
    }

    @Override
    @NotNull
    public final BuildingConstructionType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public final BuildingConstructionState getState() {
        return this.state;
    }

    @Override
    public final boolean isLoaded() {
        return this.lastState != BuildingConstructionState.NONE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void continueLastState() {
        AbstractBuildingConstruction abstractBuildingConstruction = this;
        boolean value$iv = this.state == BuildingConstructionState.AWAITING_CONTINUATION;
        boolean $i$f$require = false;
        if (!value$iv) {
            void this_$iv;
            boolean bl = false;
            String message$iv = "Cannot continue when not AWAITING_CONTINUATION";
            AbstractBuildingConstruction.error$default((AbstractBuildingConstruction)this_$iv, message$iv, null, 2, null);
            throw new KotlinNothingValueException();
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.lastState.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.pause();
                break;
            }
            case 4: {
                this.resume();
                break;
            }
            case 5: {
                AbstractBuildingConstruction.error$default(this, "Cannot continue a CANCELLED_FOR_DEMOLITION", null, 2, null);
                throw new KotlinNothingValueException();
            }
            case 6: 
            case 7: {
                break;
            }
            default: {
                AbstractBuildingConstruction.error$default(this, "Attempted to continue from lastState " + (Object)((Object)this.lastState), null, 2, null);
                throw new KotlinNothingValueException();
            }
        }
    }

    @Override
    public final void addListener(@NotNull BuildingConstructionListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.ensureNotPreview();
        Throwable last = this.listeners.put(listener, new Throwable());
        if (last != null) {
            throw new IllegalArgumentException("Listener " + listener + " already added to: " + this, last);
        }
    }

    @Override
    @NotNull
    public final Duration getTimePassed() {
        return TimeExtensions.assertPositive(this.stopwatch.getElapsed());
    }

    @Override
    @NotNull
    public final Duration getDuration() {
        this.ensurePrepared();
        Duration duration = this.buildingDuration;
        if (duration == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"buildingDuration");
            duration = null;
        }
        return duration;
    }

    public final boolean isInstant() {
        return this.getDuration().isZero();
    }

    @Override
    @NotNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append(this.getClass().getSimpleName()).append("(origin=").append(this.getOrigin$core()).append(", type=").append((Object)this.type).append(", lasteState=").append((Object)this.lastState).append(", state=").append((Object)this.state).append(", facing=").append(this.getFacing$core()).append(", time=").append(this.stopwatch.getElapsed()).append('/');
        if (this.buildingDuration != null) {
            object = this.buildingDuration;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"buildingDuration");
                object = null;
            }
        } else {
            object = "???";
        }
        return stringBuilder.append(object).append(", timerFinished=").append(this.timerFinished).append(", areChunksLoaded=").append(this.areChunksLoaded()).append(')').toString();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StopwatchState.values().length];
            try {
                nArray[StopwatchState.NOT_STARTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StopwatchState.PAUSED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BuildingConstructionState.values().length];
            try {
                nArray[BuildingConstructionState.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.PREPARED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.PAUSED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.BUILDING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.CANCELLED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.FINISHED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BuildingConstructionState.FINISHED_AWAITING_CHUNK_UPDATES.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

