/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.kingdoms.constants.land.building.SimpleBlockRegion;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Vector3;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0013\u0010\u0002\u001a\r\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\b\u0005H&J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0004H&J\b\u0010\t\u001a\u00020\u0004H&J\u0013\u0010\n\u001a\r\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0002\b\u0005H&J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00002\u0006\u0010\r\u001a\u00020\u0000H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/constants/land/building/Region;", "", "getBlocks", "", "Lorg/kingdoms/server/location/BlockVector3;", "Lorg/kingdoms/libs/jetbrains/annotations/UnmodifiableView;", "getCenter", "Lorg/kingdoms/server/location/Vector3;", "getMinimumPoint", "getMaximumPoint", "getChunks", "Lorg/kingdoms/server/location/BlockVector2;", "union", "other", "difference", "core"})
public interface Region {
    @NotNull
    public Set<BlockVector3> getBlocks();

    @NotNull
    public Vector3 getCenter();

    @NotNull
    public BlockVector3 getMinimumPoint();

    @NotNull
    public BlockVector3 getMaximumPoint();

    @NotNull
    public Set<BlockVector2> getChunks();

    @NotNull
    default public Region union(@NotNull Region other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Set<BlockVector3> thisBlocks = this.getBlocks();
        Set<BlockVector3> otherBlocks = other.getBlocks();
        Set newBlocks = new HashSet(thisBlocks.size() + otherBlocks.size());
        newBlocks.addAll((Collection)thisBlocks);
        newBlocks.addAll((Collection)otherBlocks);
        return new SimpleBlockRegion(newBlocks);
    }

    @Nullable
    default public Region difference(@NotNull Region other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Set<BlockVector3> thisBlocks = this.getBlocks();
        Set<BlockVector3> otherBlocks = other.getBlocks();
        HashSet diff = new HashSet((Collection)Sets.difference(thisBlocks, otherBlocks));
        return diff.isEmpty() ? null : (Region)new SimpleBlockRegion(diff);
    }
}

