/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.building;

import java.util.Set;
import org.bukkit.World;
import org.kingdoms.constants.land.building.Region;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.SetsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.BlockVector2;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.utils.MathUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/kingdoms/constants/land/building/ChunkRegion;", "Lorg/kingdoms/constants/land/building/Region;", "chunk", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "<init>", "(Lorg/kingdoms/constants/land/location/SimpleChunkLocation;)V", "getChunk", "()Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "world", "Lorg/kingdoms/server/location/World;", "getWorld", "()Lorg/kingdoms/server/location/World;", "minY", "", "getMinY", "()I", "maxY", "getMaxY", "getBlocks", "", "Lorg/kingdoms/server/location/BlockVector3;", "getCenter", "Lorg/kingdoms/server/location/Vector3;", "getMinimumPoint", "getMaximumPoint", "getChunks", "Lorg/kingdoms/server/location/BlockVector2;", "core"})
public final class ChunkRegion
implements Region {
    @NotNull
    private final SimpleChunkLocation chunk;
    @NotNull
    private final org.kingdoms.server.location.World world;
    private final int minY;
    private final int maxY;

    public ChunkRegion(@NotNull SimpleChunkLocation chunk) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.chunk = chunk;
        World world = this.chunk.getBukkitWorld();
        Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getBukkitWorld(...)");
        this.world = BukkitAdapter.adapt(world);
        this.minY = this.world.getMinHeight();
        this.maxY = this.world.getMaxHeight();
    }

    @NotNull
    public final SimpleChunkLocation getChunk() {
        return this.chunk;
    }

    @NotNull
    public final org.kingdoms.server.location.World getWorld() {
        return this.world;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    @Override
    @NotNull
    public Set<BlockVector3> getBlocks() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Vector3 getCenter() {
        int locX = (this.chunk.getX() << 4) + 8;
        int locZ = (this.chunk.getZ() << 4) + 8;
        return Vector3.Companion.of(locX, MathUtils.getMiddleNumber(this.minY, this.maxY), locZ);
    }

    @Override
    @NotNull
    public BlockVector3 getMinimumPoint() {
        return BlockVector3.Companion.of(this.chunk.getX() << 4, this.minY, this.chunk.getZ() << 4);
    }

    @Override
    @NotNull
    public BlockVector3 getMaximumPoint() {
        return BlockVector3.Companion.of((this.chunk.getX() << 4) + 16, this.maxY, (this.chunk.getZ() << 4) + 16);
    }

    @Override
    @NotNull
    public Set<BlockVector2> getChunks() {
        Object[] objectArray = new BlockVector2[]{this.chunk.toBlockVector()};
        return SetsKt.hashSetOf((Object[])objectArray);
    }
}

