/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction.data;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Consumer;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.utils.internal.arrays.UnsafeArrayList;

public final class KingdomItemDeserializationContext<I extends KingdomBuilding<S>, S extends KingdomBuildingStyle<I, S, T>, T extends KingdomBuildingType<I, S, T>> {
    private final JsonObject json;
    private final JsonDeserializationContext context;
    private final UnsafeArrayList<Consumer<I>> handlers = UnsafeArrayList.withSize(new Consumer[5]);

    public KingdomItemDeserializationContext(JsonObject json, JsonDeserializationContext context) {
        this.json = json;
        this.context = context;
    }

    public KingdomItemDeserializationContext<I, S, T> withData(Consumer<I> handler) {
        Objects.requireNonNull(handler, "Data handler cannot be null");
        this.handlers.add(handler);
        return this;
    }

    public JsonObject getJson() {
        return this.json;
    }

    public JsonDeserializationContext getContext() {
        return this.context;
    }

    public I build(S style, SimpleLocation location) {
        KingdomItemBuilder builder = new KingdomItemBuilder(style, location);
        Object item = ((KingdomBuildingType)((KingdomBuildingStyle)style).getType()).build(builder);
        for (Consumer<I> handler : this.handlers) {
            handler.accept(item);
        }
        return (I)item;
    }
}

