/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land.abstraction;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Item;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.Levellable;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.item.ItemDeserializationContext;
import org.kingdoms.constants.item.ItemSerializationContext;
import org.kingdoms.constants.item.KingdomItem;
import org.kingdoms.constants.item.KingdomItemCreateSettings;
import org.kingdoms.constants.item.KingdomItemData;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingArchitect;
import org.kingdoms.constants.land.building.BuildingArchitectRegistry;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionArchitect;
import org.kingdoms.constants.land.building.BuildingConstructionListener;
import org.kingdoms.constants.land.building.BuildingConstructionState;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.building.BuildingDemolition;
import org.kingdoms.constants.land.building.BuildingDeserializationContext;
import org.kingdoms.constants.land.building.Region;
import org.kingdoms.constants.land.building.RegionFilter;
import org.kingdoms.constants.land.building.info.BuildingFunctionalPoint;
import org.kingdoms.constants.land.building.info.BuildingSchematic;
import org.kingdoms.constants.land.building.info.BuildingSettings;
import org.kingdoms.constants.land.building.singleblocked.SingleBlockedBuilding;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.land.turrets.effects.PersistentTurretEffect;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Deserializable;
import org.kingdoms.data.Serializable;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.data.database.nbt.NBTDataProvider;
import org.kingdoms.data.handlers.DataHandlerKingdomsObject;
import org.kingdoms.data.history.DataVersion;
import org.kingdoms.events.items.KingdomBuildingFinishEvent;
import org.kingdoms.events.items.KingdomBuildingUpgradeEvent;
import org.kingdoms.events.items.KingdomItemBreakEvent;
import org.kingdoms.events.items.KingdomItemPlaceContext;
import org.kingdoms.events.items.KingdomItemPlaceEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.gui.objects.GUIOptionParser;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.MustBeInvokedByOverriders;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.placeholders.PlaceholderParts;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.GUIProtectionInterrupter;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.managers.land.distance.KingdomBuildingVisualizer;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.platform.bukkit.location.BukkitWorld;
import org.kingdoms.server.location.BlockLocation3;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.ColorUtils;
import org.kingdoms.utils.KingdomsItemDeserializer;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.TextProgressBar;
import org.kingdoms.utils.cache.single.CachedSupplier;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;

public abstract class KingdomBuilding<S extends KingdomBuildingStyle<?, ?, ?>>
extends KingdomBlock
implements Levellable,
Serializable,
Deserializable {
    protected final @NonNull S style;
    protected @IntRange(from=1L) int level = 1;
    protected Building building;
    protected double durability;
    private final boolean disabled;
    private KingdomBuildingVisualizer visualsManager;

    public KingdomBuilding(@NonNull S type, @NonNull SimpleLocation origin) {
        super(origin);
        this.style = (KingdomBuildingStyle)Objects.requireNonNull(type, "Kingdom item type cannot be null");
        this.disabled = ((KingdomBuildingStyle)this.style).getOption("disabled").getBoolean();
    }

    @Override
    public final @NonNull SimpleLocation getKey() {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        int prime = 31;
        int result = 15;
        result = prime * result + this.origin.hashCode();
        result = prime * result + this.style.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KingdomBuilding)) {
            return false;
        }
        KingdomBuilding kingdomItem = (KingdomBuilding)obj;
        return this.origin.equals(kingdomItem.origin);
    }

    public @NonNull S getStyle() {
        return this.style;
    }

    public @NonNull Block getBlock() {
        return this.origin.toBukkitLocation().getBlock();
    }

    @Override
    public void modifyData(Land land, boolean adding) {
        BlockVector3 origin = this.origin.toBlockVector();
        Map<BlockVector3, KingdomBlock> originMap = this.getDataMap(land);
        Map<BlockVector3, KingdomBlock> blockMap = land.unsafeGetKingdomBlocks();
        if (originMap == null) {
            throw new IllegalStateException("No getDataMap() nor overridden modifyData() specified for object " + this);
        }
        if (adding) {
            originMap.put(origin, this);
        } else {
            originMap.remove(origin);
        }
        for (BlockVector3 mappedBlockLocation : this.building.getRegion().getBlocks()) {
            if (adding) {
                blockMap.put(mappedBlockLocation, this);
                continue;
            }
            blockMap.remove(mappedBlockLocation);
        }
    }

    protected Map<BlockVector3, KingdomBlock> getDataMap(Land land) {
        return null;
    }

    public final KingdomItemBreakEvent<?> remove() {
        return this.remove(KingdomItemRemoveContext.DEFAULT);
    }

    public PlaceholderContextBuilder getContext() {
        Kingdom kingdom = this.getLand().getKingdom();
        return new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", this.level).raw("level", this.level);
    }

    @OverridingMethodsMustInvokeSuper
    public void onBuildFinish() {
        KingdomBuildingFinishEvent<KingdomBuilding> event = new KingdomBuildingFinishEvent<KingdomBuilding>(this);
        Kingdoms.getServerX().getEventHandler().callEvent(event);
        BuildingConstruction ctor = (BuildingConstruction)this.building;
        this.setBuilding(ctor.asFinishedBuilding());
        switch (ctor.getType()) {
            case UPGRADING: {
                ++this.level;
                this.durability = ((KingdomBuildingStyle)this.style).getMaxDurability(this.getContext());
                break;
            }
            case REPAIRING: {
                this.durability = ((KingdomBuildingStyle)this.style).getMaxDurability(this.getContext());
                break;
            }
            case DEMOLISHING: {
                Boolean removeData = (Boolean)this.building.getMetadata().get(Namespace.kingdoms("REMOVE_DATA"));
                if (removeData == null || removeData.booleanValue()) {
                    this.modifyData(this.getLand(), false);
                }
                this.invalidateObject();
                this.visualsManager.close();
                this.building = null;
                this.visualsManager = null;
            }
        }
    }

    public BuildingConstruction prepareBuilding(BuildingSchematic info) {
        BuildingArchitectRegistry archRegistry = Kingdoms.get().getBuildingArchitectRegistry();
        BuildingConstructionArchitect defaultArch = archRegistry.getDefaultArchitect();
        if (defaultArch.isSupported(info)) {
            return defaultArch.newBuilding(info);
        }
        for (BuildingArchitect arch : archRegistry.getRegistry().values()) {
            BuildingConstructionArchitect ctorArch;
            if (arch == defaultArch || !(arch instanceof BuildingConstructionArchitect) || !(ctorArch = (BuildingConstructionArchitect)arch).isSupported(info)) continue;
            return ctorArch.newBuilding(info);
        }
        throw new UnsupportedOperationException("None of the architects support " + info.getSettings().getSchematic());
    }

    @MustBeInvokedByOverriders
    public KingdomItemPlaceEvent<?> place(KingdomItemPlaceContext context) {
        ItemStack item;
        context.land = this.getLand();
        context.kingdom = context.land.getKingdom();
        KingdomItemPlaceEvent<KingdomBuilding> placeEvent = new KingdomItemPlaceEvent<KingdomBuilding>(context.getCause(), context.getPlayer(), this);
        if (context.getStartBuilding()) {
            BuildingSettings buildSettings = this.getBuildingSettings(this.level);
            BuildingSchematic info = new BuildingSchematic(BuildingConstructionType.OPENING, this.origin.toBlockVector().inWorld(new BukkitWorld(context.land.getLocation().getBukkitWorld())), context.getFacing(), buildSettings);
            this.setBuilding(this.prepareBuilding(info));
        }
        if (context.getModifier() != null) {
            context.getModifier().accept(placeEvent);
        }
        if (!placeEvent.isCancelled()) {
            Bukkit.getPluginManager().callEvent(placeEvent);
            if (placeEvent.isCancelled()) {
                if (context.getCause() instanceof Cancellable) {
                    ((Cancellable)context.getCause()).setCancelled(true);
                }
                return placeEvent;
            }
        }
        if ((item = context.getFromItem()) != null) {
            item.setAmount(item.getAmount() - 1);
        }
        if (context.getUpdateVisuals()) {
            this.getVisualsManager().updateVisuals();
        }
        if (context.getStartBuilding() && this.building instanceof BuildingConstruction) {
            BuildingConstruction ctor = (BuildingConstruction)this.building;
            ctor.start();
            ctor.onChunkLoad(this.origin.toSimpleChunkLocation().toBlockVector());
        }
        return placeEvent;
    }

    public KingdomBuildingVisualizer getVisualsManager() {
        this.ensureObjectExpiration();
        Objects.requireNonNull(this.building, "Cannot get visual manager with empty building");
        if (this.visualsManager == null) {
            this.visualsManager = new KingdomBuildingVisualizer(this);
        }
        return this.visualsManager;
    }

    @MustBeInvokedByOverriders
    public @NonNull KingdomItemBreakEvent<?> remove(KingdomItemRemoveContext context) {
        List gui;
        KingdomItemBreakEvent<KingdomBuilding> event = new KingdomItemBreakEvent<KingdomBuilding>(context.getCause(), context.getPlayer(), this, context.getDropsItem());
        if (context.getModifier() != null) {
            context.getModifier().accept(event);
        }
        if (!event.isCancelled()) {
            Bukkit.getPluginManager().callEvent(event);
            if (event.isCancelled()) {
                if (context.getCause() instanceof Cancellable) {
                    ((Cancellable)context.getCause()).setCancelled(true);
                }
                return event;
            }
        }
        Location location = this.origin.toBukkitLocation();
        if (context.getReplaceBlock()) {
            Block block = location.getBlock();
            block.setType(Material.AIR);
        }
        if (event.dropsItem()) {
            this.dropItem(location, new KingdomItemCreateSettings(this.getLand().getKingdom(), context.getPlayer()));
        }
        this.building.getMetadata().put(Namespace.kingdoms("REMOVE_DATA"), (Object)context.getRemoveData());
        if (context.getPlaySound()) {
            ConfigPath path = ConfigPath.of("demolition", "started");
            this.playSound(this.origin.toBukkitLocation(), path);
            this.getParticleDisplay(path);
        }
        BuildingDemolition demolition = this.building.demolish(null);
        this.setBuilding(demolition);
        demolition.start();
        demolition.onChunkLoad(this.origin.toSimpleChunkLocation().toBlockVector());
        if (context.getRemoveInstantly()) {
            demolition.finishInstantly();
        }
        if ((gui = (List)GUIProtectionInterrupter.OPENED_GUI.remove(this.origin)) != null) {
            gui.forEach(HumanEntity::closeInventory);
        }
        return event;
    }

    public void dropItem(Location location, KingdomItemCreateSettings settings) {
        if (!((KingdomBuildingStyle)this.style).hasItem()) {
            return;
        }
        KingdomItem itemStack = this.getItem(settings);
        Item item = location.getWorld().dropItemNaturally(location, itemStack.getItem());
        ((KingdomBuildingStyle)this.style).droppedItemName(item);
    }

    @Override
    @MustBeInvokedByOverriders
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        SectionableDataSetter provider = context.getDataProvider();
        provider.setString("type", ((KingdomBuildingStyle)this.style).getName());
        provider.setInt("level", this.level);
        if (this.building != null) {
            this.building.serialize(context.createFor(provider.createSection("building")));
        }
        if (this.durability < ((KingdomBuildingStyle)this.style).getMaxDurability(this.getContext())) {
            provider.setDouble("durability", this.durability);
        } else if (this.durability <= 0.0) {
            provider.setDouble("durability", -1.0);
        }
        DataHandlerKingdomsObject.save(provider, this);
    }

    @Override
    @MustBeInvokedByOverriders
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        SectionableDataGetter provider = context.getDataProvider();
        this.level = provider.getInt("level");
        this.durability = provider.getInt("durability");
        if (!(context instanceof ItemDeserializationContext)) {
            SectionableDataGetter buildingSection = provider.get("building").asSection();
            String archName = buildingSection.getString("architect");
            if (archName == null && DataVersion.getCurrentVersion() == DataVersion.VERSION_0) {
                archName = SingleBlockedBuilding.Arch.NAMESPACE.asNormalizedString();
            }
            if (archName != null) {
                @NonNull Namespace buildingArchitectNS = Namespace.fromString(archName);
                BuildingArchitect arch = (BuildingArchitect)((Object)Kingdoms.get().getBuildingArchitectRegistry().getRegistered(buildingArchitectNS));
                if (arch == null) {
                    throw new IllegalStateException("Unknown building architect '" + buildingArchitectNS + "' for building " + this);
                }
                BlockLocation3 immOrigin = BlockLocation3.of(BukkitAdapter.adapt(this.origin.getBukkitWorld()), this.origin.getX(), this.origin.getY(), this.origin.getZ());
                try {
                    this.setBuilding(arch.deserialize(new BuildingDeserializationContext<SectionableDataGetter>(immOrigin, this.getBuildingSettings(this.level), buildingSection)));
                }
                catch (Throwable ex) {
                    throw new RuntimeException("Error while deserializing the building for " + ((KingdomBuildingStyle)this.style).name + " at " + this.origin + " with arch " + arch, ex);
                }
            } else {
                throw new IllegalStateException("No building data defined for building " + this);
            }
        }
        DataHandlerKingdomsObject.load(provider, this);
    }

    public boolean isEnabled() {
        return true;
    }

    public double getDurability() {
        if (this.durability == 0.0) {
            this.durability = ((KingdomBuildingStyle)this.style).getMaxDurability(this.getContext());
        }
        return this.durability;
    }

    public void setDurability(double durability) {
        this.durability = durability;
    }

    public void playSound(String sound) {
        this.playSound(this.origin.toBukkitLocation(), sound);
    }

    public void playSound(Location location, String sound) {
        ConfigAccessor section = ((KingdomBuildingStyle)this.style).getOption("sounds").getSection();
        if (section == null) {
            return;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor sounds = section.gotoSection(String.valueOf(entry));
        if (sounds != null) {
            XSound.play((String)sounds.getString(sound), x -> x.atLocation(location));
        }
    }

    public void playSound(Location location, ConfigPath sound) {
        ConfigAccessor section = ((KingdomBuildingStyle)this.style).getOption("sounds").getSection();
        if (section == null) {
            return;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level, sound);
        ConfigAccessor sounds = section.gotoSection(String.valueOf(entry));
        if (sounds != null) {
            XSound.play((String)sounds.getString(sound.getPath()), x -> x.atLocation(location));
        }
    }

    public BuildingSettings getBuildingSettings(int level) {
        int previewLvl;
        ConfigSection previewSettings;
        ConfigAccessor section = ((KingdomBuildingStyle)this.style).getOption("building").getSection();
        Objects.requireNonNull(section, () -> "Building section null for " + ((KingdomBuildingStyle)this.style).name + " -> " + level);
        Supplier<MessagePlaceholderProvider> context = this::getMessageContext;
        int entry = KingdomsConfig.getClosestLevelSection(section, level);
        ConfigSection buildingSection = section.getSection().getSection(String.valueOf(entry));
        Objects.requireNonNull(buildingSection, () -> "Levelled building section null for " + ((KingdomBuildingStyle)this.style).name + " -> '" + level + "' ");
        String schematic = buildingSection.getString("schematic");
        ConfigSection functionalPointsOpt = buildingSection.getSection("functional-points");
        HashMap functionalPoints = new HashMap();
        if (functionalPointsOpt != null) {
            for (String interactPos : functionalPointsOpt.getKeys()) {
                BlockVector3 relativePos = BlockVector3.fromString(interactPos);
                BlockVector3 absolutePos = relativePos.add(this.origin.getX(), this.origin.getY(), this.origin.getZ());
                ArrayList<BuildingFunctionalPoint> fnPoints = new ArrayList<BuildingFunctionalPoint>();
                List<ConfigSection> fnPointOpts = functionalPointsOpt.get(NodeInterpreter.SECTION_LIST, interactPos);
                for (ConfigSection fnPointOpt : fnPointOpts) {
                    String type = fnPointOpt.getString("type");
                    String name = fnPointOpt.getString("name");
                    fnPoints.add(new BuildingFunctionalPoint(absolutePos, type, name));
                }
                functionalPoints.put(absolutePos, fnPoints);
            }
        }
        ConfigSection hologramsOption = buildingSection.getSection("holograms");
        HashMap holograms = new HashMap();
        if (hologramsOption != null) {
            for (String key : hologramsOption.getKeys()) {
                ConfigSection subHologram = hologramsOption.getSection(key);
                HashMap<String, GroupedHologram> subHolograms = new HashMap<String, GroupedHologram>();
                for (String subHologramKey : subHologram.getKeys()) {
                    ConfigSection hologram = subHologram.getSection(subHologramKey);
                    subHolograms.put(subHologramKey, GroupedHologram.parse(hologram));
                }
                holograms.put(key, subHolograms);
            }
        }
        ConfigAccessor previewCfg = ((KingdomBuildingStyle)this.style).getOption("preview").getSection();
        HashMap<String, BuildingSettings.Validation> previewSettingsMap = new HashMap<String, BuildingSettings.Validation>();
        if (previewCfg != null && (previewSettings = previewCfg.gotoSection(String.valueOf(previewLvl = KingdomsConfig.getClosestLevelSection(previewCfg, level))).getSection()) != null) {
            for (String key : previewSettings.getKeys()) {
                ConfigSection previewSection = previewSettings.getSection(key);
                String langEntry = previewSection.getString("message");
                ConfigSection block = previewSection.getSection("block");
                String color = previewSection.getString("color");
                String type = previewSection.getString("type");
                BuildingSettings.Validation settings = new BuildingSettings.Validation(type == null ? BuildingSettings.ValidationType.ERROR : (BuildingSettings.ValidationType)((Object)Enums.getIfPresent(BuildingSettings.ValidationType.class, (String)type).or((Object)BuildingSettings.ValidationType.ERROR)), langEntry == null ? null : LanguageEntryMessenger.of(langEntry).safe(), block == null ? null : (XMaterial)XMaterial.matchXMaterial((String)block.getString("material")).orElse(null), color == null ? null : ColorUtils.parseColor(color), previewSection);
                previewSettingsMap.put(key, settings);
            }
        }
        EnumMap<BuildingConstructionType, MathExpression> buildingDurations = new EnumMap<BuildingConstructionType, MathExpression>(BuildingConstructionType.class);
        for (BuildingConstructionType type : BuildingConstructionType.getEntries()) {
            buildingDurations.put(type, ((KingdomBuildingStyle)this.style).getBuildDuration(type));
        }
        return new BuildingSettings(schematic, buildingDurations, holograms, context, previewSettingsMap, functionalPoints, buildingSection);
    }

    public void displayParticle(String particle) {
        this.displayParticle(this.origin.toBukkitLocation(), particle);
    }

    public void displayParticle(Location location, String particle) {
        Objects.requireNonNull(location, "Cannot display particle at null location");
        ParticleDisplay display = this.getParticleDisplay(ConfigPath.of(particle));
        if (display != null) {
            display.spawn(location.add(0.5, 0.0, 0.5));
        }
    }

    public ParticleDisplay getParticleDisplay(ConfigPath path) {
        ConfigAccessor finalSection;
        ConfigAccessor section = ((KingdomBuildingStyle)this.style).getOption("particles").getSection();
        if (section == null) {
            return null;
        }
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level, path);
        ConfigAccessor particles = section.gotoSection(String.valueOf(entry));
        if (particles != null && (finalSection = particles.gotoSection(path.getPath())) != null) {
            return ParticleDisplay.fromConfig((ConfigurationSection)finalSection.toBukkitConfigurationSection()).withLocation(this.getOrigin().toBukkitLocation());
        }
        return null;
    }

    public KingdomItem getItem(@NotNull KingdomItemCreateSettings settings) {
        ConfigAccessor section = Objects.requireNonNull(((KingdomBuildingStyle)this.style).getOption("item").getSection(), "Calling getTags() before checking hasItem()");
        int entry = KingdomsConfig.getClosestLevelSection(section, this.level);
        ConfigAccessor itemSection = section.gotoSection(String.valueOf(entry)).noDefault();
        ItemStack item0 = new KingdomsItemDeserializer().withSection(itemSection).withContext(this.addMessageContextEdits(new MessagePlaceholderProvider(), settings.getOwningKingdom())).withRestart(ex -> {
            XItemStack.UnAcceptableMaterialCondition cond;
            if (ex instanceof XItemStack.UnAcceptableMaterialCondition && (cond = (XItemStack.UnAcceptableMaterialCondition)ex).getReason() == XItemStack.UnAcceptableMaterialCondition.Reason.UNSUPPORTED) {
                cond.setSolution(GUIOptionParser.unsupportedMaterial(cond.getMaterial()));
            }
        }).deserialize();
        KingdomItem kingdomItem = KingdomItem.createKingdomItem(item0);
        KingdomItemData data = KingdomItemData.createEmpty(this.getKingdomBlockHandler().getNamespace());
        kingdomItem.addData(data);
        NBTTagCompound nbt = NBTTagCompound.empty();
        data.setData(nbt);
        if (settings.getOwningKingdom() != null) {
            nbt.set("kingdom", settings.getOwningKingdom().getId().toString());
        }
        if (settings.getRequestedBy() != null) {
            data.setCreatedBy(settings.getRequestedBy().getId());
        }
        this.serialize(new ItemSerializationContext<SectionableDataSetter>(new NBTDataProvider(nbt), kingdomItem, nbt));
        kingdomItem.applyChanges();
        return kingdomItem;
    }

    @MustBeInvokedByOverriders
    public MessagePlaceholderProvider addMessageContextEdits(MessagePlaceholderProvider context, Kingdom kingdom) {
        ((MessagePlaceholderProvider)((MessagePlaceholderProvider)context.withContext(kingdom).ensurePlaceholdersCapacity(40).raw("name", () -> this.style.getDisplayName())).raw("level", this.level).raw("next_level", this.level + 1).raw("max_level", () -> this.getMaxLevel(kingdom))).raw("upgrade_cost", () -> this.getUpgradeCost(kingdom));
        context.addChild("building", () -> {
            PlaceholderContextBuilder ctx = new PlaceholderContextBuilder();
            ctx.raw("displayname", () -> this.style.getDisplayName()).raw("level", this.level).raw("next_level", this.level + 1).raw("max_level", () -> this.getMaxLevel(kingdom)).raw("upgrade_cost", () -> this.getUpgradeCost(kingdom)).raw("durability", this.getDurability()).raw("max_durability", () -> ((KingdomBuildingStyle)this.style).getMaxDurability(ctx)).raw("region_blocks", this.building == null ? null : Integer.valueOf(this.building.getRegion().getBlocks().size()));
            if (this instanceof Turret) {
                ctx.addChild("effects", () -> new PlaceholderProvider(){

                    @Override
                    public Object providePlaceholder(String placeholder) {
                        String namespace;
                        Turret turret = (Turret)KingdomBuilding.this;
                        PlaceholderParts parts = new PlaceholderParts(placeholder);
                        if (!parts.isTerminal()) {
                            namespace = parts.getId();
                            placeholder = parts.getParameterFrom(1);
                        } else {
                            namespace = placeholder;
                            placeholder = null;
                        }
                        Optional effect = turret.getEffect(Namespace.fromString(namespace.toUpperCase(Locale.ENGLISH)));
                        if (placeholder == null) {
                            return effect.isPresent();
                        }
                        if (!effect.isPresent()) {
                            return null;
                        }
                        Object provided = ((PersistentTurretEffect)effect.get()).getMessageContext().providePlaceholder(placeholder);
                        return provided;
                    }
                });
            }
            if (this.building != null) {
                ctx.raw("is_under_construction", this.building.isUnderConstruction());
                if (this.building instanceof BuildingConstruction) {
                    BuildingConstruction construction = (BuildingConstruction)this.building;
                    CachedSupplier<Long> duration = CachedSupplier.of(() -> construction.getDuration().toMillis());
                    ctx.raw("type", construction.getType().name()).raw("state", construction.getState().name()).raw("duration", duration).raw("time_passed", construction::getTimePassed).raw("time_remaining", construction::getTimeRemaining).raw("progress_bar", () -> {
                        long dur = (Long)duration.get();
                        double progress = dur <= 0L ? 1.0 : (double)Math.min(construction.getTimePassed().toMillis(), dur) / (double)dur;
                        return new TextProgressBar(progress, 50).progressMessage();
                    });
                }
            }
            return ctx;
        });
        return context;
    }

    @Override
    public final void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        this.addMessageContextEdits(context, this.getLand().getKingdom());
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    public KingdomBuildingUpgradeEvent upgrade(int newLevel, long paidResourcePoints, KingdomPlayer by) {
        if (newLevel <= this.level) {
            throw new IllegalArgumentException("New level is equal or less than the current level: " + newLevel + " <= " + this.level);
        }
        KingdomBuildingUpgradeEvent upgradeEvent = new KingdomBuildingUpgradeEvent(this, this.level, newLevel, paidResourcePoints, by);
        Bukkit.getPluginManager().callEvent((Event)upgradeEvent);
        if (upgradeEvent.isCancelled()) {
            return upgradeEvent;
        }
        if (this.building instanceof BuildingConstruction) {
            throw new IllegalStateException("Cannot upgrade in current building state: " + this.building);
        }
        BuildingSchematic info = new BuildingSchematic(BuildingConstructionType.UPGRADING, this.building.getOrigin(), this.building.getFacing(), this.getBuildingSettings(newLevel));
        BuildingConstruction ctor = this.prepareBuilding(info);
        final Region toRemove = this.building.getRegion().difference(ctor.getRegion());
        final Land land = this.getLand();
        if (toRemove != null) {
            BuildingDemolition demolition = this.building.demolish(new RegionFilter(){

                @Override
                public boolean filter(@NotNull BlockVector3 block) {
                    return toRemove.getBlocks().contains(block);
                }
            });
            demolition.start();
            demolition.onChunkLoad(this.origin.toSimpleChunkLocation().toBlockVector());
            ctor.addListener(new BuildingConstructionListener(){

                @Override
                public @NonNull Namespace getNamespace() {
                    return Namespace.kingdoms("UPGRADE_UNION");
                }

                @Override
                public void onStateChange(@NotNull BuildingConstructionState lastState, @NotNull BuildingConstructionState newState) {
                    if (newState == BuildingConstructionState.FINISHED || newState == BuildingConstructionState.FINISHED_AWAITING_CHUNK_UPDATES) {
                        toRemove.getBlocks().forEach(x -> land.unsafeGetKingdomBlocks().remove(x));
                    }
                }
            });
        }
        this.setBuilding(ctor);
        this.modifyData(land, true);
        ctor.start();
        ctor.onChunkLoad(this.origin.toSimpleChunkLocation().toBlockVector());
        this.getVisualsManager().updateVisuals();
        return upgradeEvent;
    }

    public void repair() {
        if (this.building instanceof BuildingConstruction) {
            throw new IllegalStateException("Cannot repair in current building state: " + this.building);
        }
        BuildingSchematic info = new BuildingSchematic(BuildingConstructionType.REPAIRING, this.building.getOrigin(), this.building.getFacing(), this.getBuildingSettings(this.level));
        BuildingConstruction ctor = this.prepareBuilding(info);
        this.setBuilding(ctor);
        ctor.start();
        ctor.onChunkLoad(this.origin.toSimpleChunkLocation().toBlockVector());
        this.getVisualsManager().updateVisuals();
    }

    public int getMaxLevel(@Nullable Kingdom kingdom) {
        return ((KingdomBuildingStyle)this.style).getMaxLevel(this.getPlaceholderContext(kingdom, this.level));
    }

    public PlaceholderProvider getPlaceholderContext(Kingdom kingdom, int lvl) {
        return new PlaceholderContextBuilder().withContext(kingdom).raw("lvl", lvl).raw("level", lvl);
    }

    public int getUpgradeCost(@Nullable Kingdom kingdom) {
        return (int)((KingdomBuildingStyle)this.style).getUpgradeCost(this.getPlaceholderContext(kingdom, this.level));
    }

    public double eval(@NonNull String str, @Nullable Kingdom kingdom, int lvl) {
        return this.eval(((KingdomBuildingStyle)this.style).getOption(str), kingdom, lvl);
    }

    public double eval(@NonNull KeyedConfigAccessor option, @Nullable Kingdom kingdom, int lvl) {
        try {
            MathExpression eqn = Objects.requireNonNull(option.getMathExpression());
            return MathUtils.eval(eqn, this.getPlaceholderContext(kingdom, lvl));
        }
        catch (Exception ex) {
            KLogger.error("Cannot evaluate '" + option.getOptionPath() + "' option for kingdom item style '" + ((KingdomBuildingStyle)this.style).getName() + "' (" + this.getClass().getSimpleName() + "):");
            KLogger.error(option.getNode().getStartMark());
            throw ex;
        }
    }

    public KeyedConfigAccessor ofSection(String sectionName) {
        return this.ofSection(sectionName, this.level);
    }

    public KeyedConfigAccessor ofSection(String sectionName, int withLevel) {
        return this.ofSection(sectionName, withLevel, true);
    }

    public KeyedConfigAccessor ofSection(String sectionName, int withLevel, boolean error) {
        KeyedConfigAccessor section = ((KingdomBuildingStyle)this.style).getOption(sectionName);
        ConfigAccessor masterSection = section.getSection();
        if (masterSection == null) {
            if (error && !section.isSet()) {
                throw new IllegalStateException("Cannot find option '" + sectionName + "' for kingdom item: " + ((KingdomBuildingStyle)this.style).getName());
            }
            return section;
        }
        int closestOption = KingdomsConfig.getClosestLevelSection(masterSection, withLevel);
        KeyedConfigAccessor levelSection = section.withProperty(String.valueOf(closestOption)).applyProperties();
        if (levelSection == null) {
            if (error) {
                throw new IllegalStateException("Cannot find option level section " + closestOption + " for option '" + sectionName + "' for kingdom item: " + ((KingdomBuildingStyle)this.style).getName());
            }
            return null;
        }
        return levelSection;
    }

    public Building getBuilding() {
        BuildingConstruction ctor;
        if (this.building instanceof BuildingConstruction && !(ctor = (BuildingConstruction)this.building).isLoaded()) {
            ctor.prepare(this.getBuildingSettings(this.level));
        }
        return this.building;
    }

    @ApiStatus.Internal
    public void setBuilding(Building building) {
        this.ensureObjectExpiration();
        this.building = building;
        if (building.isUnderConstruction()) {
            ((BuildingConstruction)building).addListener(this.getVisualsManager());
        }
    }

    public boolean canFunction() {
        if (this.disabled) {
            return false;
        }
        if (this.getDurability() <= 0.0) {
            return false;
        }
        return !this.building.isUnderConstruction();
    }

    public void requireRepair() {
        this.durability = -1.0;
        this.playSound("broken");
        this.displayParticle("broken");
    }

    public void decreaseDurability(double amount) {
        double currentDurability = this.getDurability();
        if (this.durability <= 0.0) {
            return;
        }
        this.durability = Math.max(-1.0, this.durability - amount);
        if (currentDurability > 0.0) {
            if (this.durability <= 0.0) {
                this.requireRepair();
            } else {
                this.playSound("damaged");
                this.displayParticle("damaged");
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(type=" + ((KingdomBuildingStyle)this.style).getName() + ", location=" + this.origin + ')';
    }
}

