/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import com.google.common.base.Strings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.block.Container;
import org.bukkit.block.DoubleChest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.inventory.DoubleChestInventory;
import org.bukkit.inventory.Inventory;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.KingdomBuildingHandler;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.xseries.XBlock;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.protectionsign.ProtectionSignManager;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.cache.caffeine.ExpirableSet;
import org.kingdoms.utils.cache.caffeine.ExpirationStrategy;
import org.kingdoms.utils.playerselector.PlayerSelector;
import org.kingdoms.utils.playerselector.PlayerSelectorInfo;
import org.kingdoms.utils.security.BCrypt;
import org.kingdoms.utils.versionsupport.VersionSupport;

public final class ProtectionSign
extends KingdomBlock {
    private final transient @NonNull SimpleLocation location;
    private final @NonNull SimpleLocation sign;
    private final long since;
    private @Nullable String password;
    private @NonNull UUID owner;
    private @NonNull List<AccessEntry> accessEntries;
    private transient @NonNull ExpirableSet<UUID> temporarilyTrusted = new ExpirableSet(ExpirationStrategy.all(KingdomsConfig.ProtectionSigns.PASSWORDS_COOKIES.getManager().getTime()));
    private ProtectionType protectionType;
    private @Nullable Duration automaticStateToggle;

    public ProtectionSign(@NonNull SimpleLocation location, @NonNull SimpleLocation sign, @NonNull UUID owner, @NonNull ProtectionType protectionType, @Nullable String password, long since, @NonNull List<AccessEntry> accessEntries, @Nullable Duration automaticStateToggle) {
        super(location);
        this.location = Objects.requireNonNull(location, "Protection Sign location cannot be null");
        this.sign = Objects.requireNonNull(sign, "Protection Sign's sign location cannot be null");
        this.owner = Objects.requireNonNull(owner, "Protection Sign owner cannot be null");
        this.protectionType = Objects.requireNonNull(protectionType, "Protection type cannot be null");
        this.password = password;
        this.since = since;
        this.accessEntries = Objects.requireNonNull(accessEntries, "Protection Sign access entries cannot be null");
        this.automaticStateToggle = automaticStateToggle;
    }

    public static boolean isProtected(@NonNull Block block) {
        return ProtectionSign.getProtection(block).isPresent();
    }

    public static boolean canBlockBeProtected(@NonNull Block block) {
        return XBlock.isOneOf((Block)block, KingdomsConfig.ProtectionSigns.BLOCKS.getManager().getStringList());
    }

    public static @NonNull ProtectionSign placeProtection(@Nullable Land land, @NonNull Block block, @NonNull Block sign, @NonNull Player owner, ProtectionType protectionType) {
        SimpleLocation location = SimpleLocation.of(block);
        ProtectionSign protection = new ProtectionSign(location, SimpleLocation.of(sign), owner.getUniqueId(), protectionType, null, System.currentTimeMillis(), new ArrayList<AccessEntry>(), null);
        KingdomPlayer.getKingdomPlayer((OfflinePlayer)owner).getProtectedBlocks().add(location);
        if (land == null) {
            land = new Land(location.toSimpleChunkLocation());
        }
        protection.modifyData(land, true);
        return protection;
    }

    public @Nullable Duration getAutomaticStateToggle() {
        return this.automaticStateToggle;
    }

    public void setAutomaticStateToggle(@Nullable Duration automaticStateToggle) {
        this.automaticStateToggle = automaticStateToggle;
    }

    public boolean shouldRemoveProtectionAfterBreak(Block block) {
        return !(block.getState() instanceof Chest) || SimpleLocation.of(block).equalsIgnoreWorld(this.location);
    }

    public static @NonNull Optional<ProtectionSign> getProtection(@NonNull Block block) {
        Objects.requireNonNull(block, "Cannot get protection of a null block");
        if (ProtectionSign.isSign(block)) {
            if ((block = VersionSupport.getAttachedBlock(block)) == null) {
                return Optional.empty();
            }
            SimpleLocation location = SimpleLocation.of(block);
            Land land = location.toSimpleChunkLocation().getLand();
            if (land == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(land.getProtectedBlocks().get(location.toBlockVector()));
        }
        SimpleLocation location = SimpleLocation.of(block);
        Land land = location.toSimpleChunkLocation().getLand();
        if (land == null) {
            return Optional.empty();
        }
        ProtectionSign protection = land.getProtectedBlocks().get(location.toBlockVector());
        if (protection == null) {
            Chest chest;
            Inventory inventory;
            BlockState state = block.getState();
            Block otherHalf = VersionSupport.getOtherHalfIfDoor(state);
            if (otherHalf != null) {
                protection = land.getProtectedBlocks().get(SimpleLocation.of(otherHalf).toBlockVector());
            } else if (state instanceof Chest && (inventory = (chest = (Chest)state).getInventory()) instanceof DoubleChestInventory) {
                DoubleChest doubleChest = (DoubleChest)inventory.getHolder();
                Chest leftChest = (Chest)doubleChest.getLeftSide();
                Chest rightChest = (Chest)doubleChest.getRightSide();
                SimpleChunkLocation mainChunk = SimpleChunkLocation.of(block);
                Block rightBlock = rightChest.getBlock();
                SimpleChunkLocation otherChunk = SimpleChunkLocation.of(block = LocationUtils.equalsIgnoreWorld(block, rightBlock) ? leftChest.getBlock() : rightBlock);
                if (!otherChunk.equalsIgnoreWorld(mainChunk) && (land = otherChunk.getLand()) == null) {
                    return Optional.empty();
                }
                location = SimpleLocation.of(block);
                protection = land.getProtectedBlocks().get(location.toBlockVector());
            }
        }
        return Optional.ofNullable(protection);
    }

    public static boolean isSign(@NonNull Block block) {
        return block.getType().name().endsWith("SIGN");
    }

    public boolean isContainer() {
        BlockState state = this.getBlock().getState();
        return state instanceof Container;
    }

    public long getSince() {
        return this.since;
    }

    public int hashCode() {
        int prime = 31;
        int result = 14;
        result = prime * result + this.location.hashCode();
        result = prime * result + this.owner.hashCode();
        return result;
    }

    public void updateSign() {
        List<String> lines = ProtectionSignManager.getProtectionTypeSignLines(this.protectionType);
        Block signBlock = this.sign.getBlock();
        Sign state = (Sign)signBlock.getState();
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(this.getOwnerPlayer());
        for (int i = 0; i < lines.size(); ++i) {
            MessageObject messageObjectBuilder = MessageCompiler.compile(lines.get(i));
            String line = messageObjectBuilder.buildPlain(settings);
            state.setLine(i, line);
        }
        state.update();
    }

    @Override
    public @NonNull SimpleLocation getKey() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtectionSign)) {
            return false;
        }
        ProtectionSign sign = (ProtectionSign)obj;
        return this.protectionType == sign.protectionType && this.owner.equals(sign.owner) && this.location.equals(sign.location);
    }

    public boolean isOwner(@NonNull OfflinePlayer player) {
        return this.owner.equals(player.getUniqueId());
    }

    public void removeProtection() {
        Land land = this.location.toSimpleChunkLocation().getLand();
        KingdomPlayer.getKingdomPlayer(this.owner).getProtectedBlocks().remove(this.location);
        this.modifyData(land, false);
    }

    public @NonNull UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@NonNull UUID owner) {
        this.owner = Objects.requireNonNull(owner, "Protection Sign owner cannot be null");
    }

    public @NonNull OfflinePlayer getOwnerPlayer() {
        return Bukkit.getOfflinePlayer((UUID)this.owner);
    }

    public @NonNull List<AccessEntry> getAccessEntries() {
        return this.accessEntries;
    }

    public @NonNull SimpleLocation getSign() {
        return this.sign;
    }

    public AccessPrivilege canAccess(@NonNull OfflinePlayer player) {
        return this.canAccess(player.getUniqueId());
    }

    public AccessPrivilege canAccess(@NonNull UUID player) {
        Objects.requireNonNull(player, "Cannot check protected block access for a null player");
        if (this.owner.equals(player)) {
            return AccessPrivilege.OWNER;
        }
        PlayerSelectorInfo selectorInfo = PlayerSelectorInfo.of(player, this.getLand());
        boolean specificPassword = false;
        for (AccessEntry accessEntry : this.accessEntries) {
            if (!accessEntry.selector.test(selectorInfo)) continue;
            if (accessEntry.privilege == AccessPrivilege.PASSWORD) {
                specificPassword = true;
                break;
            }
            return accessEntry.privilege;
        }
        if (this.temporarilyTrusted.contains(player)) {
            return AccessPrivilege.ALLOWED;
        }
        if (specificPassword) {
            return AccessPrivilege.PASSWORD;
        }
        switch (this.protectionType.ordinal()) {
            case 0: {
                return this.hasPassword() ? AccessPrivilege.PASSWORD : AccessPrivilege.DISALLOWED;
            }
            case 2: {
                return AccessPrivilege.ALLOWED;
            }
            case 1: {
                KingdomPlayer ownerKp = KingdomPlayer.getKingdomPlayer(this.owner);
                if (Objects.equals(ownerKp.getKingdomId(), selectorInfo.getKingdomPlayer().getKingdomId())) {
                    return AccessPrivilege.ALLOWED;
                }
                if (this.hasPassword()) {
                    return AccessPrivilege.PASSWORD;
                }
                return AccessPrivilege.DISALLOWED;
            }
        }
        throw new AssertionError((Object)("Unhandled protection type: " + this.protectionType.name()));
    }

    public @NonNull ProtectionType getProtectionType() {
        return this.protectionType;
    }

    public void setProtectionType(@NonNull ProtectionType protectionType) {
        this.protectionType = Objects.requireNonNull(protectionType, "Protection type cannot be null");
    }

    public @NonNull Block getBlock() {
        return this.location.toBukkitLocation().getBlock();
    }

    public @NonNull ExpirableSet<UUID> getTemporarilyTrusted() {
        return this.temporarilyTrusted;
    }

    public void setTemporarilyTrusted(@NonNull ExpirableSet<UUID> temporarilyTrusted) {
        this.temporarilyTrusted = Objects.requireNonNull(temporarilyTrusted, "Temporarily trusted protection sign cannot be null");
    }

    public @Nullable String getPassword() {
        return this.password;
    }

    public void setHashedPassword(@Nullable String password) {
        if (password.isEmpty()) {
            throw new IllegalArgumentException("Hashed password cannot be empty");
        }
        this.password = password;
    }

    public void changePassword(@Nullable String password) {
        this.temporarilyTrusted.clear();
        this.password = password == null ? null : this.hashPassword(password);
    }

    public boolean verifyPassword(@NonNull String password) {
        if (Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException("Cannot check null or empty password: " + password);
        }
        Objects.requireNonNull(this.password, "Cannot check password for a chest with no password");
        return BCrypt.checkpw(password, this.password);
    }

    public String hashPassword(String password) {
        return BCrypt.hashpw(password, BCrypt.gensalt());
    }

    public boolean hasPassword() {
        return this.password != null;
    }

    @Override
    public KingdomBuildingHandler<?> getKingdomBlockHandler() {
        return ProtectionSignManager.MANAGER;
    }

    @Override
    public void modifyData(Land land, boolean adding) {
        BlockVector3 origin = this.location.toBlockVector();
        Map<BlockVector3, ProtectionSign> map = land.unsafeGetProtectedBlocks();
        if (adding) {
            map.put(origin, this);
            map.put(this.sign.toBlockVector(), this);
        } else {
            map.remove(origin);
            map.remove(this.sign.toBlockVector());
        }
    }

    public static enum ProtectionType {
        PROTECTED,
        EVERYONE_IN_KINGDOM,
        EVERYONE;


        public String getDisplayname() {
            ConfigAccessor config = KingdomsConfig.PROTECTION_SIGNS.accessor();
            switch (this.ordinal()) {
                case 0: {
                    return config.getString("displayname");
                }
                case 1: {
                    return config.getString("everyone-in-kingdom", "displayname");
                }
                case 2: {
                    return config.getString("everyone", "displayname");
                }
            }
            throw new AssertionError((Object)("Unhandled protection type displayname: " + this.name()));
        }
    }

    public static enum AccessPrivilege {
        OWNER(KingdomsLang.PROTECTED_SIGNS_ACCESS_ENTRY_PRIVILEGES_OWNER),
        ALLOWED(KingdomsLang.PROTECTED_SIGNS_ACCESS_ENTRY_PRIVILEGES_ALLOWED),
        DISALLOWED(KingdomsLang.PROTECTED_SIGNS_ACCESS_ENTRY_PRIVILEGES_DISALLOWED),
        PASSWORD(KingdomsLang.PROTECTED_SIGNS_ACCESS_ENTRY_PRIVILEGES_PASSWORD);

        private final Messenger displayname;

        private AccessPrivilege(Messenger displayname) {
            this.displayname = displayname;
        }

        public Messenger displayName() {
            return this.displayname;
        }
    }

    public static final class AccessEntry {
        private PlayerSelector selector;
        private AccessPrivilege privilege;

        public AccessEntry(PlayerSelector selector, AccessPrivilege privilege) {
            this.selector = selector;
            this.privilege = privilege;
        }

        public PlayerSelector getSelector() {
            return this.selector;
        }

        public AccessPrivilege getPrivilege() {
            return this.privilege;
        }

        public void setPrivilege(AccessPrivilege privilege) {
            this.privilege = privilege;
        }

        public void setSelector(PlayerSelector selector) {
            this.selector = selector;
        }
    }
}

