/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.land;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.land.KingdomBlock;
import org.kingdoms.constants.land.ProtectionSign;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.turrets.Turret;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerLand;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.checkerframework.dataflow.qual.Pure;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.fsck.HealthCheckupHandler;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.utils.internal.functional.Fn;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.tracker.TrackedMap;
import org.kingdoms.utils.kingdoms.NationZone;

public class Land
extends KeyedKingdomsObject<SimpleChunkLocation> {
    private final transient @NonNull Map<UUID, Invasion> invasions = new ConcurrentHashMap<UUID, Invasion>();
    private final @NonNull Map<BlockVector3, KingdomBlock> kingdomBlocks = NonNullMap.of(new ConcurrentHashMap());
    private final @NonNull Map<BlockVector3, Turret> turrets = (Map)Fn.cast(TrackedMap.backedBy(NonNullMap.of(new ConcurrentHashMap()), this.kingdomBlocks).valueToKey(v -> v.getOrigin().toBlockVector()));
    private final @NonNull Map<BlockVector3, ProtectionSign> protectedBlocks = (Map)Fn.cast(TrackedMap.backedBy(NonNullMap.of(new ConcurrentHashMap()), this.kingdomBlocks).valueToKey(v -> v.getOrigin().toBlockVector()));
    private final @NonNull Map<BlockVector3, Structure> structures = (Map)Fn.cast(TrackedMap.backedBy(NonNullMap.of(new ConcurrentHashMap()), this.kingdomBlocks).valueToKey(v -> v.getOrigin().toBlockVector()));
    private final transient SimpleChunkLocation location;
    private @Nullable UUID kingdom;
    private @Nullable UUID claimedBy;
    private long since;

    public Land(@NonNull SimpleChunkLocation location, @Nullable UUID kingdom, @Nullable UUID claimedBy, long since) {
        this.location = location;
        this.kingdom = kingdom;
        this.claimedBy = claimedBy;
        this.since = since;
    }

    public Land(@NonNull Kingdom kingdom, @NonNull SimpleChunkLocation chunk) {
        this(kingdom.getId(), chunk);
    }

    public Land(@Nullable UUID kingdom, @NonNull SimpleChunkLocation chunk) {
        if (Land.getLand(chunk) != null) {
            throw new NullPointerException("Cannot construct a new land object for " + chunk + " for kingdom " + kingdom + " becuase it already exists.");
        }
        this.location = chunk;
        this.kingdom = kingdom;
        this.since = System.currentTimeMillis();
        KingdomsDataCenter.get().getLandManager().cache(this, true);
    }

    public Land(@NonNull SimpleChunkLocation chunk) {
        this((UUID)null, chunk);
    }

    public static @Nullable Land getLand(@NonNull Location location) {
        return Land.getLand(SimpleChunkLocation.of(location));
    }

    public static @Nullable Land getLand(@NonNull Chunk chunk) {
        return Land.getLand(SimpleChunkLocation.of(chunk));
    }

    public static @Nullable Land getLand(@NonNull Block block) {
        return SimpleChunkLocation.of(block).getLand();
    }

    @Pure
    public static boolean isClaimed(@Nullable Land land) {
        return land != null && land.isClaimed();
    }

    public static @Nullable Land getLand(@NonNull SimpleChunkLocation loc) {
        return (Land)KingdomsDataCenter.get().getLandManager().getOrLoadData(loc);
    }

    public static @Nullable Land getLand(@NonNull SimpleLocation loc) {
        return Land.getLand(loc.toSimpleChunkLocation());
    }

    public static @Nullable NationZone getNationZone(SimpleChunkLocation chunk) {
        if (!KingdomsConfig.Invasions.NATIONS_NATION_ZONE_ENABLED.getManager().getBoolean()) {
            return null;
        }
        int radius = KingdomsConfig.Invasions.NATIONS_NATION_ZONE_RADIUS.getManager().getInt();
        if (radius < 1) {
            return null;
        }
        Land mainLand = chunk.getLand();
        if (mainLand != null && mainLand.isClaimed()) {
            return null;
        }
        boolean capitalOnly = KingdomsConfig.Invasions.NATIONS_NATION_ZONE_ENABLED.getManager().getBoolean();
        return chunk.findFromSurroundingChunks(radius, c -> {
            Land land = c.getLand();
            if (land == null) {
                return null;
            }
            Kingdom kingdom = land.getKingdom();
            if (kingdom == null) {
                return null;
            }
            Nation nation = kingdom.getNation();
            if (nation != null && (!capitalOnly || nation.getCapitalId().equals(kingdom.getId()))) {
                return new NationZone(nation, kingdom, land);
            }
            return null;
        });
    }

    public boolean isHomeLand() {
        Kingdom kingdom = this.getKingdom();
        if (kingdom == null) {
            return false;
        }
        @Nullable org.kingdoms.server.location.Location home = kingdom.getHome();
        if (home == null) {
            return false;
        }
        return SimpleChunkLocation.of(home).equals(this.location);
    }

    public boolean isClaimed() {
        return this.kingdom != null;
    }

    public boolean isNexusLand() {
        return this.getStructure((Structure structure) -> ((StructureType)((StructureStyle)structure.getStyle()).getType()).isNexus()) != null;
    }

    public Structure getStructure(@NonNull Predicate<Structure> predicate) {
        for (Structure value : this.structures.values()) {
            if (!predicate.test(value)) continue;
            return value;
        }
        return null;
    }

    public <T extends KeyedKingdomsObject<?>> @Nullable T getKingdomBlock(@NonNull BlockVector3 location, Class<T> type) {
        KingdomBlock block = this.kingdomBlocks.get(location);
        if (block == null) {
            return null;
        }
        return (T)((KeyedKingdomsObject)Fn.safeCast(block, type));
    }

    public boolean isKingdomBlock(@NonNull BlockVector3 location) {
        return this.kingdomBlocks.containsKey(location);
    }

    public <T extends Structure> T getStructure(@NonNull Class<T> type) {
        return (T)this.getStructure(type::isInstance);
    }

    public int hashCode() {
        int prime = 31;
        int result = 19;
        result = prime * result + this.location.hashCode();
        if (this.kingdom != null) {
            result = prime * result + this.kingdom.hashCode();
        }
        if (this.claimedBy != null) {
            result = prime * result + this.claimedBy.hashCode();
        }
        result = prime * result + this.structures.hashCode();
        result = prime * result + this.turrets.hashCode();
        result = prime * result + this.protectedBlocks.hashCode();
        result = prime * result + Long.hashCode(this.since);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Land)) {
            return false;
        }
        Land land = (Land)obj;
        return this.location.equals(land.location) && Objects.equals(this.kingdom, land.kingdom) && this.since == land.since && Objects.equals(this.claimedBy, land.claimedBy) && this.structures.equals(land.structures) && this.turrets.equals(land.turrets) && this.protectedBlocks.equals(land.protectedBlocks);
    }

    public boolean simpleEquals(@Nullable Land land) {
        return land != null && (this == land || this.location.equals(land.location));
    }

    public UnclaimLandEvent unclaim(@Nullable KingdomPlayer by, UnclaimLandEvent.Reason reason) {
        return this.unclaim(by, reason, true);
    }

    public UnclaimLandEvent unclaim(@Nullable KingdomPlayer by, UnclaimLandEvent.Reason reason, boolean history) {
        Kingdom kingdom = Objects.requireNonNull(this.getKingdom(), () -> "Cannot unclaim " + this.location + " it wasn't claimed by a kingdom");
        return kingdom.unclaim(Collections.singleton(this.location), by, reason, history);
    }

    @ApiStatus.Internal
    public void silentUnclaim() {
        this.silentUnclaim(true);
    }

    @ApiStatus.Internal
    public void silentUnclaim(boolean removeExtras) {
        if (removeExtras) {
            Kingdoms.taskScheduler().run(TaskThreadType.SYNC, () -> this.structures.values().stream().filter(x -> ((StructureType)((StructureStyle)x.getStyle()).getType()).removeWhenUnclaimed()).forEach(structure -> {
                KingdomItemRemoveContext context = new KingdomItemRemoveContext();
                context.setRemoveData(false);
                structure.remove(context);
            }));
        }
        this.kingdom = null;
        this.since = System.currentTimeMillis();
        this.claimedBy = null;
    }

    @Override
    @ApiStatus.Internal
    public boolean isDataEmpty() {
        return this.kingdom == null && this.structures.isEmpty() && this.turrets.isEmpty() && this.protectedBlocks.isEmpty() && this.metadata.isEmpty() && this.statistics.isEmpty() && this.logs.isEmpty();
    }

    public @NonNull SimpleChunkLocation getLocation() {
        return this.location;
    }

    @Override
    public @NonNull SimpleChunkLocation getKey() {
        return this.location;
    }

    public String toString() {
        Kingdom kingdom = this.getKingdom();
        return "Land:{" + this.location + ", claimedBy=" + (kingdom == null ? "None" : kingdom.getName()) + '}';
    }

    protected DataHandler<Land> getDataHandler() {
        return DataHandlerLand.INSTANCE;
    }

    public @Nullable Kingdom getKingdom() {
        if (this.kingdom == null) {
            return null;
        }
        Kingdom kingdomInstance = Kingdom.getKingdom(this.kingdom);
        if (kingdomInstance == null) {
            HealthCheckupHandler.auto("&4Invalid kingdom data for land &e" + this.location + " &4removing its data...");
            this.kingdom = null;
            this.silentUnclaim();
        }
        return kingdomInstance;
    }

    public void setKingdom(@Nullable UUID kingdom) {
        this.kingdom = kingdom;
    }

    public boolean isBeingInvaded() {
        return !this.invasions.isEmpty();
    }

    public @Nullable UUID getKingdomId() {
        return this.kingdom;
    }

    public @NonNull @Unmodifiable Map<BlockVector3, Structure> getStructures() {
        return Collections.unmodifiableMap(this.structures);
    }

    @ApiStatus.Internal
    public @NonNull Map<BlockVector3, Structure> unsafeGetStructures() {
        return this.structures;
    }

    @ApiStatus.Internal
    public @NonNull Map<BlockVector3, Turret> unsafeGetTurrets() {
        return this.turrets;
    }

    @ApiStatus.Internal
    public @NonNull Map<BlockVector3, ProtectionSign> unsafeGetProtectedBlocks() {
        return this.protectedBlocks;
    }

    public @NonNull @Unmodifiable Map<BlockVector3, KingdomBlock> getKingdomBlocks() {
        return Collections.unmodifiableMap(this.kingdomBlocks);
    }

    @ApiStatus.Internal
    public @NonNull Map<BlockVector3, KingdomBlock> unsafeGetKingdomBlocks() {
        return this.kingdomBlocks;
    }

    public @Nullable UUID getClaimedBy() {
        return this.claimedBy;
    }

    public void setClaimedBy(@Nullable UUID claimedBy) {
        this.claimedBy = claimedBy;
    }

    public @Nullable KingdomPlayer getClaimer() {
        return this.claimedBy == null ? null : KingdomPlayer.getKingdomPlayer(this.claimedBy);
    }

    public @Nullable Map<UUID, Invasion> getInvasions() {
        return Collections.unmodifiableMap(this.invasions);
    }

    public boolean isUnderAttack() {
        return !this.invasions.isEmpty();
    }

    public void addInvasion(@NonNull Invasion invasion) {
        UUID id = invasion.getInvader().getKingdomId();
        if (this.invasions.containsKey(id)) {
            throw new IllegalArgumentException("The kingdom with ID " + id + " is already invading land at " + this.location + " conflicting between: " + invasion.getInvaderPlayer().getName() + " and " + this.invasions.get(id).getInvaderPlayer().getName());
        }
        if (!invasion.getAffectedLands().contains(this.location)) {
            throw new IllegalArgumentException("The provided invasion isn't affecting this land: " + invasion.getAffectedLands());
        }
        this.invasions.put(id, invasion);
    }

    public void endInvasions(Invasion.Result result) {
        this.invasions.values().forEach(i -> i.end(result));
    }

    public Invasion removeInvasion(@NonNull Kingdom kingdom) {
        return this.removeInvasion(kingdom.getId());
    }

    public Invasion removeInvasion(@NonNull UUID kingdom) {
        return this.invasions.remove(kingdom);
    }

    public @NonNull @Unmodifiable Map<BlockVector3, ProtectionSign> getProtectedBlocks() {
        return Collections.unmodifiableMap(this.protectedBlocks);
    }

    public @NonNull @Unmodifiable Map<BlockVector3, Turret> getTurrets() {
        return Collections.unmodifiableMap(this.turrets);
    }

    public long getSince() {
        return this.since;
    }

    public void setSince(long since) {
        this.since = since;
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        throw new UnsupportedOperationException();
    }
}

