/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.item;

import java.util.Map;
import java.util.NoSuchElementException;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.constants.item.AbstractKingdomItem;
import org.kingdoms.constants.item.KingdomItemData;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagType;
import org.kingdoms.platform.bukkit.item.ItemNBT;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\bf\u0018\u0000 #2\u00020\u0001:\u0001#J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0016H\u0016J\b\u0010!\u001a\u00020\u001aH&J\b\u0010\"\u001a\u00020\u001eH&R\u0018\u0010\u0002\u001a\u00020\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\u00020\tX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0018\u0010\u000e\u001a\u00020\u000fX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001aX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006$\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/constants/item/KingdomItem;", "", "version", "", "getVersion", "()I", "setVersion", "(I)V", "dateCreated", "", "getDateCreated", "()J", "setDateCreated", "(J)V", "item", "Lorg/bukkit/inventory/ItemStack;", "getItem", "()Lorg/bukkit/inventory/ItemStack;", "setItem", "(Lorg/bukkit/inventory/ItemStack;)V", "data", "Lorg/kingdoms/constants/namespace/NamespacedMap;", "Lorg/kingdoms/constants/item/KingdomItemData;", "getData", "()Lorg/kingdoms/constants/namespace/NamespacedMap;", "itemNBT", "Lorg/kingdoms/nbt/tag/NBTTagCompound;", "getItemNBT", "()Lorg/kingdoms/nbt/tag/NBTTagCompound;", "updateBaseVersion", "", "addData", "kingdomItemData", "getNBT", "applyChanges", "Companion", "core"})
public interface KingdomItem {
    @NotNull
    public static final Companion Companion = org.kingdoms.constants.item.KingdomItem$Companion.$$INSTANCE;

    public int getVersion();

    public void setVersion(int var1);

    public long getDateCreated();

    public void setDateCreated(long var1);

    @NotNull
    public ItemStack getItem();

    public void setItem(@NotNull ItemStack var1);

    @NotNull
    public NamespacedMap<KingdomItemData> getData();

    @NotNull
    public NBTTagCompound getItemNBT();

    default public void updateBaseVersion() {
        this.setVersion(2);
    }

    default public void addData(@NotNull KingdomItemData kingdomItemData) {
        Intrinsics.checkNotNullParameter((Object)kingdomItemData, (String)"kingdomItemData");
        ((Map)this.getData()).put(kingdomItemData.getNamespace(), kingdomItemData);
    }

    @NotNull
    public NBTTagCompound getNBT();

    public void applyChanges();

    @JvmStatic
    public static boolean isKingdomItem(@NotNull ItemStack item) {
        return Companion.isKingdomItem(item);
    }

    @JvmStatic
    @Nullable
    public static KingdomItem getKingdomItem(@NotNull ItemStack item) {
        return Companion.getKingdomItem(item);
    }

    @JvmStatic
    @NotNull
    public static KingdomItem createKingdomItem(@NotNull ItemStack item) {
        return Companion.createKingdomItem(item);
    }

    @JvmStatic
    @NotNull
    public static KingdomItem getOrCreateKingdomItem(@NotNull ItemStack item) {
        return Companion.getOrCreateKingdomItem(item);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/constants/item/KingdomItem$Companion;", "", "<init>", "()V", "isKingdomItem", "", "item", "Lorg/bukkit/inventory/ItemStack;", "getKingdomItem", "Lorg/kingdoms/constants/item/KingdomItem;", "createKingdomItem", "getOrCreateKingdomItem", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        public final boolean isKingdomItem(@NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return this.getKingdomItem(item) != null;
        }

        @JvmStatic
        @Nullable
        public final KingdomItem getKingdomItem(@NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            NBTTagCompound nbt = ItemNBT.getTag(item);
            if (nbt.has("Kingdoms")) {
                try {
                    Intrinsics.checkNotNull((Object)nbt);
                    return new AbstractKingdomItem(item, nbt);
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            return null;
        }

        @JvmStatic
        @NotNull
        public final KingdomItem createKingdomItem(@NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            NBTTagCompound nbt = ItemNBT.getTag(item);
            nbt.set("Kingdoms", (NBTTag)NBTTagCompound.empty());
            Intrinsics.checkNotNull((Object)nbt);
            return new AbstractKingdomItem(item, nbt);
        }

        @JvmStatic
        @NotNull
        public final KingdomItem getOrCreateKingdomItem(@NotNull ItemStack item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            NBTTagCompound nbt = ItemNBT.getTag(item);
            NBTTagCompound kingdomsTag = nbt.tryGetTag("Kingdoms", NBTTagType.COMPOUND);
            if (kingdomsTag == null) {
                nbt.set("Kingdoms", (NBTTag)NBTTagCompound.empty());
            }
            Intrinsics.checkNotNull((Object)nbt);
            return new AbstractKingdomItem(item, nbt);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

