/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.upgradable;

import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.EnumConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.constants.group.upgradable.StandardKingdomUpgrade;
import org.kingdoms.constants.namespace.InvalidNamespaceException;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedRegistry;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.string.Strings;

public class Powerup
implements StandardKingdomUpgrade {
    private static final NamespacedRegistry<Powerup> REGISTRY = new NamespacedRegistry();
    public static final Powerup DAMAGE_BOOST = Powerup.register("DAMAGE_BOOST");
    public static final Powerup DAMAGE_REDUCTION = Powerup.register("DAMAGE_REDUCTION");
    public static final Powerup REGENERATION_BOOST = Powerup.register("REGENERATION_BOOST");
    public static final Powerup ARROW_BOOST = Powerup.register("ARROW_BOOST");
    private final Namespace namespace;
    private boolean ownLandOnly;

    private static Powerup register(String name) {
        Powerup upgrade;
        Namespace ns = Namespace.kingdoms(name);
        if (!REGISTRY.isRegisetered(ns)) {
            upgrade = new Powerup(ns);
            REGISTRY.register(upgrade);
        } else {
            upgrade = REGISTRY.getRegistered((Powerup)((Object)ns));
        }
        return upgrade;
    }

    public Powerup(Namespace namespace) {
        this.namespace = namespace;
    }

    public static NamespacedRegistry<Powerup> getRegistry() {
        return REGISTRY;
    }

    public static void init() {
        ConfigSection config = KingdomsConfig.MISC_UPGRADE.getConfig();
        for (String key : config.getKeys()) {
            Namespace ns;
            try {
                ns = Namespace.fromConfigString(key);
            }
            catch (InvalidNamespaceException e) {
                continue;
            }
            Powerup registered = REGISTRY.getRegistered((Powerup)((Object)ns));
            if (registered == null) {
                registered = Powerup.register(ns.getKey());
            }
            registered.ownLandOnly = KingdomsConfig.Powers.POWERUPS_OWN_LAND_ONLY.getManager().withOption("upgrade", key).getBoolean();
        }
    }

    public String toString() {
        return Strings.capitalize(this.namespace.asNormalizedString());
    }

    @Override
    public String getDataName() {
        return this.namespace.asNormalizedString();
    }

    public boolean isOwnLandOnly() {
        return this.ownLandOnly;
    }

    @Override
    public EnumConfig getEnabledOption() {
        return KingdomsConfig.Powers.POWERUPS_ENABLED;
    }

    @Override
    public EnumConfig getScalingOption() {
        return KingdomsConfig.Powers.POWERUPS_SCALING;
    }

    @Override
    public EnumConfig getUpgradeCostOption() {
        return KingdomsConfig.Powers.POWERUPS_COST;
    }

    @Override
    public EnumConfig getMaxLevelOption() {
        return KingdomsConfig.Powers.POWERUPS_MAX_LEVEL;
    }

    @Override
    public EnumConfig getDefaultLevelOption() {
        return KingdomsConfig.Powers.POWERUPS_DEFAULT_LEVEL;
    }

    @Override
    public ConfigAccessor getConfig() {
        YamlConfigAccessor accessor = new YamlConfigAccessor(KingdomsConfig.POWERS.getConfig(), KingdomsConfig.POWERS.getDefaults());
        return accessor.get("powerups", this.namespace.getConfigOptionName()).getSection();
    }

    @Override
    public Messenger getDisplayName() {
        return new LanguageEntryMessenger("upgrades", "powerup", Strings.configOption(this.getConfigName()), "name");
    }

    @Override
    public @NonNull Namespace getNamespace() {
        return this.namespace;
    }

    static {
        Powerup.init();
    }
}

