/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.relationships;

import java.util.Map;
import java.util.Set;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.main.Kingdoms;

public final class StandardRelationAttribute
extends RelationAttribute {
    public static final StandardRelationAttribute BUILD = StandardRelationAttribute.register("BUILD");
    public static final StandardRelationAttribute CEASEFIRE = StandardRelationAttribute.register("CEASEFIRE");
    public static final StandardRelationAttribute AUTO_REVOKE = StandardRelationAttribute.register("AUTO_REVOKE");
    public static final StandardRelationAttribute INTERACT = StandardRelationAttribute.register("INTERACT");
    public static final StandardRelationAttribute HOME = StandardRelationAttribute.register("HOME");
    public static final StandardRelationAttribute USE = StandardRelationAttribute.register("USE");
    public static final StandardRelationAttribute FLY = StandardRelationAttribute.register("FLY");
    public static final StandardRelationAttribute TELEPORT = StandardRelationAttribute.register("TELEPORT");
    public static final StandardRelationAttribute INVADE = StandardRelationAttribute.register("INVADE");
    public static final StandardRelationAttribute SHOW_HOLOGRAMS = StandardRelationAttribute.register("SHOW_HOLOGRAMS");
    public static final StandardRelationAttribute TURRET_CEASEFIRE = StandardRelationAttribute.register("TURRET_CEASEFIRE");
    public static final StandardRelationAttribute MANAGE_TURRETS = StandardRelationAttribute.register("MANAGE_TURRETS");
    public static final StandardRelationAttribute MANAGE_STRUCTURES = StandardRelationAttribute.register("MANAGE_STRUCTURES");

    public StandardRelationAttribute(@NotNull String name) {
        super(Namespace.kingdoms(name));
    }

    public static void init() {
    }

    static StandardRelationAttribute register(String name) {
        StandardRelationAttribute attr = new StandardRelationAttribute(name);
        Map<Namespace, RelationAttribute> registry = Kingdoms.get().getRelationAttributeRegistry().getRawRegistry();
        attr.setHashCode(registry.size());
        registry.put(attr.getNamespace(), attr);
        return attr;
    }

    @Override
    public boolean hasAttribute(@Nullable Group group, @Nullable Group other) {
        return StandardRelationAttribute.hasAttribute((RelationAttribute)this, group, other);
    }

    public static boolean hasAttribute(@NonNull RelationAttribute attr, @Nullable Group group, @Nullable Group other) {
        if (group instanceof Kingdom && other instanceof Kingdom) {
            return StandardRelationAttribute.hasAttribute(attr, (Kingdom)group, (Kingdom)other);
        }
        return false;
    }

    public boolean hasAttribute(@Nullable Kingdom group, @Nullable Kingdom other) {
        return StandardRelationAttribute.hasAttribute((RelationAttribute)this, group, other);
    }

    public static boolean hasAttribute(@NonNull RelationAttribute attr, @Nullable Kingdom kingdom, @Nullable Kingdom other) {
        KingdomRelation relation;
        if (other == null) {
            return true;
        }
        KingdomRelation kingdomRelation = relation = kingdom == null ? KingdomRelation.NEUTRAL : kingdom.getRelationWith(other);
        if (relation == KingdomRelation.SELF) {
            return attr != INVADE;
        }
        if (relation == KingdomRelation.NATION) {
            Set<RelationAttribute> attributes = other.getNation().getAttributes().get((Object)KingdomRelation.NATION);
            return attributes != null && attributes.contains(attr);
        }
        if (relation == KingdomRelation.NEUTRAL && other.hasNation() && !KingdomsConfig.Relations.PRIORITIZE_KINGDOM_RELATIONS.getManager().getBoolean()) {
            Nation nation = other.getNation();
            return nation.hasAttribute((Group)(kingdom == null ? null : kingdom.getNation()), attr);
        }
        Set<RelationAttribute> attributes = other.getAttributes().get((Object)relation);
        if (Container.AGREEMENTS) {
            if (kingdom == null) {
                return attributes != null && attributes.contains(attr);
            }
            Set<RelationAttribute> selfAgreement = kingdom.getAttributes().get((Object)relation);
            return selfAgreement != null && attributes != null && selfAgreement.contains(attr) && attributes.contains(attr);
        }
        return attributes != null && attributes.contains(attr);
    }

    private static final class Container {
        private static final boolean AGREEMENTS = KingdomsConfig.Relations.AGREEMENTS.getManager().getBoolean();

        private Container() {
        }
    }
}

