/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.relations;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

abstract class LogGroupRelationshipChangeEvent
extends AuditLog {
    private UUID otherGroup;
    private KingdomRelation oldRelation;
    private KingdomRelation newRelation;

    protected LogGroupRelationshipChangeEvent() {
    }

    protected LogGroupRelationshipChangeEvent(UUID otherGroup, KingdomRelation oldRelation, KingdomRelation newRelation) {
        this.otherGroup = otherGroup;
        this.oldRelation = oldRelation;
        this.newRelation = newRelation;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        this.otherGroup = json.get("other").asUUID();
        this.oldRelation = KingdomRelation.valueOf(json.get("oldRelation").asString());
        this.newRelation = KingdomRelation.valueOf(json.get("newRelation").asString());
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setUUID("other", this.otherGroup);
        json.setString("oldRelation", this.oldRelation.name());
        json.setString("newRelation", this.newRelation.name());
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        LanguageEntryWithContext messageObjectBuilder1 = this.oldRelation.getName();
        builder.parse("old-relation", this.oldRelation.getColor() + messageObjectBuilder1.buildPlain(builder));
        LanguageEntryWithContext messageObjectBuilder = this.newRelation.getName();
        builder.parse("new-relation", this.newRelation.getColor() + messageObjectBuilder.buildPlain(builder));
    }

    public KingdomRelation getOldRelation() {
        return this.oldRelation;
    }

    public KingdomRelation getNewRelation() {
        return this.newRelation;
    }

    public UUID getOtherGroupId() {
        return this.otherGroup;
    }
}

