/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc.ranks;

import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.misc.ranks.LogRankChange;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\t\b\u0014\u00a2\u0006\u0004\b\u0002\u0010\u0003B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0002\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0016\u0010\u0016\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lorg/kingdoms/constants/group/model/logs/misc/ranks/LogRankChangeMaterial;", "Lorg/kingdoms/constants/group/model/logs/misc/ranks/LogRankChange;", "<init>", "()V", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "rank", "Lorg/kingdoms/constants/player/Rank;", "newMaterial", "Lorg/kingdoms/libs/xseries/XMaterial;", "(Lorg/kingdoms/constants/player/KingdomPlayer;Lorg/kingdoms/constants/player/Rank;Lcom/cryptomorin/xseries/XMaterial;)V", "value", "oldMaterial", "getOldMaterial", "()Lcom/cryptomorin/xseries/XMaterial;", "getProvider", "Lorg/kingdoms/constants/group/model/logs/AuditLogProvider;", "deserialize", "", "context", "Lorg/kingdoms/constants/land/abstraction/data/DeserializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataGetter;", "serialize", "Lorg/kingdoms/constants/land/abstraction/data/SerializationContext;", "Lorg/kingdoms/data/database/dataprovider/SectionableDataSetter;", "addEdits", "builder", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "Companion", "core"})
public class LogRankChangeMaterial
extends LogRankChange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private XMaterial newMaterial;
    @Nullable
    private XMaterial oldMaterial;
    @NotNull
    private static final Namespace NS;
    @JvmField
    @NotNull
    public static final AuditLogProvider PROVIDER;

    @Nullable
    public final XMaterial getOldMaterial() {
        return this.oldMaterial;
    }

    @Override
    @NotNull
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogRankChangeMaterial() {
    }

    public LogRankChangeMaterial(@NotNull KingdomPlayer player, @NotNull Rank rank, @NotNull XMaterial newMaterial) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)rank, (String)"rank");
        Intrinsics.checkNotNullParameter((Object)newMaterial, (String)"newMaterial");
        super(player, rank);
        this.oldMaterial = rank.getMaterial();
        this.newMaterial = newMaterial;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        String string = json.get("oldMaterial").asString();
        Intrinsics.checkNotNull((Object)string);
        this.oldMaterial = (XMaterial)XMaterial.matchXMaterial((String)string).get();
        String string2 = json.get("newMaterial").asString();
        Intrinsics.checkNotNull((Object)string2);
        this.newMaterial = (XMaterial)XMaterial.matchXMaterial((String)string2).get();
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        XMaterial xMaterial = this.oldMaterial;
        Intrinsics.checkNotNull((Object)xMaterial);
        json.setString("oldMaterial", xMaterial.name());
        XMaterial xMaterial2 = this.newMaterial;
        Intrinsics.checkNotNull((Object)xMaterial2);
        json.setString("newMaterial", xMaterial2.name());
    }

    @Override
    public void addEdits(@NotNull MessagePlaceholderProvider builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.addEdits(builder);
        builder.raw("old-material", this.oldMaterial);
        builder.raw("new-material", this.newMaterial);
    }

    public static final /* synthetic */ Namespace access$getNS$cp() {
        return NS;
    }

    static {
        Namespace namespace = Namespace.kingdoms("RANK_CHANGE_MATERIAL");
        Intrinsics.checkNotNullExpressionValue((Object)namespace, (String)"kingdoms(...)");
        NS = namespace;
        PROVIDER = new AuditLogProvider(){

            public AuditLog construct() {
                return new LogRankChangeMaterial();
            }

            public Namespace getNamespace() {
                return LogRankChangeMaterial.access$getNS$cp();
            }
        };
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/kingdoms/constants/group/model/logs/misc/ranks/LogRankChangeMaterial$Companion;", "", "<init>", "()V", "NS", "Lorg/kingdoms/constants/namespace/Namespace;", "Lorg/kingdoms/libs/jetbrains/annotations/NotNull;", "PROVIDER", "Lorg/kingdoms/constants/group/model/logs/AuditLogProvider;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

