/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.model.logs.misc;

import java.util.UUID;
import org.kingdoms.constants.group.model.logs.AuditLog;
import org.kingdoms.constants.group.model.logs.AuditLogProvider;
import org.kingdoms.constants.group.model.logs.purchases.LogResourcePoints;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.time.TimeFormatter;

public class LogGroupShieldPurchaseEvent
extends LogResourcePoints {
    private long oldShieldTime;
    private long newShieldTime;
    private static final Namespace NS = Namespace.kingdoms("SHIELD_PURCHASE");
    public static final AuditLogProvider PROVIDER = new AuditLogProvider(){

        @Override
        public AuditLog construct() {
            return new LogGroupShieldPurchaseEvent();
        }

        @Override
        public Namespace getNamespace() {
            return NS;
        }
    };

    @Override
    public AuditLogProvider getProvider() {
        return PROVIDER;
    }

    protected LogGroupShieldPurchaseEvent() {
    }

    public LogGroupShieldPurchaseEvent(UUID player, long oldShieldTime, long newShieldTime, double resourcePointsCost) {
        super(resourcePointsCost, player);
        this.oldShieldTime = oldShieldTime;
        this.newShieldTime = newShieldTime;
    }

    @Override
    public void deserialize(DeserializationContext<SectionableDataGetter> context) {
        super.deserialize(context);
        SectionableDataGetter json = context.getDataProvider();
        if (json.get("oldShieldTime") == null) {
            return;
        }
        this.oldShieldTime = json.get("oldShieldTime").asLong();
        this.newShieldTime = json.get("newShieldTime").asLong();
    }

    @Override
    public void serialize(SerializationContext<SectionableDataSetter> context) {
        super.serialize(context);
        SectionableDataSetter json = context.getDataProvider();
        json.setLong("oldShieldTime", this.oldShieldTime);
        json.setLong("newShieldTime", this.newShieldTime);
    }

    @Override
    public void addEdits(MessagePlaceholderProvider builder) {
        super.addEdits(builder);
        builder.raw("old-shield-time", TimeFormatter.of(this.oldShieldTime));
        builder.raw("new-shield-time", TimeFormatter.of(this.newShieldTime));
        builder.raw("purchased-shield-time", TimeFormatter.of(this.newShieldTime - this.oldShieldTime));
    }
}

