/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group.flag;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.bukkit.DyeColor;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.flag.GroupBannerProvider;
import org.kingdoms.constants.land.abstraction.data.DeserializationContext;
import org.kingdoms.constants.land.abstraction.data.SerializationContext;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.data.database.dataprovider.SectionableDataGetter;
import org.kingdoms.data.database.dataprovider.SectionableDataSetter;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.XPatternType;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.ContextualMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.chat.ChatInputManager;
import org.kingdoms.utils.Banners;

public class MinecraftBannerGroupBanner
implements GroupBanner {
    private static final Namespace NAMESPACE = Namespace.kingdoms("MINECRAFT_BANNER");
    public static final Provider PROVIDER = new Provider();
    private XMaterial material;
    private List<Pattern> patterns;

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public void setMaterial(XMaterial material) {
        this.material = material;
    }

    public XMaterial getMaterial() {
        return this.material;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public Messenger description() {
        return new ContextualMessenger(KingdomsLang.GROUP_BANNER_MINECRAFT_BANNER_DESCRIPTION, new MessagePlaceholderProvider().raw("patterns", this.patterns.stream().map(x -> x.getPattern() + "::" + x.getColor()).collect(Collectors.joining(", "))));
    }

    @Override
    public BufferedImage asImage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL urlOrCreate(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                ImageIO.write((RenderedImage)this.asImage(), "png", path.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Nullable
    public Dimension getImageSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    public GroupBanner.PreferredMethod getPreferredMethod() {
        return GroupBanner.PreferredMethod.IMAGE;
    }

    @Override
    public ItemStack createItem(ItemStack item) {
        this.material.setType(item);
        BannerMeta banner = (BannerMeta)item.getItemMeta();
        banner.setPatterns(this.patterns);
        item.setItemMeta((ItemMeta)banner);
        return item;
    }

    public GroupBannerProvider<MinecraftBannerGroupBanner> getProvider() {
        return PROVIDER;
    }

    @Override
    public void deserialize(@NotNull DeserializationContext<SectionableDataGetter> context) {
        SectionableDataGetter data = context.getDataProvider();
        this.material = XMaterial.matchXMaterial((String)data.getString("material")).orElse(XMaterial.WHITE_BANNER);
        this.patterns = data.get("patterns").asCollection(new ArrayList(), (list, getter) -> {
            SectionableDataGetter section = getter.asSection();
            DyeColor color = DyeColor.valueOf((String)section.getString("color"));
            XPatternType pattern = XPatternType.of((String)section.getString("pattern")).orElse(XPatternType.BASE);
            list.add(new Pattern(color, (PatternType)pattern.get()));
        });
    }

    @Override
    public void serialize(@NotNull SerializationContext<SectionableDataSetter> context) {
        GroupBanner.super.serialize(context);
        SectionableDataSetter data = context.getDataProvider();
        data.setString("material", this.material.name());
        data.get("patterns").setCollection(this.patterns, (setter, pattern) -> {
            SectionableDataSetter section = setter.createSection();
            section.setString("color", pattern.getColor().name());
            section.setString("pattern", XPatternType.of((PatternType)pattern.getPattern()).name());
        });
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.raw("material", this.material.name());
        context.raw("patterns", this.patterns);
    }

    public static final class Provider
    implements GroupBannerProvider<MinecraftBannerGroupBanner> {
        private Provider() {
        }

        @Override
        public MinecraftBannerGroupBanner construct() {
            return new MinecraftBannerGroupBanner();
        }

        @Override
        public CompletableFuture<MinecraftBannerGroupBanner> prompt(Player player) {
            KingdomsLang.GROUP_BANNER_MINECRAFT_BANNER_PROMPT.sendMessage((CommandSender)player);
            return ChatInputManager.awaitInput(player, input -> {
                ItemStack item = player.getInventory().getItemInMainHand();
                if (!Banners.isBanner(item)) {
                    KingdomsLang.GROUP_BANNER_MINECRAFT_BANNER_NOT_A_BANNER.sendError((CommandSender)player, new Object[0]);
                    return null;
                }
                MinecraftBannerGroupBanner banner = this.construct();
                banner.setMaterial(XMaterial.matchXMaterial((ItemStack)item));
                banner.setPatterns(Banners.getBannerPatterns(item));
                return banner;
            });
        }

        @Override
        public @NonNull Namespace getNamespace() {
            return NAMESPACE;
        }
    }
}

