/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.time.Duration;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmName;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\u0011\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010 \u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u0005H\u0086\u0002R\u001e\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006!"}, d2={"Lorg/kingdoms/constants/group/Shield;", "", "startTime", "", "duration", "Ljava/time/Duration;", "<init>", "(JLjava/time/Duration;)V", "getStartTime", "()J", "setStartTime", "(J)V", "_duration", "getDuration", "()Ljava/time/Duration;", "setDuration", "(Ljava/time/Duration;)V", "hasExpired", "", "()Z", "hasShield", "addDuration", "subtractDuration", "normalize", "", "deactivate", "timeLeft", "getTimeLeft", "plus", "amt", "minus", "plusAssign", "minusAssign", "core"})
public final class Shield {
    @ApiStatus.Internal
    private long startTime;
    @NotNull
    private Duration _duration;

    public Shield(long startTime, @NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.startTime = startTime;
        this._duration = duration;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    @NotNull
    public final Duration getDuration() {
        return this._duration;
    }

    public final void setDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.startTime = System.currentTimeMillis();
        this._duration = duration;
    }

    @JvmName(name="hasExpired")
    public final boolean hasExpired() {
        long expiresAt;
        long current = System.currentTimeMillis();
        return current >= (expiresAt = this.startTime + this._duration.toMillis());
    }

    @JvmName(name="hasShield")
    public final boolean hasShield() {
        return !this.hasExpired();
    }

    @NotNull
    public final Duration addDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.normalize();
        this._duration = this._duration.plus(duration);
        return this._duration;
    }

    @NotNull
    public final Duration subtractDuration(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        this.normalize();
        this._duration = this._duration.minus(duration);
        return this._duration;
    }

    public final void normalize() {
        this._duration = this.getTimeLeft();
        this.startTime = System.currentTimeMillis();
    }

    public final void deactivate() {
        this._duration = Duration.ZERO;
    }

    @NotNull
    public final Duration getTimeLeft() {
        Duration duration;
        long expiresAt;
        long current = System.currentTimeMillis();
        if (current >= (expiresAt = this.startTime + this._duration.toMillis())) {
            Duration duration2 = Duration.ZERO;
            duration = duration2;
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
        } else {
            Duration duration3 = Duration.ofMillis(expiresAt - current);
            duration = duration3;
            Intrinsics.checkNotNullExpressionValue((Object)duration3, (String)"ofMillis(...)");
        }
        return duration;
    }

    public final /* synthetic */ Duration plus(Duration amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        Duration duration = this._duration.plus(amt);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"plus(...)");
        return duration;
    }

    public final /* synthetic */ Duration minus(Duration amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        Duration duration = this._duration.minus(amt);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"minus(...)");
        return duration;
    }

    public final /* synthetic */ void plusAssign(Duration amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.addDuration(amt);
    }

    public final /* synthetic */ void minusAssign(Duration amt) {
        Intrinsics.checkNotNullParameter((Object)amt, (String)"amt");
        this.subtractDuration(amt);
    }
}

