/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.abstraction.NationOperator;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.namespaces.DefaultTaxes;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.constants.stats.DefaultStats;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.Pair;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerNation;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.data.managers.NationManager;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.nation.NationCreateEvent;
import org.kingdoms.events.general.nation.NationDisbandEvent;
import org.kingdoms.events.general.nation.NationSetSpawnEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.server.location.Location;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.compilers.expressions.MathExpression;

@ApiStatus.NonExtendable
public class Nation
extends Group
implements NationOperator {
    public Nation(@NonNull Kingdom capital, @NonNull String name) {
        super(capital.id, name);
        capital.setNation(this.id);
        KingdomPlayer capitalKing = capital.getKing();
        if (capitalKing != null) {
            capitalKing.unsafeSetNationalRank(this.getRanks().getHighestRank().getNode());
        }
        this.members.add(capital.id);
        DefaultStats.Kingdom.setNationSince(capital);
        KingdomsDataCenter.get().getNationManager().cache(this, true);
        NationCreateEvent event = new NationCreateEvent(this);
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public Nation(UUID id, Map<UUID, KingdomRelationshipRequest> relationshipRequests, RankMap ranks, Map<UUID, KingdomRelation> relations, Set<UUID> kingdoms, UUID capital, String name, int level, NamespacedMap<MathExpression> taxes, SimpleLocation nexus, Location home, GroupBanner flag, GroupBanner banner, NamespacedMap<Color> colors, Balance resourcePoints, Balance bank, NamespacedFlags flags, Statistics stats, long since, Shield shield, @NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes) {
        super(id, capital, name, null, level, taxes, ranks, resourcePoints, since, bank, flags, stats, shield, nexus, home, flag, banner, colors, kingdoms, new HashMap<String, BookChapter>(), relations, relationshipRequests, attributes, new HashSet<UUID>());
    }

    public static @Nullable Nation getNation(@NonNull String name) {
        Validate.notEmpty(name, "Nation name cannot be null or empty");
        return (Nation)KingdomsDataCenter.get().getNationManager().getData(name);
    }

    public static @Nullable Nation getNation(@NonNull UUID id) {
        Objects.requireNonNull(id, "Nation ID cannot be null or empty");
        return (Nation)KingdomsDataCenter.get().getNationManager().getOrLoadData(id);
    }

    private static <T> List<T> groupPlayers(Collection<Kingdom> kingdoms, Function<Kingdom, List<T>> function) {
        int size = 0;
        int i = 0;
        List[] elements = new List[kingdoms.size()];
        for (Kingdom kingdom : kingdoms) {
            List<T> result = function.apply(kingdom);
            size += result.size();
            elements[i++] = result;
        }
        ArrayList players = new ArrayList(size);
        for (List playerGroup : elements) {
            players.addAll(playerGroup);
        }
        return players;
    }

    public Map<String, Set<SimpleChunkLocation>> getLands(boolean includeNationZones) {
        List<Kingdom> kingdoms = this.getKingdoms();
        int includeRadius = includeNationZones && KingdomsConfig.Invasions.NATIONS_NATION_ZONE_ENABLED.getManager().getBoolean() ? KingdomsConfig.Invasions.NATIONS_NATION_ZONE_RADIUS.getManager().getInt() : 0;
        boolean capitalZoneOnly = KingdomsConfig.Invasions.NATIONS_NATION_ZONE_ENABLED.getManager().getBoolean();
        HashMap<String, Set<SimpleChunkLocation>> worldChunks = new HashMap<String, Set<SimpleChunkLocation>>(3);
        for (Kingdom kingdom : kingdoms) {
            boolean isCapital = kingdom.getId().equals(this.getCapitalId());
            Set<SimpleChunkLocation> chunks = kingdom.getLandLocations();
            for (SimpleChunkLocation chunk : chunks) {
                HashSet<SimpleChunkLocation> container = (HashSet<SimpleChunkLocation>)worldChunks.get(chunk.getWorld());
                if (container == null) {
                    container = new HashSet<SimpleChunkLocation>(chunks.size() * kingdoms.size());
                    worldChunks.put(chunk.getWorld(), container);
                }
                if (capitalZoneOnly && !isCapital) continue;
                if (includeRadius > 0) {
                    container.addAll(Arrays.asList(chunk.getChunksAround(includeRadius, true)));
                    continue;
                }
                container.add(chunk);
            }
        }
        return worldChunks;
    }

    public @NonNull Kingdom getCapital() {
        Kingdom capital = Kingdom.getKingdom(this.owner);
        if (capital == null) {
            List<Kingdom> kingdoms = this.getKingdoms();
            if (kingdoms.isEmpty()) {
                throw new IllegalStateException("Capital nation data corrupted. The issue has been automatically fixed, the nation was disbanded: " + this.name + " (" + this.id + ')');
            }
            MessageHandler.sendConsolePluginMessage("&4Detected unknown kingdom with UUID &e" + this.owner + " &4in nation &e" + this.name + " &8(&e" + this.id + "&8) &4Removing the data...");
            capital = kingdoms.iterator().next();
            this.owner = capital.id;
        }
        return capital;
    }

    public void setCapital(@NonNull Kingdom newCapital) {
        Kingdom oldCapital;
        Objects.requireNonNull(newCapital, "Nation capital cannot be null");
        if (!this.members.contains(newCapital.id)) {
            throw new IllegalArgumentException("Capital kingdom must be a member of the nation: " + this.id + " -> " + newCapital.id);
        }
        Kingdom kingdom = oldCapital = this.owner == null ? null : Kingdom.getKingdom(this.owner);
        if (oldCapital != null && oldCapital.hasOwner()) {
            oldCapital.getKing().unsafeSetNationalRank(null);
        }
        this.owner = newCapital.id;
        if (newCapital.hasOwner()) {
            newCapital.getKing().unsafeSetNationalRank(this.getRanks().getHighestRank().getNode());
        }
    }

    public @NonNull UUID getCapitalId() {
        return Objects.requireNonNull(this.owner);
    }

    @Override
    public int getLevel() {
        int forcedLevel = KingdomsConfig.GROUP_LEVELS_NATIONS_FORCE.getInt();
        return forcedLevel < 0 ? super.getLevel() : forcedLevel;
    }

    public @NonNull List<Kingdom> getKingdoms() {
        ArrayList<Kingdom> kingdoms = new ArrayList<Kingdom>(this.members.size());
        Iterator iter = this.members.iterator();
        while (iter.hasNext()) {
            UUID next = (UUID)iter.next();
            Kingdom kingdom = Kingdom.getKingdom(next);
            if (kingdom == null) {
                MessageHandler.sendConsolePluginMessage("&4Detected unknown kingdom with UUID &e" + this.id + " &4in nation &e" + this.name + " &8(&e" + this.id + "&8) &4Removing the data...");
                iter.remove();
                continue;
            }
            kingdoms.add(kingdom);
        }
        if (kingdoms.isEmpty()) {
            MessageHandler.sendConsolePluginMessage("&4After clearing all corrupted kingdom members in nation, none were left, disbanding: " + this.name + " &8(&e" + this.id + "&8)");
            this.silentlyDisband();
        }
        return kingdoms;
    }

    @Override
    public NationSetSpawnEvent setHome(Location home, KingdomPlayer kp) {
        NationSetSpawnEvent event = new NationSetSpawnEvent(this, kp, home);
        if (Objects.equals(this.home, home)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.home = event.getNewLocation();
        return event;
    }

    @Override
    public double calculateTax() {
        return MathUtils.eval(KingdomsConfig.TAX_NATIONS_SCALING.getString(), this, new Object[0]);
    }

    @Override
    public int getMaxMembers() {
        return (int)MathUtils.eval(KingdomsConfig.MAX_MEMBERS_NATIONS.getString(), this, new Object[0]);
    }

    @Override
    public @NonNull GroupRenameEvent rename(@NonNull String name, @Nullable KingdomPlayer renamer) {
        Validate.notEmpty(name, "Cannot rename kingdom to null or empty name");
        KingdomsDataCenter.get().getNationManager().rename(this, name);
        GroupRenameEvent event = new GroupRenameEvent(this, name, renamer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.setName(name);
        return event;
    }

    @Override
    public @NonNull List<Player> getOnlineMembers() {
        return Nation.groupPlayers(this.getKingdoms(), Kingdom::getOnlineMembers);
    }

    @Override
    public @NonNull List<OfflinePlayer> getPlayerMembers() {
        return Nation.groupPlayers(this.getKingdoms(), Kingdom::getPlayerMembers);
    }

    @Override
    public @NonNull List<KingdomPlayer> getKingdomPlayers() {
        return Nation.groupPlayers(this.getKingdoms(), Kingdom::getKingdomPlayers);
    }

    @Override
    public @NonNull NationDisbandEvent disband(GroupDisband.Reason reason, Runnable predataRemoval) {
        NationDisbandEvent event = new NationDisbandEvent(this, reason);
        if (reason != null) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return event;
        }
        if (predataRemoval != null) {
            predataRemoval.run();
        }
        for (Kingdom kingdom : this.getKingdoms()) {
            kingdom.setNation(null);
            for (KingdomPlayer playerMember : kingdom.getKingdomPlayers()) {
                playerMember.unsafeSetNationalRank(null);
            }
        }
        if (this.nexus != null) {
            Land land = Land.getLand(this.nexus);
            if (land != null) {
                Structure structure = land.getStructure(struct -> ((StructureType)((StructureStyle)struct.getStyle()).getType()).isNationalNexus());
                if (structure != null && ((StructureType)((StructureStyle)structure.getStyle()).getType()).isNationalNexus()) {
                    structure.remove(KingdomItemRemoveContext.DEFAULT);
                }
            } else {
                MessageHandler.sendConsolePluginMessage("&4Unknown land data for nation nexus &e" + this.nexus + " &4in nation &e" + this.name + " (" + this.id + ") skipping...");
            }
        }
        for (Map.Entry entry : this.relations.entrySet()) {
            Nation rel = Nation.getNation((UUID)entry.getKey());
            if (rel == null) continue;
            rel.revokeRelationsWith(this);
        }
        this.silentlyDisband();
        return event;
    }

    public void silentlyDisband() {
        NationManager manager = KingdomsDataCenter.get().getNationManager();
        manager.delete(this);
    }

    public boolean isMember(@NonNull Kingdom kingdom) {
        return this.isMember(kingdom.getId());
    }

    public boolean isMember(OfflinePlayer player) {
        for (Kingdom kingdom : this.getKingdoms()) {
            if (!kingdom.isMember(player)) continue;
            return true;
        }
        return false;
    }

    public boolean isMember(KingdomPlayer player) {
        for (Kingdom kingdom : this.getKingdoms()) {
            if (!kingdom.isMember(player)) continue;
            return true;
        }
        return false;
    }

    public double getTax(Kingdom kingdom) {
        double amount;
        if (!ServiceHandler.bankServiceAvailable()) {
            return 0.0;
        }
        double money = kingdom.getBank().get();
        MathExpression mainTax = this.getTax(DefaultTaxes.MAIN);
        if (mainTax != null) {
            return MathUtils.eval(mainTax, (PlaceholderProvider)new PlaceholderContextBuilder().withContext(kingdom).raw("money", money));
        }
        String tax = KingdomsConfig.TAX_NATIONS_MEMBERS_DEFAULT_EQUATION.getString();
        try {
            amount = MathUtils.eval(tax, kingdom, "money", money, "money", money);
        }
        catch (Exception exFatal) {
            MessageHandler.sendConsolePluginMessage("&cCould not use the default tax equation to pay for &e" + kingdom.getName() + " (" + kingdom.getId() + ")  &cin nation &e" + this.name + " (" + this.id + "):");
            exFatal.printStackTrace();
            return 0.0;
        }
        return amount;
    }

    public @NonNull Pair<Boolean, Double> collectTaxesFrom(@NonNull Kingdom kingdom) {
        double tax = this.getTax(kingdom);
        if (tax == 0.0) {
            return Pair.of(true, 0.0);
        }
        boolean useRpNationMember = KingdomsConfig.TAX_NATIONS_MEMBERS_USE_RESOURCE_POINTS.getBoolean();
        Balance withdrawBal = useRpNationMember ? kingdom.getResourcePoints() : kingdom.getBank();
        Balance depositBal = useRpNationMember ? this.getResourcePoints() : this.getBank();
        double limit = KingdomsConfig.ECONOMY_BANK_LIMIT_NATIONS.getDouble();
        if (!withdrawBal.has(tax)) {
            tax = withdrawBal.get();
        }
        if (!useRpNationMember && depositBal.get() + tax > limit) {
            tax = limit - depositBal.get();
        }
        withdrawBal.subtract(tax);
        depositBal.add(tax);
        return Pair.of(true, tax);
    }

    public @NonNull KingdomRelation getRelationWith(@Nullable Nation nation) {
        if (nation == null) {
            return KingdomRelation.NEUTRAL;
        }
        if (this.id.equals(nation.id)) {
            return KingdomRelation.SELF;
        }
        KingdomRelation relation = (KingdomRelation)((Object)this.relations.get(nation.id));
        return relation == null ? KingdomRelation.NEUTRAL : relation;
    }

    @Override
    public NexusMoveEvent placeOrMoveNexus(Location toLocation, @Nullable KingdomPlayer kp) {
        return this.abstractPlaceOrMoveNexus("national-nexus", toLocation, kp, null);
    }

    public boolean hasAttribute(@Nullable Nation nation, StandardRelationAttribute attribute) {
        Objects.requireNonNull(nation, "Cannot check attributes of a null nation");
        KingdomRelation relation = this.getRelationWith(nation);
        Validate.isTrue(relation != KingdomRelation.NATION, "Relation between two nations cannot be: NATION");
        return ((Set)nation.attributes.get((Object)relation)).contains(attribute);
    }

    public KingdomRelationshipRequest acceptRelationshipRequest(Nation nation) {
        Objects.requireNonNull(nation, "Cannot accept relationship request from null nation");
        KingdomRelationshipRequest request = (KingdomRelationshipRequest)this.relationshipRequests.remove(nation.id);
        if (request == null) {
            return null;
        }
        KingdomRelation relation = request.getRelation();
        this.relations.put(nation.id, relation);
        nation.relations.put(this.id, relation);
        return request;
    }

    public KingdomRelationshipRequest sendRelationshipRequest(@Nullable KingdomPlayer sender, @NonNull Nation nation, @NonNull KingdomRelation relation, long acceptTime) {
        Objects.requireNonNull(nation, "Cannot send relationship request to null nation");
        Objects.requireNonNull(relation, "Cannot have null relations");
        if (this.getRelationWith(nation) == relation) {
            return null;
        }
        if (relation == KingdomRelation.NEUTRAL) {
            this.relations.remove(nation.id);
            if (this.hasAttribute(nation, StandardRelationAttribute.AUTO_REVOKE)) {
                nation.relations.remove(this.id);
            }
        } else {
            KingdomRelationshipRequest request = new KingdomRelationshipRequest(relation, sender == null ? null : sender.getId(), acceptTime);
            nation.relationshipRequests.put(this.id, request);
            return request;
        }
        return null;
    }

    public KingdomRelationshipRequest sendRelationshipRequest(@Nullable KingdomPlayer sender, @NonNull Nation nation, @NonNull KingdomRelation relation) {
        return this.sendRelationshipRequest(sender, nation, relation, KingdomsConfig.Relations.REQUEST_EXPIRATION.getManager().getTimeMillis());
    }

    @Override
    public void updateRankNode(@NonNull String node, @NonNull String newNode) {
        this.ranks.updateNode(node, newNode);
        for (KingdomPlayer kp : this.getKingdomPlayers()) {
            if (!node.equals(kp.getNationRankNode())) continue;
            kp.unsafeSetNationalRank(newNode);
        }
    }

    public KingdomRelation revokeRelationsWith(@NonNull Nation nation) {
        Objects.requireNonNull(nation, "Cannot revoke relations with a null nation");
        nation.relations.remove(this.id);
        return (KingdomRelation)((Object)this.relations.remove(nation.id));
    }

    @Override
    public Nation getNation() {
        return this;
    }

    protected DataHandler<Nation> getDataHandler() {
        return DataHandlerNation.INSTANCE;
    }
}

