/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.abstraction.KingdomOperator;
import org.kingdoms.abstraction.NationOperator;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.group.Group;
import org.kingdoms.constants.group.KingdomsInventory;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.InviteCode;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.upgradable.KingdomUpgrade;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.group.upgradable.Powerup;
import org.kingdoms.constants.group.upgradable.champion.ChampionUpgrade;
import org.kingdoms.constants.group.upgradable.champion.StandardChampionUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.namespaces.DefaultDataFlags;
import org.kingdoms.constants.namespaces.DefaultTaxes;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.constants.stats.DefaultStats;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.data.Pair;
import org.kingdoms.data.centers.KingdomsDataCenter;
import org.kingdoms.data.handlers.DataHandlerKingdom;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.data.managers.KingdomManager;
import org.kingdoms.events.KingdomsEventCallerContext;
import org.kingdoms.events.general.GroupRelationshipRequestEvent;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.KingdomCreateEvent;
import org.kingdoms.events.general.KingdomDisbandEvent;
import org.kingdoms.events.general.KingdomKingChangeEvent;
import org.kingdoms.events.general.KingdomLoreChangeEvent;
import org.kingdoms.events.general.KingdomPacifismStateChangeEvent;
import org.kingdoms.events.general.KingdomSetHomeEvent;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.events.lands.UnclaimLandEvent;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.events.members.NationJoinEvent;
import org.kingdoms.events.members.NationLeaveEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.jetbrains.annotations.Unmodifiable;
import org.kingdoms.libs.xseries.XAttribute;
import org.kingdoms.libs.xseries.XEntity;
import org.kingdoms.libs.xseries.XPotion;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.entity.KingdomEntityBuilder;
import org.kingdoms.managers.fsck.HealthCheckupHandler;
import org.kingdoms.managers.invasions.Invasion;
import org.kingdoms.managers.land.protection.KingdomVaultManager;
import org.kingdoms.managers.logger.KingdomsLogger;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.ServiceHandler;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;
import org.kingdoms.utils.internal.nonnull.NonNullMap;
import org.kingdoms.utils.internal.uuid.FastUUID;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeUtils;

@ApiStatus.NonExtendable
public class Kingdom
extends Group
implements KingdomOperator,
NationOperator {
    private final @NonNull Set<SimpleChunkLocation> lands;
    private @NonNull Map<UUID, KingdomInvite> nationInvites;
    private @NonNull NamespacedMap<Integer> miscUpgrades;
    private @NonNull NamespacedMap<Integer> powerups;
    private @NonNull NamespacedMap<Integer> championUpgrades;
    private @NonNull Map<String, InviteCode> inviteCodes;
    private @NonNull Map<UUID, Long> challenges;
    private @NonNull KingdomsInventory nexusChest;
    private @NonNull String championType;
    private @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String lore;
    private @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID nation;
    private long lastInvasion;
    private int maxLandsModifier;

    public Kingdom(@NonNull UUID id, @NonNull Map<UUID, KingdomRelationshipRequest> relationshipRequests, @NonNull Set<UUID> mails, @NonNull Map<UUID, Long> challenges, @NonNull Map<String, InviteCode> inviteCodes, @NonNull NamespacedMap<Integer> miscUpgrades, @NonNull NamespacedMap<Integer> powerups, @NonNull NamespacedMap<Integer> championUpgrades, @NonNull Set<SimpleChunkLocation> lands, @NonNull RankMap ranks, @NonNull Map<UUID, KingdomRelation> relations, @NonNull Set<UUID> members, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String lore, @NonNull String championType, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID king, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID nation, @NonNull String name, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String tag, int level, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable NamespacedMap<MathExpression> taxes, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable SimpleLocation nexus, org.kingdoms.server.location.Location home, @NonNull Map<String, BookChapter> book, Map<Integer, ItemStack> nexusChest, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable GroupBanner flag, GroupBanner banner, NamespacedMap<Color> colors, Balance resourcePoints, int maxLandsModifier, Balance bank, NamespacedFlags flags, Statistics stats, long lastInvasion, long since, Shield shield, @NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes) {
        super(id, king, name, tag, level, taxes, ranks, resourcePoints, since, bank, flags, stats, shield, nexus, home, flag, banner, colors, members, book, relations, relationshipRequests, attributes, mails);
        this.miscUpgrades = Objects.requireNonNull(miscUpgrades, "Misc upgrades cannot be null");
        this.powerups = Objects.requireNonNull(powerups, "Powerups cannot be null");
        this.championUpgrades = Objects.requireNonNull(championUpgrades, "Champions upgrade cannot be null");
        this.lands = Objects.requireNonNull(lands, "Lands cannot be null");
        this.lore = lore;
        this.nation = nation;
        this.nationInvites = new HashMap<UUID, KingdomInvite>();
        this.inviteCodes = inviteCodes;
        this.challenges = challenges;
        this.championType = championType;
        this.maxLandsModifier = maxLandsModifier;
        this.lastInvasion = lastInvasion;
        Inventory inv = Bukkit.createInventory(null, (int)(this.validateChestSize() * 9));
        for (Map.Entry<Integer, ItemStack> items : nexusChest.entrySet()) {
            inv.setItem(items.getKey().intValue(), items.getValue());
        }
        this.nexusChest = KingdomVaultManager.createKingdomVault(this, inv);
    }

    private int validateChestSize() {
        int chestLvl = Math.abs(this.getUpgradeLevel(MiscUpgrade.CHEST_SIZE));
        if (chestLvl > 5) {
            KLogger.error("Chest level of kingdom " + this + " is " + chestLvl + ". Chest levels cannot be greater than 5");
            this.miscUpgrades.put(MiscUpgrade.CHEST_SIZE.getNamespace(), (Integer)5);
            return 6;
        }
        return chestLvl + 1;
    }

    public InviteCode generateInviteCode(Duration expiration, UUID creator, int uses) {
        String code;
        int minLen = KingdomsConfig.INVITATIONS_CODES_GENERATOR_LENGTH_MIN.getManager().getInt();
        int maxLen = KingdomsConfig.INVITATIONS_CODES_GENERATOR_LENGTH_MAX.getManager().getInt();
        String chars = KingdomsConfig.INVITATIONS_CODES_GENERATOR_CHARACTERS.getManager().getString();
        while (this.inviteCodes.containsKey(code = Strings.random(minLen, maxLen, chars))) {
        }
        return new InviteCode(code, System.currentTimeMillis(), expiration.toMillis() == 0L ? 0L : TimeUtils.afterNow(expiration), creator, new HashSet<UUID>(), uses);
    }

    public Kingdom(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID king, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String name) {
        super(king, name);
        this.championType = KingdomsConfig.ChampionUpgrades.CHAMPIONS_DEFAULT.getManager().getString();
        this.nexusChest = KingdomVaultManager.createKingdomVault(this, Bukkit.createInventory(null, (int)9));
        this.inviteCodes = new HashMap<String, InviteCode>();
        this.lands = new HashSet<SimpleChunkLocation>();
        this.nationInvites = new HashMap<UUID, KingdomInvite>();
        this.challenges = new NonNullMap<UUID, Long>();
        this.powerups = KingdomUpgrade.getDefaults(Powerup.getRegistry().getRegistry().values());
        this.miscUpgrades = KingdomUpgrade.getDefaults(MiscUpgrade.getRegistry().getRegistry().values());
        this.championUpgrades = new NamespacedMap(KingdomUpgrade.getDefaults(StandardChampionUpgrade.getRegistry().getRegistry().values()));
        if (king != null) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(king);
            kp.joinKingdom(this);
            kp.unsafeSetRank(this.ranks.getHighestRank().getNode());
        }
        KingdomsDataCenter.get().getKingdomManager().cache(this, true);
        KingdomCreateEvent event = new KingdomCreateEvent(this, king == null ? null : KingdomPlayer.getKingdomPlayer(king));
        Bukkit.getPluginManager().callEvent((Event)event);
    }

    public static @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom getKingdom(@NonNull String name) {
        Validate.notEmpty(name, "Kingdom name cannot be null or empty");
        return (Kingdom)KingdomsDataCenter.get().getKingdomManager().getData(name);
    }

    public static @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom getKingdom(@NonNull UUID id) {
        Objects.requireNonNull(id, "Cannot get kingdom with null id");
        return (Kingdom)KingdomsDataCenter.get().getKingdomManager().getOrLoadData(id);
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    @Override
    public int getMaxMembers() {
        double upgrade = MiscUpgrade.MAX_MEMBERS.isEnabled() ? MiscUpgrade.MAX_MEMBERS.getScaling(this) : 0.0;
        return (int)(MathUtils.eval(KingdomsConfig.MAX_MEMBERS_KINGDOMS.getMathExpression(), (PlaceholderProvider)new PlaceholderContextBuilder().withContext(this)) + upgrade);
    }

    @Override
    public NexusMoveEvent placeOrMoveNexus(org.kingdoms.server.location.Location toLocation, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer kp) {
        return this.abstractPlaceOrMoveNexus("nexus", toLocation, kp, null);
    }

    public int getMaxClaims() {
        return this.getMaxClaims("default");
    }

    public int getMaxClaims(String world) {
        String maxClaimsEqn = Objects.requireNonNull(KingdomsConfig.Claims.MAX_CLAIMS.getManager().forWorld(world).getString(), "Max claims equation not found");
        int max = (int)MathUtils.eval(maxClaimsEqn, this, "max_claims", MiscUpgrade.MAX_CLAIMS.getScaling(this));
        if (max < 0) {
            throw new IllegalStateException("Max claims has evaluated to a negative number " + max + " for '" + this + "' kingdom.");
        }
        return max;
    }

    public void updateChest() {
        HumanEntity[] viewers;
        Inventory nexusChest = this.nexusChest.getOriginal();
        for (HumanEntity player : viewers = nexusChest.getViewers().toArray(new HumanEntity[0])) {
            player.closeInventory();
        }
        Inventory chest = Bukkit.createInventory(null, (int)(this.validateChestSize() * 9));
        for (int i = 0; i < nexusChest.getSize(); ++i) {
            ItemStack item = nexusChest.getItem(i);
            chest.setItem(i, item);
        }
        this.nexusChest = KingdomVaultManager.createKingdomVault(this, chest);
        for (HumanEntity player : viewers) {
            player.openInventory(chest);
        }
    }

    public boolean isMember(@NonNull KingdomPlayer kp) {
        return this.isMember(kp.getId());
    }

    public boolean isMember(@NonNull OfflinePlayer player) {
        return this.isMember(player.getUniqueId());
    }

    public boolean isClaimed(@NonNull SimpleChunkLocation location) {
        return this.lands.contains(location);
    }

    public List<Kingdom> getKingdomsWithRelation(KingdomRelation ... relation) {
        Objects.requireNonNull(relation, "Cannot get kingdoms with null relation");
        if (relation.length == 0) {
            return new ArrayList<Kingdom>();
        }
        ArrayList<Kingdom> kingdoms = new ArrayList<Kingdom>(this.relations.size());
        for (Map.Entry rel : this.relations.entrySet()) {
            if (!Arrays.stream(relation).anyMatch(x -> x == rel.getValue())) continue;
            Kingdom kingdom = Kingdom.getKingdom((UUID)rel.getKey());
            if (kingdom == null) {
                MessageHandler.sendConsolePluginMessage("&4Unknown relation with a kingdom with a UUID &e" + rel.getKey() + " &4for kingdom &e" + this.name + " &8(&e" + this.id + "&8)");
            }
            kingdoms.add(kingdom);
        }
        return kingdoms;
    }

    public @NonNull Map<String, InviteCode> getInviteCodes() {
        this.inviteCodes.values().removeIf(InviteCode::hasExpired);
        return this.inviteCodes;
    }

    public void setInviteCodes(@NonNull Map<String, InviteCode> inviteCodes) {
        this.inviteCodes = inviteCodes;
    }

    @Override
    public int getLevel() {
        int forcedLevel = KingdomsConfig.GROUP_LEVELS_KINGDOMS_FORCE.getInt();
        return forcedLevel < 0 ? super.getLevel() : forcedLevel;
    }

    public int countStructures(Predicate<Structure> filter) {
        int count = 0;
        for (Land land : this.getLands()) {
            for (Structure struct : land.getStructures().values()) {
                if (filter != null && !filter.test(struct)) continue;
                ++count;
            }
        }
        return count;
    }

    public List<Structure> getAllStructures() {
        ArrayList<Structure> structures = new ArrayList<Structure>(this.lands.size());
        for (Land land : this.getLands()) {
            structures.addAll(land.getStructures().values());
        }
        return structures;
    }

    public @NonNull GroupRelationshipRequestEvent sendRelationshipRequest(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer sender, @NonNull Kingdom kingdom, @NonNull KingdomRelation relation, long acceptTime) {
        Objects.requireNonNull(kingdom, "Cannot send relationship request to null kingdom");
        Objects.requireNonNull(relation, "Cannot have null relations");
        GroupRelationshipRequestEvent event = new GroupRelationshipRequestEvent(this, kingdom, relation, sender);
        if (this.getRelationWith(kingdom) == relation) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        KingdomRelationshipRequest request = new KingdomRelationshipRequest(relation, sender == null ? null : sender.getId(), acceptTime);
        kingdom.relationshipRequests.put(this.id, request);
        return event;
    }

    public @NonNull GroupRelationshipRequestEvent sendRelationshipRequest(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer sender, @NonNull Kingdom kingdom, @NonNull KingdomRelation relation) {
        return this.sendRelationshipRequest(sender, kingdom, relation, KingdomsConfig.Relations.REQUEST_EXPIRATION.getManager().getTimeMillis());
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID getKingId() {
        return this.owner;
    }

    @Override
    public @NonNull List<Player> getOnlineMembers() {
        return this.getMembers(x -> Bukkit.getPlayer((UUID)x.getId()));
    }

    @Override
    public @NonNull List<OfflinePlayer> getPlayerMembers() {
        return this.getMembers(x -> Bukkit.getOfflinePlayer((UUID)x.getId()));
    }

    @Override
    public @NonNull List<KingdomPlayer> getKingdomPlayers() {
        return this.getMembers(x -> x);
    }

    private <T> @NonNull List<T> getMembers(@NonNull Function<KingdomPlayer, T> function) {
        Objects.requireNonNull(function);
        ArrayList<T> players = new ArrayList<T>(this.members.size());
        Iterator it = this.members.iterator();
        while (it.hasNext()) {
            UUID id = (UUID)it.next();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(id);
            if (!this.id.equals(kp.getKingdomId())) {
                HealthCheckupHandler.auto("Corrupted player ID found in kingdom '" + this.name + "' (" + this.id + "), actual kingdom ID: " + kp.getKingdomId() + ". This has been automatically fixed.");
                it.remove();
                continue;
            }
            T value = function.apply(kp);
            if (value == null) continue;
            players.add(value);
        }
        return players;
    }

    public @NonNull List<Land> getLands() {
        ArrayList<SimpleChunkLocation> corrupted = new ArrayList<SimpleChunkLocation>();
        ArrayList<Land> lands = new ArrayList<Land>(this.lands.size());
        for (SimpleChunkLocation loc : this.lands) {
            Land land = loc.getLand();
            if (land == null || !this.id.equals(land.getKingdomId())) {
                HealthCheckupHandler.auto("&cDetected unknown land at " + loc + " in kingdom " + this.name + " (" + this.id + ") Removing now...");
                corrupted.add(loc);
                continue;
            }
            lands.add(land);
        }
        if (!corrupted.isEmpty()) {
            this.lands.removeAll(corrupted);
        }
        return lands;
    }

    public @NonNull ClaimLandEvent claim(@NonNull SimpleChunkLocation loc, @NonNull KingdomPlayer claimer, ClaimLandEvent.Reason reason) {
        return this.claim(Collections.singleton(loc), claimer, reason, true);
    }

    public @NonNull ClaimLandEvent claim(@NonNull Set<SimpleChunkLocation> locations, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer claimer, @NonNull ClaimLandEvent.Reason reason, boolean history) {
        Objects.requireNonNull(locations, "Cannot claim null location");
        Objects.requireNonNull(reason, "Claiming reason cannot be null");
        if (locations.isEmpty()) {
            throw new IllegalArgumentException("Claim lands list is empty");
        }
        ClaimLandEvent event = new ClaimLandEvent(claimer, this, locations, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        locations = event.getLandLocations();
        for (SimpleChunkLocation loc : locations) {
            Land land = Land.getLand(loc);
            if (land != null) {
                Validate.isTrue(!land.isClaimed(), "Land already claimed at: " + loc + " while attempting to claim for " + this.name + " (" + this.id + ')');
            } else {
                land = new Land(this, loc);
            }
            land.setKingdom(this.id);
            if (claimer != null) {
                land.setClaimedBy(claimer.getId());
            }
            land.setSince(System.currentTimeMillis());
            this.lands.add(loc);
        }
        if (claimer != null) {
            claimer.processClaims(locations, true, history);
        }
        return event;
    }

    public @NonNull UnclaimLandEvent unclaim(@NonNull Set<SimpleChunkLocation> lands, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer by, @NonNull UnclaimLandEvent.Reason reason, boolean history) {
        if (lands.isEmpty()) {
            throw new IllegalArgumentException("Unclaim lands list is empty");
        }
        UnclaimLandEvent event = new UnclaimLandEvent(by, this, lands, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        lands = event.getLandLocations();
        if (by != null) {
            by.processClaims(lands, false, history);
        }
        for (SimpleChunkLocation location : lands) {
            Land land;
            if (!this.lands.remove(location)) {
                throw new IllegalArgumentException("This kingdom didn't claim: " + location);
            }
            if (KingdomsConfig.HOME_CLAIMED.getBoolean()) {
                Nation nation;
                if (this.home != null && SimpleChunkLocation.of(this.home).equals(location)) {
                    this.setHome(null, by);
                }
                if ((nation = this.getNation()) != null) {
                    this.home = nation.getHome();
                    if (this.home != null && SimpleChunkLocation.of(this.home).equals(location)) {
                        nation.setHome(null, by);
                    }
                }
            }
            if ((land = Objects.requireNonNull(location.getLand(), () -> "for land " + location + " kingdom " + this.name)).getClaimedBy() != null) {
                KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(land.getClaimedBy());
                kp.getClaims().remove(location);
            }
            land.silentUnclaim();
        }
        return event;
    }

    @Override
    public @NonNull Map<UUID, KingdomRelation> getRelations() {
        @NonNull Map<UUID, KingdomRelation> relations = super.getRelations();
        relations.keySet().removeIf(x -> Kingdom.getKingdom(x) == null);
        return relations;
    }

    @Nonnull
    public UnclaimLandEvent unclaimIf(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer by, UnclaimLandEvent.Reason reason, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Predicate<Land> filter) {
        Objects.requireNonNull(reason, "Unclaim reason cannot be null");
        HashSet<SimpleChunkLocation> unclaimed = new HashSet<SimpleChunkLocation>();
        for (Land land : this.getLands()) {
            if (filter != null && !filter.test(land)) continue;
            unclaimed.add(land.getLocation());
        }
        return this.unclaim(unclaimed, by, reason, true);
    }

    public @NonNull @Unmodifiable Set<SimpleChunkLocation> getLandLocations() {
        return Collections.unmodifiableSet(this.lands);
    }

    @ApiStatus.Internal
    public @NonNull Set<SimpleChunkLocation> unsafeGetLandLocations() {
        return this.lands;
    }

    @Override
    public GroupRenameEvent rename(@NonNull String name, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer renamer) {
        Validate.notEmpty(name, "Cannot rename kingdom to null or empty name");
        GroupRenameEvent event = new GroupRenameEvent(this, name, renamer);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        KingdomsDataCenter.get().getKingdomManager().rename(this, name);
        this.setName(name);
        return event;
    }

    public @NonNull KingdomRelation getRelationWith(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom kingdom) {
        if (kingdom == null) {
            return KingdomRelation.NEUTRAL;
        }
        if (this.id.equals(kingdom.id)) {
            return KingdomRelation.SELF;
        }
        if (this.nation != null && this.nation.equals(kingdom.nation)) {
            KingdomRelation relation;
            if (KingdomsConfig.Relations.PRIORITIZE_KINGDOM_RELATIONS.getManager().getBoolean() && (relation = (KingdomRelation)((Object)this.relations.get(kingdom.id))) != null) {
                return relation;
            }
            return KingdomRelation.NATION;
        }
        KingdomRelation relation = (KingdomRelation)((Object)this.relations.get(kingdom.id));
        return relation == null ? KingdomRelation.NEUTRAL : relation;
    }

    @Override
    public KingdomDisbandEvent disband( @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable GroupDisband.Reason reason) {
        return this.disband(reason, null);
    }

    @Override
    public KingdomDisbandEvent disband( @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable GroupDisband.Reason reason, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Runnable predataRemoval) {
        Nation nation;
        KingdomDisbandEvent event = new KingdomDisbandEvent(this, reason);
        if (reason != null) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return event;
        }
        if (predataRemoval != null) {
            predataRemoval.run();
        }
        if ((nation = this.getNation()) != null) {
            if (nation.getCapitalId().equals(this.id)) {
                nation.disband(reason);
            } else {
                nation.unsafeGetMembers().remove(this.id);
            }
        }
        for (UUID uUID : this.members) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(uUID);
            kp.silentlyLeaveKingdom();
        }
        this.members.clear();
        for (SimpleChunkLocation simpleChunkLocation : this.lands) {
            Land land = simpleChunkLocation.getLand();
            if (land == null) continue;
            land.silentUnclaim();
        }
        this.lands.clear();
        for (Map.Entry entry : this.relations.entrySet()) {
            Kingdom rel = Kingdom.getKingdom((UUID)entry.getKey());
            if (rel == null) continue;
            rel.relations.remove(this.id);
        }
        KingdomManager manager = KingdomsDataCenter.get().getKingdomManager();
        manager.delete(this);
        return event;
    }

    public boolean hasAttribute(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom kingdom, RelationAttribute attribute) {
        return attribute.hasAttribute(this, kingdom);
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer getKing() {
        return this.owner == null ? null : KingdomPlayer.getKingdomPlayer(this.owner);
    }

    public KingdomKingChangeEvent setKing(@NonNull KingdomPlayer newKing, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomKingChangeEvent.Reason reason) {
        Objects.requireNonNull(newKing, "Cannot set a null player as a king");
        if (newKing.getId().equals(this.owner)) {
            throw new IllegalArgumentException(newKing + " is already the king of " + this);
        }
        KingdomKingChangeEvent event = new KingdomKingChangeEvent(this, newKing, reason);
        if (reason != null) {
            Bukkit.getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return event;
        }
        Nation nation = this.getNation();
        KingdomPlayer oldKing = this.getKing();
        newKing = event.getNewKing();
        PlayerRankChangeContext rankContext = new PlayerRankChangeContext(this, RankIdentifier.highestRank());
        rankContext.setByPlayer(oldKing);
        rankContext.setIgnoreChecks(true);
        rankContext.setEventModifier(x -> x.setCancelled(true));
        newKing.changeRank(rankContext);
        if (nation != null) {
            rankContext.setGroup(nation);
            newKing.changeRank(rankContext);
        }
        if (oldKing != null && oldKing.hasKingdom() && oldKing.getRank() != null) {
            rankContext.setGroup(this);
            rankContext.setNewRank(RankIdentifier.demote());
            oldKing.changeRank(rankContext);
            if (nation != null) {
                rankContext.setGroup(nation);
                oldKing.changeRank(rankContext);
            }
        }
        this.owner = newKing.getId();
        return event;
    }

    public @NonNull List<Land> getLandsUnderAttack() {
        List<Land> lands = this.getLands();
        Iterator<Land> iterator = lands.iterator();
        while (iterator.hasNext()) {
            Land land = iterator.next();
            if (land.isBeingInvaded()) continue;
            iterator.remove();
        }
        return lands;
    }

    public boolean isBeingInvaded() {
        for (SimpleChunkLocation location : this.lands) {
            Land land = location.getLand();
            if (!land.isBeingInvaded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateRankNode(@NonNull String node, @NonNull String newNode) {
        this.ranks.updateNode(node, newNode);
        for (KingdomPlayer kp : this.getKingdomPlayers()) {
            if (!node.equals(kp.getRankNode())) continue;
            kp.unsafeSetRank(newNode);
        }
    }

    public @NonNull Map<KingdomPlayer, Invasion> getInvasions() {
        HashMap<KingdomPlayer, Invasion> invadingLands = new HashMap<KingdomPlayer, Invasion>();
        for (KingdomPlayer member : this.getKingdomPlayers()) {
            Invasion invading = member.getInvasion();
            if (invading == null) continue;
            invadingLands.put(member, invading);
        }
        return invadingLands;
    }

    public boolean isInvading() {
        return this.getKingdomPlayers().stream().anyMatch(KingdomPlayer::isInvading);
    }

    public NationLeaveEvent leaveNation(LeaveReason reason) {
        Nation nation = this.getNation();
        Objects.requireNonNull(nation, "Kingdom is not in a nation to leave");
        NationLeaveEvent event = new NationLeaveEvent(this, nation, reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        nation.unsafeGetMembers().remove(this.id);
        this.nation = null;
        return event;
    }

    @Override
    public String toString() {
        return "Kingdom[ID: " + this.id + ", Name: " + this.name + ']';
    }

    public boolean isUnderAttack() {
        return this.getLands().stream().anyMatch(Land::isBeingInvaded);
    }

    @Override
    public @NonNull KingdomSetHomeEvent setHome(org.kingdoms.server.location.Location home, @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable KingdomPlayer player) {
        KingdomSetHomeEvent event = new KingdomSetHomeEvent(this, home, player);
        if (Objects.equals(this.home, home)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            String changedBy = player == null ? "Unknown" : player.getOfflinePlayer().getName();
            String log = "Home of kingdom '" + this.name + "' (" + this.id + ") has been changed by " + changedBy + " from '" + event.getOldLocation() + " -> " + event.getNewLocation();
            KingdomsLogger.getMain().log(log, true);
            this.home = event.getNewLocation();
        }
        return event;
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String getLore() {
        return this.lore;
    }

    public KingdomLoreChangeEvent setLore(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable String lore, KingdomPlayer by) {
        KingdomLoreChangeEvent event = new KingdomLoreChangeEvent(this, lore, by);
        if (Objects.equals(this.lore, lore)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.lore = event.getNewLore();
        return event;
    }

    public boolean isPacifist() {
        return this.flags.get(DefaultDataFlags.Groups.PACIFIST);
    }

    public boolean isPrivate() {
        return this.flags.get(DefaultDataFlags.Groups.PRIVATE);
    }

    public void setPrivate(boolean privatee) {
        this.flags.put(DefaultDataFlags.Groups.PRIVATE, Boolean.valueOf(privatee));
    }

    public KingdomPacifismStateChangeEvent setPacifist(boolean pacifist) {
        return this.setPacifist(pacifist, null, null);
    }

    public KingdomPacifismStateChangeEvent setPacifist(boolean pacifist, KingdomPlayer by, KingdomsEventCallerContext<KingdomPacifismStateChangeEvent> callerContext) {
        KingdomPacifismStateChangeEvent event = new KingdomPacifismStateChangeEvent(this, pacifist, by);
        if (callerContext != null) {
            callerContext.precall(event);
        }
        if (event.isSilenced()) {
            return event;
        }
        Kingdoms.getServerX().getEventHandler().callEvent(event);
        if (event.isCancelled()) {
            return event;
        }
        this.flags.put(DefaultDataFlags.Groups.PACIFIST, Boolean.valueOf(pacifist));
        return event;
    }

    public @NonNull NamespacedMap<Integer> getMiscUpgrades() {
        return this.miscUpgrades;
    }

    public void setMiscUpgrades(@NonNull NamespacedMap<Integer> miscUpgrades) {
        this.miscUpgrades = Objects.requireNonNull(miscUpgrades, "Misc upgrades cannot be null");
    }

    public @NonNull NamespacedMap<Integer> getPowerups() {
        return this.powerups;
    }

    public void setPowerups(NamespacedMap<Integer> powerups) {
        Objects.requireNonNull(powerups, "Powerups cannot be null");
        this.powerups = powerups;
    }

    public @NonNull NamespacedMap<Integer> getChampionUpgrades() {
        return this.championUpgrades;
    }

    public void setChampionUpgrades(@NonNull NamespacedMap<Integer> championUpgrades) {
        this.championUpgrades = Objects.requireNonNull(championUpgrades, "Champion upgrades cannot be null");
    }

    public int getUpgradeLevel(@NonNull KingdomUpgrade upgrade) {
        if (upgrade instanceof ChampionUpgrade) {
            return this.championUpgrades.getOrDefault(upgrade.getNamespace(), 0);
        }
        if (upgrade instanceof MiscUpgrade) {
            return this.miscUpgrades.getOrDefault(((MiscUpgrade)upgrade).getNamespace(), 0);
        }
        if (upgrade instanceof Powerup) {
            return this.powerups.getOrDefault(upgrade.getNamespace(), 0);
        }
        throw new IllegalArgumentException("Unknown upgrade type: " + upgrade);
    }

    public long getUpgradeCost(@NonNull KingdomUpgrade upgrade) {
        return (long)upgrade.getUpgradeCost(new PlaceholderContextBuilder().withContext(this).raw("lvl", this.getUpgradeLevel(upgrade)));
    }

    public void setUpgradeLevel(@NonNull KingdomUpgrade upgrade, int newLevel) {
        Objects.requireNonNull(upgrade, "Cannot upgrade null upgrade type");
        if (upgrade instanceof ChampionUpgrade) {
            this.championUpgrades.put(upgrade.getNamespace(), (Integer)newLevel);
            return;
        }
        if (upgrade instanceof MiscUpgrade) {
            this.miscUpgrades.put(((MiscUpgrade)upgrade).getNamespace(), (Integer)newLevel);
            return;
        }
        if (upgrade instanceof Powerup) {
            this.powerups.put(upgrade.getNamespace(), (Integer)newLevel);
            return;
        }
        throw new UnsupportedOperationException("Unknown kingdom upgrade: " + upgrade + " (" + upgrade.getClass().getName() + ')');
    }

    public boolean isStrongerThan(Kingdom other) {
        return ConditionProcessor.process(KingdomsConfig.Invasions.STRENGTH_COMPARISON.getManager().getCondition(), new PlaceholderContextBuilder().withContext(this).other(other));
    }

    @ApiStatus.Internal
    public ConfigAccessor findChampionSection() {
        ConfigAccessor config = Objects.requireNonNull(KingdomsConfig.CHAMPION_UPGRADES.accessor().noDefault().gotoSection("champions"), "'champions' section not found in champion-upgrades.yml");
        ConfigAccessor championConfig = config.gotoSection(this.championType);
        if (championConfig == null) {
            String defaultType = config.getString("default");
            if (Strings.isNullOrBlank(defaultType) || config.gotoSection(defaultType) == null) {
                throw new IllegalArgumentException("Unknown default champion type: " + defaultType);
            }
            KLogger.debug((DebugNS)KingdomsDebug.CHAMPION_UNKNOWN$TYPES, () -> "Couldn't find default champion type '" + this.championType + "' for kingdom " + this.getName() + " reverting back to '" + defaultType + '\'');
            this.setChampionType(defaultType);
            championConfig = Objects.requireNonNull(config.gotoSection(defaultType), () -> "The default champion type not found in champion-upgrades.yml: " + defaultType);
        }
        return championConfig;
    }

    public @NonNull Creature spawnChampion(@NonNull Location location) {
        Objects.requireNonNull(location, "Cannot spawn champion at null location");
        ConfigSection section = this.findChampionSection().getSection();
        ConfigSection basedSection = section.getSection("base");
        String mm = basedSection.getString("mythicmob");
        int lvl = this.getUpgradeLevel(StandardChampionUpgrade.EQUIPMENT);
        boolean isCustom = mm != null;
        Creature champion = (Creature)new KingdomEntityBuilder().location(location).settings(basedSection).context(new MessagePlaceholderProvider().withContext(this)).entityType("champion of " + this.name).forceLevel(lvl).delayedRegistry().spawn();
        if (!isCustom) {
            int speed;
            ConfigSection lvlSection;
            if (lvl > 0 && (lvlSection = section.getSection("levels", String.valueOf(lvl)).getSection(new String[0])) != null) {
                XEntity.edit((Entity)champion, (ConfigurationSection)lvlSection.toBukkitConfigurationSection());
            }
            double hp = StandardChampionUpgrade.HEALTH.getScaling(this);
            champion.getAttribute((Attribute)XAttribute.MAX_HEALTH.get()).setBaseValue(hp);
            try {
                champion.setHealth(hp);
            }
            catch (IllegalArgumentException ex) {
                if (ex.getMessage().contains("must be between")) {
                    KLogger.error("Mob healths must be between 0 and 2048, the value you used for the champion is " + hp + ". If you wish to use higher values, you must change 'settings -> attribute -> maxHealth -> max' in spigot.yml to a higher value.");
                }
                throw ex;
            }
            int strength = this.getUpgradeLevel(StandardChampionUpgrade.STRENGTH);
            if (strength > 0) {
                XPotion.STRENGTH.buildPotionEffect(2000, strength).apply((LivingEntity)champion);
            }
            if ((speed = this.getUpgradeLevel(StandardChampionUpgrade.SPEED)) > 0) {
                XPotion.SPEED.buildPotionEffect(Integer.MAX_VALUE, (int)(StandardChampionUpgrade.SPEED.getScaling(this) - 1.0)).apply((LivingEntity)champion);
            }
        }
        return champion;
    }

    public @NonNull KingdomsInventory getNexusChest() {
        return this.nexusChest;
    }

    public void setNexusChest(@NonNull KingdomsInventory nexusChest) {
        this.nexusChest = nexusChest;
    }

    public long getLastInvasion() {
        return this.lastInvasion;
    }

    public void setLastInvasion(long lastInvasion) {
        this.lastInvasion = lastInvasion;
    }

    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID getNationId() {
        return this.nation;
    }

    @Override
    public @org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Nation getNation() {
        if (this.nation == null) {
            return null;
        }
        Nation nation = Nation.getNation(this.nation);
        if (nation == null) {
            MessageHandler.sendConsolePluginMessage("&4Invalid nation data for &e" + this.name + " (" + this.id + ") &4kingdom. Removing data...");
            this.nation = null;
            return null;
        }
        return nation;
    }

    @ApiStatus.Internal
    public void setNation(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable UUID nation) {
        this.nation = nation;
    }

    @Override
    public double calculateTax() {
        String taxEquation = KingdomsConfig.TAX_KINGDOMS_SCALING.getString();
        double pacifismFactor = this.isPacifist() ? MathUtils.eval(KingdomsConfig.TAX_KINGDOMS_PACIFISM_FACTOR.getString(), this, new Object[0]) : 0.0;
        return MathUtils.eval(taxEquation, this, "pacifism_factor", pacifismFactor, "pacifism_factor", pacifismFactor);
    }

    public double getTax(@NonNull OfflinePlayer player) {
        if (!ServiceHandler.bankServiceAvailable()) {
            return 0.0;
        }
        double money = ServiceVault.getMoney(player);
        MathExpression mainTax = this.getTax(DefaultTaxes.MAIN);
        if (mainTax != null) {
            return MathUtils.eval(mainTax, (PlaceholderProvider)new PlaceholderContextBuilder().withContext(player).raw("money", money));
        }
        String tax = KingdomsConfig.TAX_KINGDOMS_MEMBERS_DEFAULT_EQUATION.getString();
        try {
            return MathUtils.eval(tax, player, "money", money, "money", money);
        }
        catch (Exception exFatal) {
            MessageHandler.sendConsolePluginMessage("&cCould not use the default tax equation to get tax for &e" + player.getName() + " (" + player.getUniqueId() + ") " + ' ' + "&cin kingdom &e" + this.name + " (" + this.id + "):");
            exFatal.printStackTrace();
            return 0.0;
        }
    }

    public @NonNull Pair<Boolean, Double> payTaxes(@NonNull OfflinePlayer player) {
        double amount = this.getTax(player);
        if (amount == 0.0) {
            return Pair.of(true, 0.0);
        }
        double money = ServiceVault.getMoney(player);
        if (money - amount < 0.0) {
            this.bank.add(money);
            ServiceVault.withdraw(player, money);
            return Pair.of(false, money);
        }
        double limit = KingdomsConfig.ECONOMY_BANK_LIMIT_KINGDOMS.getDouble();
        if (this.bank.get() + amount > limit) {
            amount = limit - this.bank.get();
        }
        this.bank.add(amount);
        ServiceVault.withdraw(player, amount);
        return Pair.of(true, amount);
    }

    public boolean isInSameNationAs(@org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable Kingdom kingdom) {
        return this.nation != null && kingdom != null && kingdom.nation != null && FastUUID.equals(this.nation, kingdom.nation);
    }

    public NationJoinEvent joinNation(@NonNull Nation nation, KingdomPlayer player) {
        NationJoinEvent event = new NationJoinEvent(nation, this, player);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        if (this.hasNation()) {
            Nation oldNation = this.getNation();
            oldNation.unsafeGetMembers().remove(this.id);
        }
        DefaultStats.Kingdom.setNationSince(this);
        this.nation = nation.getId();
        nation.unsafeGetMembers().add(this.id);
        return event;
    }

    public @NonNull Map<UUID, KingdomInvite> getNationInvites() {
        return this.nationInvites;
    }

    public void setNationInvites(@NonNull Map<UUID, KingdomInvite> nationInvites) {
        this.nationInvites = nationInvites;
    }

    public int getMaxLandsModifier() {
        return this.maxLandsModifier;
    }

    public void setMaxLandsModifier(int maxLandsModifier) {
        this.maxLandsModifier = maxLandsModifier;
    }

    public @NonNull String getChampionType() {
        this.findChampionSection();
        return this.championType;
    }

    @ApiStatus.Internal
    public @NonNull String unsafeGetChampionType() {
        return this.championType;
    }

    public void setChampionType(@NonNull String championType) {
        this.championType = Objects.requireNonNull(championType, "Champion type cannot be null");
    }

    public double getPower() {
        double power = 0.0;
        for (KingdomPlayer kp : this.getKingdomPlayers()) {
            power += kp.getPower();
        }
        return power;
    }

    public boolean canBeOverclaimed() {
        return this.getPower() < (double)this.getMaxClaims();
    }

    public Map<UUID, Long> getChallenges() {
        if (this.challenges.isEmpty()) {
            return this.challenges;
        }
        long duration = KingdomsConfig.Invasions.CHALLENGES_DURATION.getManager().getTimeMillis();
        Iterator<Long> iter = this.challenges.values().iterator();
        while (iter.hasNext()) {
            long passed;
            long starts = iter.next();
            long now = System.currentTimeMillis();
            if (now < starts || (passed = now - starts) <= duration) continue;
            iter.remove();
        }
        return this.challenges;
    }

    public void setChallenges(Map<UUID, Long> challenges) {
        this.challenges = Objects.requireNonNull(challenges);
    }

    @Override
    public @NonNull Kingdom getKingdom() {
        return this;
    }

    @Override
    @Nullable
    public Group getGroup() {
        return this;
    }

    protected DataHandler<Kingdom> getDataHandler() {
        return DataHandlerKingdom.INSTANCE;
    }
}

