/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.group;

import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.kingdoms.abstraction.GroupOperator;
import org.kingdoms.abstraction.Levellable;
import org.kingdoms.abstraction.NamespacedFlagsContainer;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.base.KeyedKingdomsObject;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.constants.economy.GroupBankEconomy;
import org.kingdoms.constants.economy.ResourcePointsEconomy;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Shield;
import org.kingdoms.constants.group.flag.GroupBanner;
import org.kingdoms.constants.group.model.BookChapter;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.abstraction.KingdomBuilding;
import org.kingdoms.constants.land.abstraction.data.KingdomItemBuilder;
import org.kingdoms.constants.land.building.Building;
import org.kingdoms.constants.land.building.BuildingConstruction;
import org.kingdoms.constants.land.building.BuildingConstructionType;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.land.structures.Structure;
import org.kingdoms.constants.land.structures.StructureRegistry;
import org.kingdoms.constants.land.structures.StructureStyle;
import org.kingdoms.constants.land.structures.StructureType;
import org.kingdoms.constants.land.structures.type.nexus.StructureTypeNexus;
import org.kingdoms.constants.mails.Mail;
import org.kingdoms.constants.mails.MailRecipientType;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedFlags;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.namespaces.DefaultDataFlags;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.RankMap;
import org.kingdoms.constants.stats.Statistics;
import org.kingdoms.constants.themes.ThemeContainer;
import org.kingdoms.events.KingdomsEventCallerContext;
import org.kingdoms.events.general.GroupBannerChangeEvent;
import org.kingdoms.events.general.GroupColorChangeEvent;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.general.GroupHiddenStateChangeEvent;
import org.kingdoms.events.general.GroupRenameEvent;
import org.kingdoms.events.general.GroupRenameTagEvent;
import org.kingdoms.events.general.LocationChangeEvent;
import org.kingdoms.events.general.MailSendEvent;
import org.kingdoms.events.items.KingdomItemRemoveContext;
import org.kingdoms.events.lands.NexusMoveEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.managers.fsck.HealthCheckupHandler;
import org.kingdoms.managers.land.block.KingdomsBlockPlaceContextBuilding;
import org.kingdoms.managers.land.block.KingdomsBlockUpgradeContext;
import org.kingdoms.managers.mails.DraftMail;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.Validate;
import org.kingdoms.utils.compilers.expressions.MathExpression;

public abstract class Group
extends KeyedKingdomsObject<UUID>
implements GroupOperator,
Levellable,
NamespacedFlagsContainer,
ThemeContainer {
    protected final @NonNull Set<UUID> members;
    protected @NonNull Map<UUID, KingdomRelationshipRequest> relationshipRequests;
    protected @NonNull Map<UUID, KingdomRelation> relations;
    protected @NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes;
    protected @Nullable UUID owner;
    protected final transient UUID id;
    protected @NonNull String name;
    protected @Nullable SimpleLocation nexus;
    protected @Nullable Location home;
    protected Shield shield;
    protected int level = 1;
    @NotNull
    protected Balance resourcePoints;
    @NotNull
    protected Balance bank;
    protected long since;
    protected @Nullable String tag;
    protected @NonNull RankMap ranks;
    protected NamespacedFlags flags;
    protected NamespacedMap<MathExpression> taxes;
    protected NamespacedMap<Color> colors;
    protected @NonNull Map<String, BookChapter> book;
    private final @NonNull Set<UUID> mails;
    private @Nullable GroupBanner flag;
    private @Nullable GroupBanner banner;

    public Group(@NonNull UUID id, @Nullable UUID owner, @NonNull String name, @Nullable String tag, int level, @Nullable NamespacedMap<MathExpression> taxes, @NonNull RankMap ranks, Balance resourcePoints, long since, Balance bank, NamespacedFlags flags, Statistics stats, Shield shield, @Nullable SimpleLocation nexus, @Nullable Location home, GroupBanner flag, GroupBanner banner, NamespacedMap<Color> colors, @NonNull Set<UUID> members, @NonNull Map<String, BookChapter> book, Map<UUID, KingdomRelation> relations, Map<UUID, KingdomRelationshipRequest> relationshipRequests, Map<KingdomRelation, Set<RelationAttribute>> attributes, @NonNull Set<UUID> mails) {
        this.id = id;
        this.owner = owner;
        this.name = name;
        this.level = level;
        this.flags = Objects.requireNonNull(flags, "flags");
        this.setStatistics(stats);
        this.tag = tag;
        this.taxes = Objects.requireNonNull(taxes);
        this.colors = colors;
        this.flag = flag;
        this.banner = banner;
        this.ranks = Objects.requireNonNull(ranks, "Group ranks cannot be null");
        this.resourcePoints = resourcePoints;
        this.since = since;
        this.bank = bank;
        this.book = book;
        this.shield = shield;
        this.nexus = nexus;
        this.home = home;
        this.members = members;
        this.relations = Objects.requireNonNull(relations, "Group relations cannot be null");
        this.relationshipRequests = Objects.requireNonNull(relationshipRequests, "Group relationship requests cannot be null");
        this.attributes = Objects.requireNonNull(attributes, "Group attributes cannot be null");
        this.mails = Objects.requireNonNull(mails, "Mails cannot be null");
    }

    public Group(@Nullable UUID owner, @Nullable String name) {
        this.id = UUID.randomUUID();
        this.owner = owner;
        this.name = Objects.requireNonNull(name, "Group name cannot be null");
        this.since = System.currentTimeMillis();
        this.flags = new NamespacedFlags(DefaultDataFlags.Groups.DEFAULTS);
        this.ranks = Rank.copyDefaults(this);
        this.attributes = KingdomRelation.copyDefaults();
        this.book = new HashMap<String, BookChapter>();
        this.taxes = new NamespacedMap();
        this.colors = new NamespacedMap();
        this.bank = GroupBankEconomy.INSTANCE.createBalance(0.0);
        this.resourcePoints = ResourcePointsEconomy.INSTANCE.createBalance(0.0);
        this.shield = new Shield(0L, Duration.ZERO);
        this.members = new HashSet<UUID>();
        this.relations = new HashMap<UUID, KingdomRelation>();
        this.relationshipRequests = new HashMap<UUID, KingdomRelationshipRequest>();
        this.mails = new LinkedHashSet<UUID>();
    }

    public Mail sendMail(Player sender, DraftMail draft) {
        return this.sendMail(draft.getSubject(), sender, draft.getRecipients(), draft.getMessage(), draft.getInReplyTo());
    }

    public Mail sendMail(String subject, Player sender, Map<Group, MailRecipientType> recipients, List<String> message, UUID replyTo) {
        MailSendEvent event = new MailSendEvent(this, sender, recipients, replyTo == null ? null : Mail.getMail(replyTo), message);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return null;
        }
        recipients = event.getRecipients();
        message = event.getMessage();
        HashMap<UUID, MailRecipientType> uuidRecipients = new HashMap<UUID, MailRecipientType>(recipients.size());
        recipients.forEach((recipient, mail) -> uuidRecipients.put(recipient.id, (MailRecipientType)((Object)mail)));
        Mail mail2 = new Mail(UUID.randomUUID(), this.id, sender.getUniqueId(), subject, uuidRecipients, message, replyTo, true);
        this.mails.add(mail2.getId());
        for (Group group : recipients.keySet()) {
            group.mails.add(mail2.getId());
        }
        return mail2;
    }

    @Override
    public Group getGroup() {
        return this;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @ApiStatus.Internal
    public final int getRawLevel() {
        return this.level;
    }

    public Shield getShield() {
        return this.shield;
    }

    @Override
    @ApiStatus.Internal
    public void setLevel(int level) {
        this.level = level;
    }

    public void changeLevel(int newLvl, Player player) {
        if (this.nexus != null) {
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Land land = this.nexus.toSimpleChunkLocation().getLand();
            Structure nexusStructure = land.getStructure(struct -> ((StructureStyle)struct.getStyle()).getType() instanceof StructureTypeNexus);
            KingdomsBlockUpgradeContext<Structure> upgradeContext = new KingdomsBlockUpgradeContext<Structure>(kp, nexusStructure, newLvl);
            Messenger error = nexusStructure.getKingdomBlockHandler().onUpgrade(upgradeContext);
            if (error == null) {
                upgradeContext.finalizeProcess();
                upgradeContext.sendMessages((CommandSender)player);
            } else {
                error.sendError((CommandSender)player, upgradeContext.getMessageContext());
            }
        }
        this.level = newLvl;
    }

    public List<Mail> getSentMails() {
        ArrayList<Mail> sent = new ArrayList<Mail>(this.mails.size() / 2);
        for (Mail mail : this.getMails().values()) {
            if (!mail.getFromGroup().equals(this.id)) continue;
            sent.add(mail);
        }
        return sent;
    }

    public List<Mail> getReceivedMails() {
        ArrayList<Mail> received = new ArrayList<Mail>(this.mails.size() / 2);
        for (Mail mail : this.getMails().values()) {
            if (mail.getFromGroup().equals(this.id)) continue;
            received.add(mail);
        }
        return received;
    }

    public @NonNull Map<String, BookChapter> getBook() {
        return this.book;
    }

    public void setBook(@NonNull Map<String, BookChapter> book) {
        this.book = book;
    }

    public abstract NexusMoveEvent placeOrMoveNexus(@NonNull Location var1, @Nullable KingdomPlayer var2);

    public @NonNull NexusMoveEvent abstractPlaceOrMoveNexus(String styleName, Location toLocation, @Nullable KingdomPlayer kp, KingdomsEventCallerContext<NexusMoveEvent> eventContext) {
        Structure previousNexusStructure;
        SimpleLocation toSimpLoc = SimpleLocation.of(toLocation);
        SimpleChunkLocation chunk = toSimpLoc.toSimpleChunkLocation();
        Land land = chunk.getLand();
        if (land == null || !land.isClaimed() || (this instanceof Kingdom ? !((Kingdom)this).isClaimed(chunk) : !this.isMember(land.getKingdomId()))) {
            throw new IllegalArgumentException("Cannot place nexus in a land that does not belong to the kingdom: " + chunk + " -> " + land + " | " + (land == null ? "not claimed" : Boolean.valueOf(land.isClaimed())) + " (" + (this instanceof Kingdom ? !((Kingdom)this).isClaimed(chunk) : !this.isMember(land.getKingdomId())) + ')');
        }
        StructureStyle style = Objects.requireNonNull(StructureRegistry.get().getStyle(styleName), () -> "Cannot find nexus structure properties in Structures folder config: " + styleName);
        KingdomBuilding newStructure = ((StructureType)style.getType()).build(new KingdomItemBuilder(style, toSimpLoc, kp));
        newStructure.setLevel(this.level);
        if (this.nexus != null) {
            SimpleChunkLocation nexusChunk = this.nexus.toSimpleChunkLocation();
            Land nexusLand = nexusChunk.getLand();
            if (nexusLand == null) {
                HealthCheckupHandler.auto("&4Invalid nexus land data at &e" + nexusChunk);
                previousNexusStructure = null;
            } else {
                previousNexusStructure = nexusLand.getStructure(struct -> {
                    if (((StructureType)((StructureStyle)struct.getStyle()).getType()).isNexus()) {
                        Building building = struct.getBuilding();
                        if (building.isUnderConstruction()) {
                            BuildingConstruction ctor = (BuildingConstruction)building;
                            return ctor.getType() != BuildingConstructionType.DEMOLISHING;
                        }
                        return true;
                    }
                    return false;
                });
                if (previousNexusStructure == null) {
                    HealthCheckupHandler.auto("&4Invalid nexus structure data at &e" + this.nexus + " &4for kingdom&8: &e" + this);
                }
            }
        } else {
            previousNexusStructure = null;
        }
        NexusMoveEvent event = new NexusMoveEvent(previousNexusStructure, (Structure)newStructure, kp, this.nexus == null ? null : this.nexus, toSimpLoc);
        if (eventContext != null) {
            eventContext.precall(event);
            if (event.isCancelled()) {
                return event;
            }
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        toSimpLoc = event.getTo();
        newStructure = event.getNewStructure();
        Player player = kp == null ? null : kp.getPlayer();
        KingdomsBlockPlaceContextBuilding<KingdomBuilding> placeContext = new KingdomsBlockPlaceContextBuilding<KingdomBuilding>(null, kp, newStructure);
        Messenger error = ((Structure)newStructure).getKingdomBlockHandler().onPlace(placeContext);
        if (error != null) {
            event.setCancelled(true);
            if (player != null) {
                error.sendError((CommandSender)player, placeContext.getMessageContext());
            }
            return event;
        }
        if (previousNexusStructure != null) {
            KingdomItemRemoveContext removeCtx = new KingdomItemRemoveContext();
            removeCtx.setPlayer(kp);
            removeCtx.setCause(event);
            removeCtx.setDropsItem(false);
            previousNexusStructure.remove(removeCtx);
        }
        placeContext.finalizeProcess();
        this.nexus = toSimpLoc;
        return event;
    }

    @Override
    public @NonNull UUID getKey() {
        return this.id;
    }

    public boolean isHidden() {
        return this.flags.get(DefaultDataFlags.Groups.HIDDEN);
    }

    public GroupHiddenStateChangeEvent setHidden(boolean hidden, @Nullable KingdomPlayer player) {
        GroupHiddenStateChangeEvent event = new GroupHiddenStateChangeEvent(this, hidden, player);
        if (this.isHidden() == hidden) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            this.flags.put(DefaultDataFlags.Groups.HIDDEN, Boolean.valueOf(hidden));
        }
        return event;
    }

    public @Nullable GroupBanner getFlag() {
        return this.flag;
    }

    public @Nullable GroupBanner getBanner() {
        return this.banner;
    }

    public GroupBannerChangeEvent setBanner(@Nullable GroupBanner banner, KingdomPlayer player) {
        GroupBannerChangeEvent event = new GroupBannerChangeEvent(this, banner, player, true);
        if (Objects.equals(this.banner, banner)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.banner = event.getNewBanner();
        return event;
    }

    @Override
    public NamespacedFlags getFlags() {
        return this.flags;
    }

    @Override
    public void setFlags(NamespacedFlags flags) {
        this.flags = Objects.requireNonNull(flags);
    }

    public GroupBannerChangeEvent setFlag(@Nullable GroupBanner flag, KingdomPlayer player) {
        GroupBannerChangeEvent event = new GroupBannerChangeEvent(this, flag, player, false);
        if (Objects.equals(this.flag, flag)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.flag = event.getNewBanner();
        return event;
    }

    public NamespacedMap<Color> getColors() {
        return this.colors;
    }

    @Override
    @NotNull
    @ApiStatus.Experimental
    public NamespacedMap<Color> getThemes() {
        return this.colors;
    }

    public GroupColorChangeEvent setColor(Namespace colorType, Color color, KingdomPlayer player) {
        GroupColorChangeEvent event = new GroupColorChangeEvent(this, colorType, color, player);
        Color old = this.colors.get(colorType);
        if (Objects.equals(old, color)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.colors.put(colorType, color);
        return event;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.id + '|' + this.name + ']';
    }

    public Balance getBank() {
        return this.bank;
    }

    public Balance getResourcePoints() {
        return this.resourcePoints;
    }

    @NotNull
    public NamespacedMap<MathExpression> getTaxes() {
        return this.taxes;
    }

    @org.kingdoms.libs.jetbrains.annotations.Nullable
    public MathExpression getTax(@NotNull Namespace namespace) {
        return this.taxes.get(namespace);
    }

    public void setTax(@NotNull Namespace namespace, MathExpression value) {
        this.taxes.put(namespace, value);
    }

    public @NonNull UUID getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    protected void setName(@NonNull String name) {
        Validate.notEmpty(name, "Group name cannot be null or empty");
        this.name = name;
    }

    public @Nullable SimpleLocation getNexus() {
        return this.nexus;
    }

    public void setNexus(@Nullable SimpleLocation nexus) {
        this.nexus = nexus;
    }

    public @Nullable Location getHome() {
        return this.home;
    }

    public abstract LocationChangeEvent setHome(@Nullable Location var1, @Nullable KingdomPlayer var2);

    public boolean hasAttribute(@Nullable Group other, RelationAttribute attribute) {
        return attribute.hasAttribute(this, other);
    }

    public @NonNull Map<UUID, KingdomRelation> getRelations() {
        return this.relations;
    }

    @ApiStatus.Internal
    public @NonNull Map<UUID, KingdomRelation> unsafeGetRelations() {
        return this.relations;
    }

    public void setRelations(@NonNull Map<UUID, KingdomRelation> relations) {
        this.relations = Objects.requireNonNull(relations, "Relations cannot be null;");
    }

    public @NonNull RankMap getRanks() {
        return this.ranks;
    }

    public void setRanks(@NonNull RankMap ranks) {
        this.ranks = Objects.requireNonNull(ranks, "Ranks cannot be null");
    }

    public abstract @NonNull GroupRenameEvent rename(@NonNull String var1, @Nullable KingdomPlayer var2);

    public @NonNull Map<UUID, KingdomRelationshipRequest> getRelationshipRequests() {
        this.relationshipRequests.values().removeIf(x -> !x.canAccept());
        return this.relationshipRequests;
    }

    public void setRelationshipRequests(@NonNull Map<UUID, KingdomRelationshipRequest> relationshipRequests) {
        this.relationshipRequests = Objects.requireNonNull(relationshipRequests, "Group relationship requests cannot be null");
    }

    public double getBankruptcy() {
        Balance bal;
        boolean useRp = KingdomsConfig.TAX_KINGDOMS_USE_RESOURCE_POINTS.getBoolean();
        Balance balance = bal = useRp ? this.resourcePoints : this.bank;
        if (bal.get() >= 0.0) {
            return 0.0;
        }
        MathExpression eqn = KingdomsConfig.TAX_KINGDOMS_BANKRUPTCY_FACTOR.getMathExpression();
        return MathUtils.eval(eqn, (PlaceholderProvider)new PlaceholderContextBuilder().withContext(this).raw("balance", Math.abs(bal.get())));
    }

    public @Nullable UUID getOwnerId() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean isMember(@NonNull UUID id) {
        return this.members.contains(id);
    }

    public @NonNull Set<UUID> getMembers() {
        return Collections.unmodifiableSet(this.members);
    }

    @ApiStatus.Internal
    public @NonNull Set<UUID> unsafeGetMembers() {
        return this.members;
    }

    public final boolean isFull() {
        return this.members.size() >= this.getMaxMembers();
    }

    public int countRelationships(KingdomRelation relation) {
        int count = 0;
        for (KingdomRelation rel : this.relations.values()) {
            if (rel != relation) continue;
            ++count;
        }
        return count;
    }

    public void setRelationShipWith(Group other, @Nullable KingdomRelation relation) {
        Objects.requireNonNull(other);
        if (this == other) {
            throw new IllegalArgumentException("Cannot set relation with the kingdom itself");
        }
        if (relation == KingdomRelation.SELF) {
            throw new IllegalArgumentException("SELF relationship is not allowed");
        }
        if (relation == null || relation == KingdomRelation.NEUTRAL) {
            this.relations.remove(other.id);
            other.relations.remove(this.id);
        } else {
            this.relations.put(other.id, relation);
            other.relations.put(this.id, relation);
        }
    }

    public boolean isPermanent() {
        return this.flags.get(DefaultDataFlags.Groups.PERMANENT);
    }

    public void setPermanent(boolean permanent) {
        this.flags.put(DefaultDataFlags.Groups.PERMANENT, Boolean.valueOf(permanent));
    }

    public boolean requiresInvite() {
        return this.flags.get(DefaultDataFlags.Groups.REQUIRES_INVITE);
    }

    public void setRequiresInvite(boolean requiresInvite) {
        this.flags.put(DefaultDataFlags.Groups.REQUIRES_INVITE, Boolean.valueOf(requiresInvite));
    }

    public long getSince() {
        return this.since;
    }

    public void setSince(long since) {
        this.since = since;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Group)) {
            return false;
        }
        Group group = (Group)obj;
        return this.id.equals(group.id);
    }

    public @NonNull Map<KingdomRelation, Set<RelationAttribute>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@NonNull Map<KingdomRelation, Set<RelationAttribute>> attributes) {
        this.attributes = Objects.requireNonNull(attributes, "Group relation attributes cannot be null");
    }

    public @Nullable String getTag() {
        return this.tag;
    }

    public void setTag(@Nullable String tag) {
        this.tag = tag;
    }

    public GroupRenameTagEvent renameTag(@Nullable String tag, @Nullable KingdomPlayer by) {
        GroupRenameTagEvent event = new GroupRenameTagEvent(this, tag, by);
        if (Objects.equals(this.tag, tag)) {
            event.setCancelled(true);
            return event;
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return event;
        }
        this.tag = tag;
        return event;
    }

    public GroupDisband disband(GroupDisband.Reason reason) {
        return this.disband(reason, null);
    }

    public abstract GroupDisband disband(GroupDisband.Reason var1, Runnable var2);

    public abstract double calculateTax();

    public abstract int getMaxMembers();

    public boolean isHomePublic() {
        return this.flags.get(DefaultDataFlags.Groups.PUBLIC_HOME);
    }

    public void setPublicHome(boolean publicHome) {
        this.flags.put(DefaultDataFlags.Groups.PUBLIC_HOME, Boolean.valueOf(publicHome));
    }

    public abstract @NonNull List<OfflinePlayer> getPlayerMembers();

    public abstract @NonNull List<Player> getOnlineMembers();

    public abstract @NonNull List<KingdomPlayer> getKingdomPlayers();

    public abstract void updateRankNode(@NonNull String var1, @NonNull String var2);

    public @NonNull Set<UUID> getMailIds() {
        return this.mails;
    }

    public @NonNull Map<UUID, Mail> getMails() {
        HashMap<UUID, Mail> mappedMails = new HashMap<UUID, Mail>(this.mails.size());
        Iterator<UUID> iterator = this.mails.iterator();
        while (iterator.hasNext()) {
            UUID mailId = iterator.next();
            Mail mail = Mail.getMail(mailId);
            if (mail == null || !this.id.equals(mail.getFromGroup()) && !mail.getRecipients().containsKey(this.id)) {
                iterator.remove();
                continue;
            }
            mappedMails.put(mailId, mail);
        }
        return Collections.unmodifiableMap(mappedMails);
    }

    @Override
    public void addMessageContextEdits(@NotNull MessagePlaceholderProvider context) {
        context.withContext(this);
    }
}

