/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.constants.base;

import org.kingdoms.constants.base.SmartObject;
import org.kingdoms.data.compressor.DataCompressor;
import org.kingdoms.data.database.compressor.CompressorDataProvider;
import org.kingdoms.data.handlers.abstraction.DataHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.libs.jetbrains.annotations.ApiStatus;
import org.kingdoms.utils.internal.ByteArrayOutputStream;
import org.kingdoms.utils.internal.functional.Fn;

public abstract class CompressedSmartObject
implements SmartObject {
    private static final ByteArrayOutputStream ALREADY_SETTING_META = new ByteArrayOutputStream(0);
    private static final ByteArrayOutputStream FORCE_SAVE = new ByteArrayOutputStream(0);
    private static final ByteArrayOutputStream EXPIRED_STATE = new ByteArrayOutputStream(0);
    @ApiStatus.Internal
    protected transient @Nullable ByteArrayOutputStream objectState;

    @Override
    public final void invalidateObject() {
        this.objectState = EXPIRED_STATE;
    }

    @ApiStatus.Internal
    public final boolean isNewData() {
        return this.objectState == FORCE_SAVE;
    }

    @Override
    public final boolean hasObjectExpired() {
        return this.objectState == EXPIRED_STATE;
    }

    @Override
    public void ensureObjectExpiration() {
        if (this.hasObjectExpired()) {
            throw new IllegalStateException("This object instance has been unloaded from data but is being used: " + this);
        }
    }

    protected DataHandler<?> getDataHandler() {
        throw new UnsupportedOperationException();
    }

    public ByteArrayOutputStream getCompressedData() {
        this.ensureObjectExpiration();
        Class<?> clazz = this.getClass();
        int size = this.objectState == null || this.objectState == ALREADY_SETTING_META || this.objectState == FORCE_SAVE ? DataCompressor.REGISTRY.getAvgSize(clazz, 100) : this.objectState.size();
        DataCompressor compressor = new DataCompressor(size);
        this.getDataHandler().save(new CompressorDataProvider(null, compressor), Fn.cast(this));
        ByteArrayOutputStream result = compressor.result();
        compressor.registerSize(clazz);
        return result;
    }

    private boolean isAlreadySettingMeta() {
        this.ensureObjectExpiration();
        return this.objectState == ALREADY_SETTING_META;
    }

    @Override
    public final void saveObjectState(boolean forceSave) {
        this.ensureObjectExpiration();
        if (forceSave) {
            this.objectState = FORCE_SAVE;
            return;
        }
        if (this.objectState == FORCE_SAVE) {
            return;
        }
        if (this.isAlreadySettingMeta()) {
            return;
        }
        if (this.objectState != null) {
            throw new IllegalStateException("Save meta already set " + this);
        }
        this.objectState = ALREADY_SETTING_META;
        ByteArrayOutputStream meta = this.getCompressedData();
        if (this.objectState == FORCE_SAVE) {
            return;
        }
        this.objectState = meta;
    }

    @Override
    public final boolean isObjectStateSaved() {
        this.ensureObjectExpiration();
        return this.objectState != null;
    }

    @Override
    public boolean shouldSave() {
        this.ensureObjectExpiration();
        ByteArrayOutputStream compressedData = this.getCompressedData();
        if (this.objectState == null || this.objectState == FORCE_SAVE || !compressedData.equals(this.objectState)) {
            this.objectState = compressedData;
            return true;
        }
        return false;
    }
}

