/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.implementation;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.KeyedConfigAccessor;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.config.ConfigPath;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;

public class YamlConfigAccessor
implements ConfigAccessor {
    private final ConfigSection config;
    private final ConfigSection defaults;
    private boolean noDefault;

    public YamlConfigAccessor(ConfigSection config, ConfigSection defaults) {
        this.config = Objects.requireNonNull(config, "Configuration section cannot be null");
        this.defaults = Objects.requireNonNull(defaults, "Configuration section defaults cannot be null");
    }

    @Override
    public YamlConfigAccessor noDefault() {
        this.noDefault = true;
        return this;
    }

    @Override
    public boolean isSet(String ... option) {
        return this.config.isSet(option);
    }

    @Override
    public String getString(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getString(option);
        }
        return this.defaults.getString(option);
    }

    public <T> T get(NodeInterpreter<T> interpreter, String path) {
        T value = this.config.get(interpreter, path);
        if (value == null) {
            value = this.defaults.get(interpreter, path);
        }
        return value;
    }

    @Override
    public List<String> getStringList(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getStringList(option);
        }
        return this.defaults.getStringList(option);
    }

    @Override
    public Set<String> getKeys() {
        return this.config.getKeys();
    }

    @Override
    public boolean getBoolean(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getBoolean(option);
        }
        return this.defaults.getBoolean(option);
    }

    public ConditionalExpression getCondition(String option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getCondition(option);
        }
        return this.defaults.getCondition(option);
    }

    @Override
    public int getInt(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getInt(option);
        }
        return this.defaults.getInt(option);
    }

    @Override
    public KeyedConfigAccessor get(String ... option) {
        KeyedYamlConfigAccessor accessor = new KeyedYamlConfigAccessor(this.config, this.defaults, new ConfigPath(option));
        if (this.noDefault) {
            accessor.noDefault();
        }
        return accessor;
    }

    @Override
    public double getDouble(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getDouble(option);
        }
        return this.defaults.getDouble(option);
    }

    @Override
    public long getLong(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getLong(option);
        }
        return this.defaults.getLong(option);
    }

    @Override
    public ConfigSection getSection() {
        return this.config;
    }

    @Override
    public List<Integer> getIntegerList(String ... option) {
        if (this.noDefault || this.isSet(option)) {
            return this.config.getIntegerList(option);
        }
        return this.defaults.getIntegerList(option);
    }

    @Override
    public Map<String, Object> getEntries() {
        return this.config.getValues(false);
    }

    @Override
    @Nullable
    public YamlConfigAccessor gotoSection(String ... option) {
        ConfigSection val = this.config.getSection(option);
        ConfigSection defaultsSection = this.defaults.getSection(option);
        if (val != null) {
            YamlConfigAccessor newSection = new YamlConfigAccessor(val, this.noDefault ? val : defaultsSection);
            if (this.noDefault) {
                newSection.noDefault();
            }
            return newSection;
        }
        if (this.noDefault || defaultsSection == null) {
            return null;
        }
        YamlConfigAccessor newSection = new YamlConfigAccessor(defaultsSection, defaultsSection);
        if (this.noDefault) {
            newSection.noDefault();
        }
        return newSection;
    }

    @Override
    public String getCurrentPath() {
        return this.config.getName();
    }
}

