/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.config.accessor;

import com.google.common.base.Enums;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Entity;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.config.accessor.DefaultableConfigAccessor;
import org.kingdoms.config.implementation.KeyedYamlConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.NodeInterpretContext;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.time.TimeUtils;

public interface KeyedConfigAccessor
extends DefaultableConfigAccessor {
    @Override
    public KeyedConfigAccessor noDefault();

    public KeyedConfigAccessor withProperty(String var1);

    public KeyedConfigAccessor applyProperties();

    public KeyedYamlConfigAccessor withOption(String var1, String var2);

    default public KeyedConfigAccessor forWorld(String world) {
        return this.withProperty(world).isSet() ? this : this.clearExtras().withProperty("default");
    }

    public KeyedYamlConfigAccessor clearExtras();

    default public KeyedConfigAccessor forWorld(Entity entity2) {
        return this.forWorld(entity2.getWorld().getName());
    }

    public String getOptionPath();

    public boolean isSet();

    public String getString();

    public Node getNode();

    public MathExpression getMathExpression();

    public <T> T get(NodeInterpreter<T> var1);

    public <T> T get(NodeInterpreter<T> var1, NodeInterpretContext<T> var2);

    public List<String> getStringList();

    public Set<String> getSectionKeys();

    public ConfigAccessor getSection();

    public boolean getBoolean();

    public List<Integer> getIntegerList();

    public int getInt();

    public double getDouble();

    public long getLong();

    default public Long getTimeMillis() {
        Duration time = this.getTime(PlaceholderProvider.EMPTY);
        return time == null ? null : Long.valueOf(time.toMillis());
    }

    @Nullable
    default public Duration getTime() {
        return this.getTime(PlaceholderContextBuilder.DEFAULT);
    }

    @Nullable
    default public Duration getTime(PlaceholderProvider ctx) {
        return NodeInterpreter.getTime(this.getNode(), ctx);
    }

    @Deprecated
    default public Long getTimeMillis(TimeUnit timeUnit) {
        String time = this.getString();
        return time == null ? null : TimeUtils.parseTime(time);
    }

    default public <T extends Enum<T>> T getEnum(Class<T> enumClazz) {
        return (T)((Enum)Enums.getIfPresent(enumClazz, (String)this.getString()).orNull());
    }
}

