/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.spawn;

import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;

public class CommandNationUnsetspawn
extends KingdomsCommand {
    public CommandNationUnsetspawn(KingdomsParentCommand parent) {
        super("unsetspawn", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.SET_HOME)) {
            StandardKingdomPermission.SET_HOME.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Nation nation = kingdom.getNation();
        Location home = BukkitAdapter.adapt(nation.getHome());
        if (home == null) {
            KingdomsLang.COMMAND_NATION_UNSETSPAWN_NOT_SET.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (nation.setHome(null, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        for (Player member : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_UNSETSPAWN_SUCCESS.sendMessage((CommandSender)member, "x", home.getBlockX(), "y", home.getBlockY(), "z", home.getBlockZ());
        }
        return CommandResult.SUCCESS;
    }
}

