/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.relations;

import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationRevoke
extends KingdomsCommand {
    public CommandNationRevoke(KingdomsParentCommand parent) {
        super("revoke", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Nation nation = kingdom.getNation();
        if (nation == null) {
            context.sendError(KingdomsLang.NO_NATION, new Object[0]);
            return CommandResult.FAILED;
        }
        Nation revokedNation = context.getNation(0);
        if (revokedNation == null) {
            return CommandResult.FAILED;
        }
        if (nation.getId().equals(revokedNation.getId())) {
            KingdomsLang.COMMAND_NATION_REVOKE_SELF.sendMessage((CommandSender)player, "nation", revokedNation.getName());
            return CommandResult.FAILED;
        }
        KingdomRelation request = nation.revokeRelationsWith(revokedNation);
        if (request == null) {
            KingdomsLang.COMMAND_NATION_REVOKE_NO_RELATION.sendMessage((CommandSender)player, "nation", revokedNation.getName());
            return CommandResult.FAILED;
        }
        for (Kingdom kingdom2 : nation.getKingdoms()) {
            kingdom2.getRelations().keySet().removeIf(x -> revokedNation.getMembers().contains(x));
        }
        for (Kingdom kingdom2 : revokedNation.getKingdoms()) {
            kingdom2.getRelations().keySet().removeIf(x -> nation.getMembers().contains(x));
        }
        for (Player member : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_REVOKE_SENDER.sendMessage((CommandSender)member, "nation", revokedNation.getName());
        }
        for (Player member : revokedNation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_REVOKE_RECEIVER.sendMessage((CommandSender)member, "nation", nation.getName());
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isPlayer()) {
            Player player = context.senderAsPlayer();
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return CommandNationRevoke.emptyTab();
            }
            Nation nation = kingdom.getNation();
            if (nation == null) {
                return CommandNationRevoke.emptyTab();
            }
            return nation.getRelations().keySet().stream().map(x -> Nation.getNation(x).getName()).collect(Collectors.toList());
        }
        return CommandNationRevoke.emptyTab();
    }
}

