/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.invitations;

import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomInvite;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationAccept
extends KingdomsCommand {
    public CommandNationAccept(KingdomsParentCommand parent) {
        super("accept", parent, PermissionDefault.TRUE);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        if (!kp.hasPermission(StandardKingdomPermission.NATION)) {
            StandardKingdomPermission.NATION.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        Map<UUID, KingdomInvite> invites = kingdom.getNationInvites();
        if (invites.isEmpty()) {
            KingdomsLang.COMMAND_NATION_ACCEPT_NO_INVITES.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!context.assertArgs(1)) {
            if (invites.size() != 1) {
                KingdomsLang.COMMAND_NATION_ACCEPT_MULTIPLE_INVITES.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            Map.Entry<UUID, KingdomInvite> inviteEntry = invites.entrySet().iterator().next();
            KingdomInvite invite = inviteEntry.getValue();
            Nation nation = Nation.getNation(inviteEntry.getKey());
            invites.clear();
            if (nation == null) {
                KingdomsLang.COMMAND_NATION_ACCEPT_NO_LONGER_EXISTS.sendMessage((CommandSender)player);
                return CommandResult.FAILED;
            }
            if (!invite.canAccept()) {
                KingdomsLang.COMMAND_NATION_ACCEPT_EXPIRED.sendMessage((CommandSender)player, "nation", nation.getName());
                return CommandResult.FAILED;
            }
            KingdomPlayer inviter = invite.getKingdomPlayer();
            OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
            if (kingdom.joinNation(nation, kp).isCancelled()) {
                return CommandResult.FAILED;
            }
            KingdomsLang.COMMAND_NATION_ACCEPT_ACCEPTED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "nation", nation.getName());
            if (inviterPlayer.isOnline()) {
                KingdomsLang.COMMAND_NATION_ACCEPT_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName(), "kingdom", kingdom.getName());
            }
            for (Player members : nation.getOnlineMembers()) {
                KingdomsLang.COMMAND_NATION_ACCEPT_JOINED.sendMessage((CommandSender)members, (OfflinePlayer)player, new Object[]{"kingdom", kingdom.getName()});
            }
            return CommandResult.FAILED;
        }
        Nation nation = Nation.getNation(context.arg(0));
        if (nation == null) {
            KingdomsLang.COMMAND_NATION_ACCEPT_NO_LONGER_EXISTS.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        KingdomInvite invite = invites.remove(kingdom.getId());
        if (invite == null) {
            KingdomsLang.COMMAND_NATION_ACCEPT_NOT_INVITED.sendMessage((CommandSender)player, "nation", kingdom.getName());
            return CommandResult.FAILED;
        }
        if (!invite.canAccept()) {
            KingdomsLang.COMMAND_NATION_ACCEPT_EXPIRED.sendMessage((CommandSender)player, "nation", kingdom.getName());
            return CommandResult.FAILED;
        }
        KingdomPlayer inviter = invite.getKingdomPlayer();
        OfflinePlayer inviterPlayer = inviter.getOfflinePlayer();
        if (nation.getMembers().size() >= nation.getMaxMembers()) {
            KingdomsLang.COMMAND_ACCEPT_MAX_MEMBERS.sendMessage((CommandSender)player, inviterPlayer, new Object[0]);
            return CommandResult.FAILED;
        }
        if (kingdom.joinNation(nation, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        KingdomsLang.COMMAND_NATION_ACCEPT_ACCEPTED.sendMessage((CommandSender)player, "inviter", inviterPlayer.getName(), "nation", kingdom.getName());
        if (inviterPlayer.isOnline()) {
            KingdomsLang.COMMAND_NATION_ACCEPT_NOTIFY.sendMessage((CommandSender)((Player)inviterPlayer), "name", player.getName(), "kingdom", kingdom.getName());
        }
        for (Player members : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_ACCEPT_JOINED.sendMessage((CommandSender)members, (OfflinePlayer)player, new Object[]{"kingdom", kingdom.getName()});
        }
        return CommandResult.SUCCESS;
    }
}

