/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.elections;

import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.election.AbstractCommandElectionVote;
import org.kingdoms.commands.nation.elections.CommandNationElection;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.gui.pagination.GUIPagination;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.managers.daily.elections.ElectionCandidate;
import org.kingdoms.managers.daily.elections.Elections;

public class CommandNationElectionVote
extends AbstractCommandElectionVote {
    public CommandNationElectionVote(KingdomsParentCommand parent) {
        super(parent, Elections.NATIONS);
    }

    @Override
    protected boolean commonChecks(CommandContext context) {
        return CommandNationElection.electionCommons(context, this.electionsManager);
    }

    @Override
    protected void addCandidates(Player voter, Runnable refresh, GUIPagination<ElectionCandidate> pagination) {
        for (ElectionCandidate candidate : pagination.getPaginatedElements()) {
            Kingdom kingdom = Kingdom.getKingdom(candidate.getId());
            Objects.requireNonNull(kingdom, () -> "No kingdom candidate found with ID: " + candidate.getId());
            pagination.getOption().setEdits("votes", candidate.getVotes().size(), "candidates-description", candidate.getStatement()).onNormalClicks(ctx -> {
                ctx.var("candidate", kingdom.getName());
                UUID currentVoteId = this.electionsManager.getVote(voter);
                if (currentVoteId == null) {
                    this.electionsManager.vote(voter, candidate.getId());
                    ctx.sendMessage((Messenger)KingdomsLang.COMMAND_ELECTION_VOTE_VOTED, new Object[0]);
                    refresh.run();
                } else {
                    OfflinePlayer currentVotedCandidate = Bukkit.getOfflinePlayer((UUID)currentVoteId);
                    ctx.var("previous-candidate", currentVotedCandidate.getName());
                    if (currentVotedCandidate.getUniqueId().equals(candidate.getId())) {
                        ctx.sendError(KingdomsLang.COMMAND_ELECTION_VOTE_ALREADY_VOTED, new Object[0]);
                    } else {
                        ctx.sendError(KingdomsLang.COMMAND_ELECTION_VOTE_VOTED_AGAIN, new Object[0]);
                    }
                }
            }).pushHead(kingdom.getKing().getOfflinePlayer());
        }
    }
}

