/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation.elections;

import java.time.temporal.ChronoUnit;
import org.bukkit.permissions.PermissionDefault;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.nation.elections.CommandNationElectionRegister;
import org.kingdoms.commands.nation.elections.CommandNationElectionStatement;
import org.kingdoms.commands.nation.elections.CommandNationElectionVote;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.managers.daily.elections.ElectionsManager;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandNationElection
extends KingdomsParentCommand {
    public CommandNationElection(KingdomsParentCommand parent) {
        super("election", parent, PermissionDefault.TRUE);
        if (this.isDisabled()) {
            return;
        }
        new CommandNationElectionVote(this);
        new CommandNationElectionRegister(this);
        new CommandNationElectionStatement(this);
    }

    public static boolean electionCommons(CommandContext context, ElectionsManager electionsManager) {
        if (!electionsManager.isAcceptingVotes()) {
            context.sendError(KingdomsLang.COMMAND_ELECTION_NO_ONGOING_ELECTION, "next-election", TimeFormatter.of(electionsManager.untilNextRun(ChronoUnit.MILLIS)));
            return true;
        }
        if (context.assertPlayer()) {
            return true;
        }
        if (context.assertHasNation()) {
            return true;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        if (!kp.getRank().isKing()) {
            context.sendError(KingdomsLang.COMMAND_NATION_ELECTION_KING_ONLY, new Object[0]);
            return true;
        }
        return false;
    }
}

