/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.others.CommandShow;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;

public class CommandNationShowPlayers
extends KingdomsCommand {
    public CommandNationShowPlayers(KingdomsParentCommand parent) {
        super("showplayers", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertHasNation()) {
            return CommandResult.FAILED;
        }
        Nation nation = context.getKingdom().getNation();
        for (Kingdom kingdom : nation.getKingdoms()) {
            MessageObjectLinker membersBuilder = CommandShow.showMembers(kingdom, context.getMessageReceiver());
            MessagePlaceholderProvider placeholderCtx = new MessagePlaceholderProvider().withContext(kingdom).raw("members", membersBuilder);
            context.sendMessage((Messenger)KingdomsLang.COMMAND_NATION_SHOWPLAYERS_ENTRY, placeholderCtx);
        }
        return CommandResult.SUCCESS;
    }
}

