/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandNationRename
extends KingdomsCommand {
    private static final Cooldown<UUID> COOLDOWN = new Cooldown();

    public CommandNationRename(KingdomsParentCommand parent) {
        super("rename", parent);
    }

    public static boolean checkName(String name, Player player) {
        Nation nation;
        int len;
        int max = KingdomsConfig.NATION_NAME_MAX_LENGTH.getInt();
        int min = KingdomsConfig.NATION_NAME_MIN_LENGTH.getInt();
        int n = len = KingdomsConfig.NATION_NAME_IGNORE_COLORS.getBoolean() ? MessageHandler.stripColors(name, false).length() : name.length();
        if (len < min || len > max) {
            KingdomsLang.COMMAND_NATION_CREATE_NAME_LENGTH.sendMessage((CommandSender)player, "max", max, "min", min);
            return false;
        }
        if (!KingdomsConfig.NATION_NAME_ALLOW_NUMBERS.getBoolean() && Numbers.containsAnyLangNumber(name)) {
            KingdomsLang.COMMAND_NATION_CREATE_NAME_NUMBERS.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.NATION_NAME_ALLOW_NON_ENGLISH.getBoolean() && !Strings.isEnglish(name)) {
            KingdomsLang.COMMAND_NATION_CREATE_NAME_ENGLISH.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.NATION_NAME_ALLOW_SYMBOLS.getBoolean() && Strings.hasSymbol(name)) {
            KingdomsLang.COMMAND_NATION_CREATE_NAME_HAS_SYMBOLS.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.NATION_NAME_ALLOW_DUPLICATE_NAMES.getBoolean() && (nation = Nation.getNation(name)) != null) {
            KingdomsLang.COMMAND_NATION_CREATE_NAME_ALREADY_IN_USE.sendMessage((CommandSender)player);
            return false;
        }
        boolean match = false;
        String smallName = name.toLowerCase();
        for (String regex : KingdomsConfig.NATION_NAME_BLACKLISTED_NAMES.getStringList()) {
            if (!Pattern.compile(regex).matcher(smallName).find()) continue;
            match = true;
            break;
        }
        if (match) {
            KingdomsLang.KINGDOM_NAME_BLACKLISTED.sendMessage((CommandSender)player);
            return false;
        }
        return true;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasNationPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        long cd = COOLDOWN.getTimeLeft(kingdom.getNationId());
        if (cd > 0L) {
            context.sendError(KingdomsLang.COMMAND_NATION_RENAME_COOLDOWN, "cooldown", TimeFormatter.of(cd));
            return CommandResult.FAILED;
        }
        String name = Strings.buildArguments(context.args, "");
        Nation nation = kingdom.getNation();
        if (!kp.isAdmin()) {
            if (!CommandNationRename.checkName(name, player)) {
                return CommandResult.FAILED;
            }
            double cost = KingdomsConfig.ECONOMY_COSTS_RENAME_NATION.getDouble();
            if (!nation.getBank().has(cost)) {
                KingdomsLang.COMMAND_NATION_RENAME_COST.sendMessage((CommandSender)player, "cost", cost);
                return CommandResult.FAILED;
            }
            nation.getBank().subtract(cost);
        }
        String msg = KingdomsLang.COMMAND_NATION_RENAME_SUCCESS.parse(player, new Object[]{"name", name});
        if (KingdomsConfig.ANNOUNCEMENTS_RENAME.getBoolean()) {
            for (Player member : Bukkit.getOnlinePlayers()) {
                member.sendMessage(msg);
            }
        } else {
            for (Player member : nation.getOnlineMembers()) {
                member.sendMessage(msg);
            }
        }
        if (!nation.rename(name, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        COOLDOWN.add(kingdom.getNationId(), KingdomsConfig.NATION_NAME_RENAMING_COOLDOWN.getTimeMillis());
        return CommandResult.SUCCESS;
    }
}

