/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.nation;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.members.LeaveReason;
import org.kingdoms.locale.KingdomsLang;

public class CommandNationLeave
extends KingdomsCommand {
    public CommandNationLeave(KingdomsParentCommand parent) {
        super("leave", parent);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.hasNation()) {
            KingdomsLang.NO_NATION.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Nation nation = kingdom.getNation();
        if (nation.getCapitalId().equals(kingdom.getId())) {
            KingdomsLang.COMMAND_NATION_LEAVE_CAPITAL.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.NATION)) {
            StandardKingdomPermission.NATION.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        for (Player member : nation.getOnlineMembers()) {
            KingdomsLang.COMMAND_NATION_LEAVE_ANNOUNCE.sendMessage((CommandSender)member, (OfflinePlayer)player, new Object[0]);
        }
        kingdom.leaveNation(LeaveReason.LEFT);
        return CommandResult.SUCCESS;
    }
}

