/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.text;

import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.libs.xseries.particles.XParticle;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.cooldown.Cooldown;
import org.kingdoms.utils.internal.numbers.Numbers;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandRename
extends KingdomsCommand {
    private static final Cooldown<UUID> KINGDOM_COOLDOWN = new Cooldown();

    public CommandRename() {
        super("rename", true);
    }

    public static Cooldown<UUID> getKingdomCooldown() {
        return KINGDOM_COOLDOWN;
    }

    public static boolean checkName(String name, Player player) {
        int len;
        int max = KingdomsConfig.KINGDOM_NAME_MAX_LENGTH.getInt();
        int min = KingdomsConfig.KINGDOM_NAME_MIN_LENGTH.getInt();
        int n = len = KingdomsConfig.KINGDOM_NAME_IGNORE_COLORS.getBoolean() ? MessageHandler.stripColors(MessageHandler.colorize(name), false).length() : name.length();
        if (len < min || len > max) {
            KingdomsLang.COMMAND_CREATE_NAME_LENGTH.sendMessage((CommandSender)player, "max", max, "min", min);
            return false;
        }
        if (!KingdomsConfig.KINGDOM_NAME_ALLOW_NUMBERS.getBoolean() && Numbers.containsAnyLangNumber(name)) {
            KingdomsLang.COMMAND_CREATE_NAME_NUMBERS.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.KINGDOM_NAME_ALLOW_NON_ENGLISH.getBoolean() && !Strings.isEnglish(name)) {
            KingdomsLang.COMMAND_CREATE_NAME_ENGLISH.sendMessage((CommandSender)player);
            return false;
        }
        if (!KingdomsConfig.KINGDOM_NAME_ALLOW_SYMBOLS.getBoolean() && Strings.hasSymbol(name)) {
            KingdomsLang.COMMAND_CREATE_NAME_HAS_SYMBOLS.sendMessage((CommandSender)player);
            return false;
        }
        boolean match = false;
        for (String regex : KingdomsConfig.KINGDOM_NAME_BLACKLISTED_NAMES.getStringList()) {
            if (!Pattern.compile(regex).matcher(name).find()) continue;
            match = true;
            break;
        }
        if (match) {
            KingdomsLang.KINGDOM_NAME_BLACKLISTED.sendMessage((CommandSender)player);
            return false;
        }
        return true;
    }

    public static boolean forbidden(Player player, String name) {
        Kingdom kingdom;
        if (!KingdomsConfig.KINGDOM_NAME_ALLOW_DUPLICATE_NAMES.getBoolean() && (kingdom = Kingdom.getKingdom(name)) != null) {
            KingdomsLang.COMMAND_CREATE_NAME_ALREADY_IN_USE.sendMessage((CommandSender)player, "kingdom", kingdom.getName());
            return true;
        }
        if (!name.toLowerCase(Locale.ENGLISH).contains("apothicas")) {
            return false;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            MessageHandler.sendPlayerPluginMessage(player, "&4You can't choose that name.");
            XSound.AMBIENT_CAVE.record().soundPlayer().forPlayers(new Player[]{player}).play();
            ParticleDisplay.of((XParticle)XParticle.ELDER_GUARDIAN).onlyVisibleTo(new Player[]{player}).spawn(player.getLocation());
        }, 20L);
        player.setPlayerTime(18000L, false);
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> ((Player)player).resetPlayerTime(), 60L);
        return true;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        long cd;
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.LORE)) {
            StandardKingdomPermission.LORE.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        if (context.isAdmin() && (cd = KINGDOM_COOLDOWN.getTimeLeft(kp.getKingdomId())) > 0L) {
            context.sendError(KingdomsLang.COMMAND_RENAME_COOLDOWN, "cooldown", TimeFormatter.of(cd));
            return CommandResult.FAILED;
        }
        String name = context.assertArgs(1) ? Strings.buildArguments(context.args, KingdomsConfig.KINGDOM_NAME_ALLOW_SPACES.getBoolean() ? " " : "") : context.arg(0);
        if (name.equalsIgnoreCase("apothicas")) {
            MessageHandler.sendPlayerPluginMessage(player, "&4You can't choose that name.");
            return CommandResult.FAILED;
        }
        if (CommandRename.forbidden(player, name)) {
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_RENAME_BYPASS_COST)) {
            if (!CommandRename.checkName(name, player)) {
                return CommandResult.FAILED;
            }
            double cost = KingdomsConfig.ECONOMY_COSTS_RENAME_KINGDOM.getDouble();
            if (!kingdom.getBank().has(cost)) {
                KingdomsLang.COMMAND_RENAME_COST.sendMessage((CommandSender)player, "cost", cost);
                return CommandResult.FAILED;
            }
            kingdom.getBank().add(-cost);
        }
        MessagePlaceholderProvider msgSettings = new MessagePlaceholderProvider().withContext(player).raw("name", name);
        KingdomsLang msg = KingdomsLang.COMMAND_RENAME_SUCCESS;
        if (KingdomsConfig.ANNOUNCEMENTS_RENAME.getBoolean()) {
            for (Player member : Bukkit.getOnlinePlayers()) {
                msg.sendMessage((CommandSender)member, msgSettings);
            }
        } else {
            for (Player member : kingdom.getOnlineMembers()) {
                msg.sendMessage((CommandSender)member, msgSettings);
            }
        }
        if (!kingdom.rename(name, kp).isCancelled()) {
            return CommandResult.FAILED;
        }
        KINGDOM_COOLDOWN.add(kp.getKingdomId(), KingdomsConfig.KINGDOM_NAME_RENAMING_COOLDOWN.getTimeMillis());
        return CommandResult.SUCCESS;
    }
}

