/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.resourcepoints;

import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.commands.general.resourcepoints.CommandResourcePoints;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.events.general.GroupResourcePointConvertEvent;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandResourcePointsDeposit
extends KingdomsCommand {
    public CommandResourcePointsDeposit(KingdomsParentCommand parent) {
        super("deposit", parent);
    }

    public static boolean handleDeposit(KingdomPlayer kp, Player player, Kingdom kingdom, double rp) {
        double worth = rp * KingdomsConfig.ECONOMY_RESOURCE_POINTS_WORTH_BUY.getDouble();
        String fancyRp = Numbers.toFancyNumber(rp);
        String fancyWorth = Numbers.toFancyNumber(worth);
        if (!ServiceVault.hasMoney((OfflinePlayer)player, worth)) {
            String fancyBalance = Numbers.toFancyNumber(ServiceVault.getMoney((OfflinePlayer)player));
            KingdomsLang.COMMAND_RESOURCEPOINTS_NOT_ENOUGH_MONEY.sendError((CommandSender)player, "rp", fancyRp, "worth", fancyWorth, "balance", fancyBalance);
            return false;
        }
        if (kp.hasKingdom()) {
            GroupResourcePointConvertEvent event = kp.donate(kingdom, rp);
            if (event.isCancelled()) {
                return false;
            }
            rp = event.getAmount();
        }
        fancyRp = Numbers.toFancyNumber(rp);
        kingdom.getResourcePoints().add(rp);
        ServiceVault.withdraw((OfflinePlayer)player, worth);
        String fancyBalance = Numbers.toFancyNumber(ServiceVault.getMoney((OfflinePlayer)player));
        KingdomsLang.COMMAND_RESOURCEPOINTS_DEPOSIT_SUCCESS.sendMessage((CommandSender)player, "rp", fancyRp, "worth", fancyWorth, "balance", fancyBalance);
        return true;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        Long amount = CommandResourcePoints.validateAmount(true, context, KingdomsLang.COMMAND_RESOURCEPOINTS_DEPOSIT_USAGE, 0);
        if (amount == null) {
            return CommandResult.FAILED;
        }
        CommandResourcePointsDeposit.handleDeposit(kp, player, kingdom, amount.longValue());
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        return CommandResourcePoints.processTabComplete(context, true);
    }
}

