/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.LanguageEntryWithContext;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.kingdoms.RelationUtil;

public class CommandRevoke
extends KingdomsCommand {
    public CommandRevoke() {
        super("revoke", true);
    }

    static StandardKingdomPermission getPermissionForRelation(KingdomRelation relation) {
        switch (relation) {
            case ALLY: {
                return StandardKingdomPermission.ALLIANCE;
            }
            case TRUCE: {
                return StandardKingdomPermission.TRUCE;
            }
            case ENEMY: {
                return StandardKingdomPermission.ENEMY;
            }
        }
        return null;
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        Kingdom to = context.getKingdom(0);
        if (to == null) {
            return CommandResult.FAILED;
        }
        context.getMessageContext().other(to);
        context.var("kingdom", to.getName());
        if (!RelationUtil.hasAnyRelationManagementPermissions(kp)) {
            return CommandResult.FAILED;
        }
        if (kingdom.getId().equals(to.getId())) {
            context.sendError(KingdomsLang.COMMAND_REVOKE_SELF, new Object[0]);
            return CommandResult.FAILED;
        }
        KingdomRelation relation = kingdom.getRelationWith(to);
        LanguageEntryWithContext messageObjectBuilder = relation.getName();
        MessagePlaceholderProvider settings = context.getMessageContext();
        context.var("relation", relation.getColor() + messageObjectBuilder.buildPlain(settings));
        if (relation == KingdomRelation.NEUTRAL) {
            context.sendError(KingdomsLang.COMMAND_REVOKE_ALREADY_NEUTRAL, new Object[0]);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(CommandRevoke.getPermissionForRelation(relation))) {
            context.sendError(KingdomsLang.COMMAND_REVOKE_SPECIFIC_PERMISSION, new Object[0]);
            return CommandResult.FAILED;
        }
        if (relation == KingdomRelation.ENEMY) {
            KingdomRelationshipRequest request = kingdom.getRelationshipRequests().remove(to.getId());
            if (request != null) {
                KingdomRelation requestRelation = request.getRelation();
                if (requestRelation != KingdomRelation.NEUTRAL) {
                    context.sendError(KingdomsLang.RELATIONS_ANOTHER_REQUEST, new Object[0]);
                    return CommandResult.FAILED;
                }
                RelationUtil.acceptRequest(player, kingdom, to, KingdomRelation.NEUTRAL, KingdomsLang.COMMAND_REVOKE_NEUTRALS);
                return CommandResult.FAILED;
            }
            if (kingdom.sendRelationshipRequest(kp, to, KingdomRelation.NEUTRAL).isCancelled()) {
                return CommandResult.FAILED;
            }
            context.sendMessage((Messenger)KingdomsLang.COMMAND_REVOKE_REQUEST_SENDER, new Object[0]);
            for (Player member : to.getOnlineMembers()) {
                MessagePlaceholderProvider ctx = new MessagePlaceholderProvider().withContext(member).other(kingdom).parse("relation", KingdomRelation.NEUTRAL.getColor() + KingdomRelation.NEUTRAL.getName().buildPlain(context.getMessageContext()));
                KingdomsLang.COMMAND_REVOKE_REQUEST_RECEIVER.sendMessage((CommandSender)member, ctx);
            }
        } else {
            RelationUtil.acceptRequest(player, kingdom, to, KingdomRelation.NEUTRAL, KingdomsLang.COMMAND_REVOKE_SENDER, KingdomsLang.COMMAND_REVOKE_RECEIVER);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isPlayer() && context.isAtArg(0)) {
            Kingdom kingdom = context.getKingdom();
            if (kingdom == null) {
                return CommandRevoke.emptyTab();
            }
            return context.suggest(0, (String[])kingdom.getRelations().keySet().stream().map(Kingdom::getKingdom).map(x -> x.getName()).toArray(String[]::new));
        }
        return CommandRevoke.emptyTab();
    }
}

