/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.relation;

import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.KingdomRelation;
import org.kingdoms.constants.group.model.relationships.KingdomRelationshipRequest;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.kingdoms.RelationUtil;

public class CommandRejectRelation
extends KingdomsCommand {
    public CommandRejectRelation() {
        super("rejectrelation", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = context.getKingdomPlayer();
        Kingdom kingdom = kp.getKingdom();
        if (!RelationUtil.hasAnyRelationManagementPermissions(kp)) {
            return CommandResult.FAILED;
        }
        if (kingdom.getRelationshipRequests().isEmpty()) {
            context.sendError(KingdomsLang.RELATIONS_NO_REQUESTS, new Object[0]);
            return CommandResult.FAILED;
        }
        Kingdom rejectedKingdom = context.getKingdom(0);
        if (rejectedKingdom == null) {
            return CommandResult.FAILED;
        }
        context.getMessageContext().withContext(rejectedKingdom);
        KingdomRelationshipRequest request = kingdom.getRelationshipRequests().remove(rejectedKingdom.getId());
        if (request == null) {
            context.sendError(KingdomsLang.COMMAND_REJECTRELATION_NOT_REQUESTED, new Object[0]);
            return CommandResult.FAILED;
        }
        KingdomRelation relation = request.getRelation();
        relation.placeholders(context.getMessageContext());
        context.sendMessage((Messenger)KingdomsLang.COMMAND_REJECTRELATION_REJECTED, new Object[0]);
        context.getMessageContext().withContext(player);
        for (Player member : rejectedKingdom.getOnlineMembers()) {
            context.sendMessage((CommandSender)member, KingdomsLang.COMMAND_REJECTRELATION_NOTIFICATION, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }
}

