/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.ranking;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.TabCompleteManager;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.events.general.ranks.PlayerRankChangeContext;
import org.kingdoms.events.general.ranks.PlayerRankChangeEvent;
import org.kingdoms.events.general.ranks.RankIdentifier;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;

public class CommandPromote
extends KingdomsCommand {
    public CommandPromote() {
        super("promote", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasPermission(StandardKingdomPermission.MANAGE_RANKS)) {
            StandardKingdomPermission.MANAGE_RANKS.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        OfflinePlayer promoting = context.getOfflinePlayer(0);
        if (promoting == null) {
            return CommandResult.FAILED;
        }
        KingdomPlayer promotingKp = KingdomPlayer.getKingdomPlayer(promoting);
        if (!kp.isInSameKingdomAs(promotingKp)) {
            KingdomsLang.COMMAND_PROMOTE_NOT_IN_KINGDOM.sendError((CommandSender)player, "promoted", promoting.getName());
            return CommandResult.FAILED;
        }
        CommandPromote.promote(kp, promotingKp);
        return CommandResult.SUCCESS;
    }

    public static boolean promote(KingdomPlayer promoterKp, KingdomPlayer promotedKp) {
        Player promoter = promoterKp.getPlayer();
        OfflinePlayer promoting = promotedKp.getOfflinePlayer();
        Rank promotedRank = promotedKp.getRank();
        if (!promoterKp.isAdmin() && !promoterKp.getRank().isHigherThan(promotedRank)) {
            KingdomsLang.COMMAND_PROMOTE_CANT_PROMOTE.sendError((CommandSender)promoter, "promoted", promoting.getName());
            return false;
        }
        if (!promotedRank.canBePromoted()) {
            KingdomsLang.COMMAND_PROMOTE_KING.sendError((CommandSender)promoter, "promoted", promoting.getName(), "rank", promotedRank.getColor() + promotedRank.getName());
            return false;
        }
        Kingdom kingdom = promotedKp.getKingdom();
        PlayerRankChangeEvent newRankEvent = promotedKp.changeRank(new PlayerRankChangeContext(kingdom, RankIdentifier.promote()).byPlayer(promoterKp));
        newRankEvent.getOldRank();
        if (newRankEvent.isCancelled()) {
            return false;
        }
        Rank newRank = newRankEvent.getRank();
        for (Player member : promotedKp.getKingdom().getOnlineMembers()) {
            KingdomsLang.COMMAND_PROMOTE_PROMOTED.sendMessage((CommandSender)member, (OfflinePlayer)promoter, new Object[]{"rank", newRank.getColor() + newRank.getName(), "promoted", promoting.getName()});
        }
        return true;
    }

    @Override
    public @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context instanceof Player) {
            Player player = (Player)context;
            KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
            Kingdom kingdom = kp.getKingdom();
            if (kingdom == null) {
                return Collections.singletonList(KingdomsLang.NO_KINGDOM_DEFAULT.parse(player, new Object[0]));
            }
            if (context.isAtArg(0)) {
                return TabCompleteManager.getKingdomPlayers(kingdom, context.args[0], p -> p != context);
            }
        }
        return new ArrayList<String>();
    }
}

