/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.Collections;
import java.util.Optional;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.config.implementation.YamlConfigAccessor;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.resourcepoints.ResourcePointManager;
import org.kingdoms.managers.resourcepoints.ResourcePointWorthType;
import org.kingdoms.utils.internal.numbers.Numbers;

public class CommandTradable
extends KingdomsCommand {
    public CommandTradable() {
        super("tradable", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        ItemStack item = player.getInventory().getItemInMainHand().clone();
        int amount = item.getAmount();
        item.setAmount(1);
        boolean isEmpty = item.getType() == Material.AIR;
        double worth = isEmpty ? 0.0 : ResourcePointManager.convertToResourcePoints(Collections.singleton(item), null, ResourcePointWorthType.with(ResourcePointWorthType.NORMAL)).getTotalWorth();
        YamlConfigAccessor section = KingdomsConfig.ResourcePoints.CUSTOM.getManager().getSection();
        MessageObjectLinker linker = new MessageObjectLinker();
        for (String materials : section.getKeys()) {
            Optional matOpt = XMaterial.matchXMaterial((String)materials);
            if (!matOpt.isPresent()) continue;
            int special = section.getInt(materials);
            linker.add(KingdomsLang.COMMAND_TRADABLE_ITEM, new MessagePlaceholderProvider().parse("material", KingdomsLang.translate((XMaterial)matOpt.get())).raw("worth", special)).add("\n");
        }
        context.getMessageContext().raw("worth", worth == 0.0 ? KingdomsLang.COMMAND_TRADABLE_NOT_SPECIAL : Numbers.toFancyNumber(worth));
        context.sendMessage((Messenger)KingdomsLang.COMMAND_TRADABLE_MESSAGE, "amount", isEmpty ? 0 : amount, "total", Numbers.toFancyNumber((double)amount * worth), "list", linker);
        return CommandResult.SUCCESS;
    }
}

