/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.abstraction.KingdomBuildingStyle;
import org.kingdoms.constants.land.abstraction.KingdomBuildingType;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.locale.KingdomsLang;

public class CommandSell
extends KingdomsCommand {
    public CommandSell() {
        super("sell", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        ItemStack item = player.getInventory().getItemInMainHand();
        Pair<KingdomBuildingStyle<?, ?, ?>, Integer> type = KingdomBuildingType.getTypeOf(item);
        if (type == null || type.getKey() == null) {
            KingdomsLang.COMMAND_SELL_INVALID.sendError((CommandSender)player, new Object[0]);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        long price = type.getKey().getSellCost(type.getValue(), kingdom) * (long)item.getAmount();
        player.getInventory().setItemInMainHand(null);
        kp.getKingdom().getResourcePoints().add(price);
        XMaterial mat = XMaterial.matchXMaterial((ItemStack)item);
        KingdomsLang.COMMAND_SELL_ITEM.sendMessage((CommandSender)player, "amount", item.getAmount(), "item", item.getItemMeta().getDisplayName(), "material", KingdomsLang.translate(mat), "price", price);
        return CommandResult.SUCCESS;
    }
}

