/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.abstraction.processor.KingdomsProcess;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.general.invitations.CommandAccept;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.Rank;
import org.kingdoms.events.general.GroupDisband;
import org.kingdoms.events.lands.ClaimLandEvent;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.functions.Function2;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.messenger.LanguageEntryMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.managers.land.claiming.ClaimProcessor;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.conditions.ConditionProcessor;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/kingdoms/commands/general/others/CommandMerge;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCommandMerge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandMerge.kt\norg/kingdoms/commands/general/others/CommandMerge\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,208:1\n1863#2,2:209\n1863#2,2:211\n1863#2,2:213\n*S KotlinDebug\n*F\n+ 1 CommandMerge.kt\norg/kingdoms/commands/general/others/CommandMerge\n*L\n185#1:209,2\n188#1:211,2\n201#1:213,2\n*E\n"})
public final class CommandMerge
extends KingdomsCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Cache<UUID, UUID> sentRequests;
    @NotNull
    private static final Cache<UUID, UUID> receivedRequests;

    public CommandMerge() {
        super("merge", true);
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Iterable $this$forEach$iv;
        boolean isTheAcceptingKingdom;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        Rank rank = kp.getRank();
        Boolean bl = rank != null ? Boolean.valueOf(rank.isKing()) : null;
        Intrinsics.checkNotNull((Object)bl);
        if (!bl.booleanValue()) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_MERGE_ONLY_KING);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        Kingdom ownKingdom = context.getKingdom();
        Kingdom kingdom = context.getKingdom(0);
        if (kingdom == null) {
            return CommandResult.FAILED;
        }
        Kingdom targetKingdom = kingdom;
        if (Intrinsics.areEqual((Object)ownKingdom.getKey(), (Object)targetKingdom.getKey())) {
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_MERGE_OWN);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        ConfigSection configSection = KingdomsConfig.MERGING_CONDITIONS_SENDER.getManager().getSection().getSection();
        Intrinsics.checkNotNullExpressionValue((Object)configSection, (String)"getSection(...)");
        ConfigSection senderConditions = configSection;
        for (String string : senderConditions.getKeys()) {
            if (!ConditionProcessor.process(ConditionalCompiler.compile(string).evaluate(), new MessagePlaceholderProvider().withContext(ownKingdom).other(targetKingdom))) continue;
            context.getMessageContext().raw("error", string);
            LanguageEntry languageEntry = senderConditions.get(NodeInterpreter.LANGUAGE_ENTRY, string);
            Intrinsics.checkNotNull((Object)languageEntry);
            Messenger msg = new LanguageEntryMessenger(languageEntry);
            if (msg.getProvider(kp.getLanguage()) == null) {
                msg = KingdomsLang.COMMAND_MERGE_FAILED_UNKNOWN;
            }
            CommandResult commandResult = context.fail(msg);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        ConfigSection configSection2 = KingdomsConfig.MERGING_CONDITIONS_RECEIVER.getManager().getSection().getSection();
        Intrinsics.checkNotNullExpressionValue((Object)configSection2, (String)"getSection(...)");
        ConfigSection receiverConditions = configSection2;
        for (String key : receiverConditions.getKeys()) {
            if (!ConditionProcessor.process(ConditionalCompiler.compile(key).evaluate(), new MessagePlaceholderProvider().withContext(targetKingdom).other(ownKingdom))) continue;
            context.getMessageContext().raw("error", key);
            LanguageEntry languageEntry = receiverConditions.get(NodeInterpreter.LANGUAGE_ENTRY, key);
            Intrinsics.checkNotNull((Object)languageEntry);
            Messenger msg = new LanguageEntryMessenger(languageEntry);
            if (msg.getProvider(kp.getLanguage()) == null) {
                msg = KingdomsLang.COMMAND_MERGE_FAILED_UNKNOWN;
            }
            CommandResult commandResult = context.fail(msg);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        UUID uUID = (UUID)sentRequests.getIfPresent((Object)ownKingdom.getKey());
        if (uUID != null) {
            Kingdom sentKingdom = Kingdom.getKingdom(uUID);
            context.getMessageContext().withContext(sentKingdom);
            CommandResult commandResult = context.fail(KingdomsLang.COMMAND_MERGE_ALREADY_SENT);
            Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
            return commandResult;
        }
        boolean bl2 = isTheAcceptingKingdom = sentRequests.getIfPresent((Object)targetKingdom.getKey()) != null;
        if (!context.argEquals(1, "confirm")) {
            Kingdom from = isTheAcceptingKingdom ? targetKingdom : ownKingdom;
            Kingdom to = isTheAcceptingKingdom ? ownKingdom : targetKingdom;
            Intrinsics.checkNotNull((Object)from);
            Intrinsics.checkNotNull((Object)to);
            boolean willLoseMembers = Companion.loseMembersNotice(context, from, to);
            boolean willLoseLands = Companion.unmergableLands(context, from, to);
            if (willLoseMembers || willLoseLands) {
                return CommandResult.PARTIAL;
            }
        }
        if (isTheAcceptingKingdom) {
            Player x;
            sentRequests.invalidate((Object)targetKingdom.getKey());
            receivedRequests.invalidate((Object)ownKingdom.getKey());
            Intrinsics.checkNotNull((Object)ownKingdom);
            Companion.merge(targetKingdom, ownKingdom);
            context.getMessageContext().raw("kingdom", targetKingdom.getName());
            List<Player> list = ownKingdom.getOnlineMembers();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getOnlineMembers(...)");
            $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                x = (Player)element$iv;
                boolean bl3 = false;
                context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_MERGE_MERGED_RECEIVER, new Object[0]);
            }
            context.getMessageContext().raw("kingdom", ownKingdom.getName());
            List<Player> list2 = targetKingdom.getOnlineMembers();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getOnlineMembers(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                x = (Player)element$iv;
                boolean bl4 = false;
                context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_MERGE_MERGED_SENDER, new Object[0]);
            }
            return CommandResult.SUCCESS;
        }
        sentRequests.put((Object)ownKingdom.getKey(), (Object)targetKingdom.getKey());
        receivedRequests.put((Object)targetKingdom.getKey(), (Object)ownKingdom.getKey());
        context.getMessageContext().withContext(targetKingdom);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_MERGE_REQUEST_SENT, new Object[0]);
        context.getMessageContext().withContext(ownKingdom);
        List<Player> list = targetKingdom.getOnlineMembers();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getOnlineMembers(...)");
        $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player x = (Player)element$iv;
            boolean bl5 = false;
            context.sendMessage((CommandSender)x, KingdomsLang.COMMAND_MERGE_REQUEST_RECEIVED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<String> list = context.getKingdoms(0);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getKingdoms(...)");
        return list;
    }

    @JvmStatic
    public static final void merge(@NotNull Kingdom from, @NotNull Kingdom to) {
        Companion.merge(from, to);
    }

    @JvmStatic
    public static final boolean unmergableLands(@NotNull CommandContext context, @NotNull Kingdom from, @NotNull Kingdom to) {
        return Companion.unmergableLands(context, from, to);
    }

    static {
        Cache cache = CacheHandler.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        sentRequests = cache;
        Cache cache2 = CacheHandler.newBuilder().expireAfterWrite(Duration.ofSeconds(30L)).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache2, (String)"build(...)");
        receivedRequests = cache2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J\u001e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR/\u0010\u0004\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a#\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/commands/general/others/CommandMerge$Companion;", "", "<init>", "()V", "sentRequests", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "Ljava/util/UUID;", "org.kingdoms.libs.kotlin.jvm.PlatformType", "Lorg/kingdoms/libs/checkerframework/checker/nullness/qual/NonNull;", "receivedRequests", "merge", "", "from", "Lorg/kingdoms/constants/group/Kingdom;", "to", "unmergableLands", "", "context", "Lorg/kingdoms/commands/CommandContext;", "loseMembersNotice", "core"})
    @SourceDebugExtension(value={"SMAP\nCommandMerge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandMerge.kt\norg/kingdoms/commands/general/others/CommandMerge$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,208:1\n216#2,2:209\n216#2,2:211\n216#2,2:213\n37#3:215\n36#3,3:216\n1863#4,2:219\n774#4:221\n865#4,2:222\n1863#4,2:228\n1755#4,3:230\n11158#5:224\n11493#5,3:225\n*S KotlinDebug\n*F\n+ 1 CommandMerge.kt\norg/kingdoms/commands/general/others/CommandMerge$Companion\n*L\n38#1:209,2\n41#1:211,2\n44#1:213,2\n46#1:215\n46#1:216,3\n49#1:219,2\n50#1:221\n50#1:222,2\n66#1:228,2\n85#1:230,3\n66#1:224\n66#1:225,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void merge(@NotNull Kingdom from, @NotNull Kingdom to) {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            UUID[] $this$filterTo$iv$iv;
            Object object;
            Object k;
            Map map;
            boolean bl;
            Object x;
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            to.getResourcePoints().plusAssign(from.getResourcePoints().get());
            to.getBank().plusAssign(from.getBank().get());
            NamespacedMap<Integer> namespacedMap = from.getMiscUpgrades();
            Intrinsics.checkNotNullExpressionValue(namespacedMap, (String)"getMiscUpgrades(...)");
            Map $this$forEach$iv2 = namespacedMap;
            boolean $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv2.entrySet()) {
                x = element$iv;
                bl = false;
                Integer n = to.getMiscUpgrades().get(x.getKey());
                if ((n != null ? n : 0) >= ((Number)x.getValue()).intValue()) continue;
                NamespacedMap<Integer> namespacedMap2 = to.getMiscUpgrades();
                Intrinsics.checkNotNullExpressionValue(namespacedMap2, (String)"getMiscUpgrades(...)");
                map = namespacedMap2;
                k = x.getKey();
                object = x.getValue();
                map.put(k, object);
            }
            NamespacedMap<Integer> namespacedMap3 = from.getChampionUpgrades();
            Intrinsics.checkNotNullExpressionValue(namespacedMap3, (String)"getChampionUpgrades(...)");
            Map $this$forEach$iv3 = namespacedMap3;
            $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv3.entrySet()) {
                x = element$iv;
                bl = false;
                Integer n = to.getChampionUpgrades().get(x.getKey());
                if ((n != null ? n : 0) >= ((Number)x.getValue()).intValue()) continue;
                NamespacedMap<Integer> namespacedMap4 = to.getChampionUpgrades();
                Intrinsics.checkNotNullExpressionValue(namespacedMap4, (String)"getChampionUpgrades(...)");
                map = namespacedMap4;
                k = x.getKey();
                object = x.getValue();
                map.put(k, object);
            }
            NamespacedMap<Integer> namespacedMap5 = from.getPowerups();
            Intrinsics.checkNotNullExpressionValue(namespacedMap5, (String)"getPowerups(...)");
            $this$forEach$iv3 = namespacedMap5;
            $i$f$forEach = false;
            for (Map.Entry element$iv : $this$forEach$iv3.entrySet()) {
                x = element$iv;
                bl = false;
                Integer n = to.getPowerups().get(x.getKey());
                if ((n != null ? n : 0) >= ((Number)x.getValue()).intValue()) continue;
                NamespacedMap<Integer> namespacedMap6 = to.getPowerups();
                Intrinsics.checkNotNullExpressionValue(namespacedMap6, (String)"getPowerups(...)");
                map = namespacedMap6;
                k = x.getKey();
                object = x.getValue();
                map.put(k, object);
            }
            Set<UUID> set = from.getMembers();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getMembers(...)");
            Collection $this$toTypedArray$iv = set;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            UUID[] members = thisCollection$iv.toArray(new UUID[0]);
            Map maxLands = new HashMap();
            Set<SimpleChunkLocation> set2 = to.getLandLocations();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"getLandLocations(...)");
            Iterable $this$forEach$iv32 = set2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv32) {
                SimpleChunkLocation x2 = (SimpleChunkLocation)element$iv;
                boolean bl2 = false;
                maxLands.compute(x2.getWorld(), (arg_0, arg_1) -> Companion.merge$lambda$5$lambda$4(Companion::merge$lambda$5$lambda$3, arg_0, arg_1));
            }
            Set<SimpleChunkLocation> set3 = from.getLandLocations();
            Intrinsics.checkNotNullExpressionValue(set3, (String)"getLandLocations(...)");
            Iterable $this$filter$iv = set3;
            boolean $i$f$filter = false;
            Iterable element$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object e : $this$filterTo$iv$iv) {
                boolean bl3;
                SimpleChunkLocation x3 = (SimpleChunkLocation)e;
                boolean bl2 = false;
                String string = x3.getWorld();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getWorld(...)");
                int total = ((Number)maxLands.getOrDefault(string, 0)).intValue();
                int maxKingdomClaim = to.getMaxClaims(x3.getWorld());
                if (total >= maxKingdomClaim) {
                    bl3 = false;
                } else {
                    maxLands.put(x3.getWorld(), total + 1);
                    bl3 = true;
                }
                if (!bl3) continue;
                destination$iv$iv.add(e);
            }
            Set locs = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            from.disband(GroupDisband.Reason.CUSTOM);
            to.claim(locs, to.getKing(), ClaimLandEvent.Reason.CUSTOM, false);
            Object $this$map$iv = members;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(((UUID[])$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void x4;
                void item$iv$iv;
                void bl2 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                collection.add(KingdomPlayer.getKingdomPlayer((UUID)x4));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv) {
                KingdomPlayer x5 = (KingdomPlayer)element$iv2;
                boolean bl5 = false;
                x5.joinKingdom(to);
            }
        }

        @JvmStatic
        public final boolean unmergableLands(@NotNull CommandContext context, @NotNull Kingdom from, @NotNull Kingdom to) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            boolean sentErrorHeader = false;
            List full = new ArrayList();
            for (SimpleChunkLocation chunk : from.getLandLocations()) {
                boolean bl;
                ClaimProcessor processor;
                block7: {
                    Intrinsics.checkNotNullExpressionValue((Object)ClaimProcessor.build(chunk, to.getKing(), to).ignoreClaimed().ignoreAdmin().phantomClaimCount(from.getLandLocations().size() - 1).process(), (String)"process(...)");
                    if (processor.isSuccessful()) continue;
                    if (!sentErrorHeader) {
                        sentErrorHeader = true;
                        context.sendError(KingdomsLang.COMMAND_MERGE_CONFIRM_LOSE_LANDS, new Object[0]);
                    }
                    Iterable $this$any$iv = processor.getMessages();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KingdomsProcess.Message x = (KingdomsProcess.Message)element$iv;
                            boolean bl2 = false;
                            if (!(x.getMessage() == KingdomsLang.COMMAND_CLAIM_MAX_CLAIMS)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    Intrinsics.checkNotNull((Object)chunk);
                    full.add(chunk);
                    continue;
                }
                CommandSender commandSender = context.getMessageReceiver();
                Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getMessageReceiver(...)");
                processor.sendMessages(commandSender);
            }
            if (!((Collection)full).isEmpty()) {
                context.var("extra_lands", full.size());
                context.sendError(KingdomsLang.COMMAND_MERGE_CONFIRM_EXTRA_LANDS, new Object[0]);
            }
            return sentErrorHeader;
        }

        public final boolean loseMembersNotice(@NotNull CommandContext context, @NotNull Kingdom from, @NotNull Kingdom to) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            KingdomsLang kingdomsLang = CommandAccept.checkRequirementsToJoin(null, to);
            if (kingdomsLang != null) {
                KingdomsLang it = kingdomsLang;
                boolean bl = false;
                context.sendError(it, new Object[0]);
                return true;
            }
            int diff = from.getMembers().size() + to.getMembers().size() - to.getMaxMembers();
            if (diff > 0) {
                context.var("lose", diff);
                context.sendError(KingdomsLang.COMMAND_MERGE_CONFIRM_LOSE_MEMBERS, new Object[0]);
                return true;
            }
            return false;
        }

        private static final Integer merge$lambda$5$lambda$3(String string, Integer total) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
            Integer n = total;
            return (n != null ? n : 0) + 1;
        }

        private static final Integer merge$lambda$5$lambda$4(Function2 $tmp0, Object p0, Object p1) {
            return (Integer)$tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

