/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIAccessor;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.gui.KingdomsGUI;
import org.kingdoms.gui.ReusableOptionHandler;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.xseries.profiles.builder.XSkull;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.config.ConfigSection;

public class CommandLanguage
extends KingdomsCommand {
    public static final String UNKNOWN_LANG_SKULL = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNGZkNWJkZTk5NGUwYTY0N2FmMTgyMzY4MWE2MTNjMmJmYzNkOTczNmY4ODlkYmY4YzNiYmJhNWExM2Y4ZWQifX19";

    public CommandLanguage() {
        super("language", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        KingdomPlayer kp = context.getKingdomPlayer();
        String detectedLocale = context.senderAsPlayer().getLocale();
        context.var("client-locale", detectedLocale);
        if (!context.assertArgs(1)) {
            MessageObjectLinker linker = new MessageObjectLinker();
            MessageObject msgObj = KingdomsLang.COMMAND_LANGUAGE_SUPPORTED_ENTRY.getMessageObject(kp.getLanguage());
            MessageObject separator = MessageCompiler.compile("&7, ");
            MessagePlaceholderProvider emptyBuilder = new MessagePlaceholderProvider();
            SupportedLanguage[] vals = SupportedLanguage.getInstalled().toArray(new SupportedLanguage[0]);
            int index = 0;
            for (SupportedLanguage lang : vals) {
                MessagePlaceholderProvider settings = new MessagePlaceholderProvider();
                settings.raw("lang", lang.getNativeName());
                settings.raw("internal-name", lang.name());
                linker.add(msgObj, settings);
                if (++index == vals.length) continue;
                linker.add(separator, emptyBuilder);
            }
            context.getMessageContext().raw("langs", linker);
            context.sendMessage((Messenger)KingdomsLang.COMMAND_LANGUAGE_INFO, new Object[0]);
            InteractiveGUI gui = CommandLanguage.openLanguageGUI(context.senderAsPlayer());
            if (gui != null) {
                gui.open();
            }
            return CommandResult.FAILED;
        }
        context.var("chosen", context.arg(0));
        SupportedLanguage chosen = SupportedLanguage.fromName(context.arg(0));
        if (chosen == null) {
            context.sendError(KingdomsLang.COMMAND_LANGUAGE_UNKNOWN_LANGUAGE, new Object[0]);
            return CommandResult.FAILED;
        }
        if (kp.getLanguage() == chosen) {
            context.sendError(KingdomsLang.COMMAND_LANGUAGE_ALREADY_SET, new Object[0]);
            return CommandResult.FAILED;
        }
        context.var("old-lang", kp.getLanguage().getNativeName());
        kp.setLanguage(chosen);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_LANGUAGE_SET, new Object[0]);
        if (chosen != Language.getDefault()) {
            context.sendError(KingdomsLang.COMMAND_LANGUAGE_NOT_ENGLISH_WARN, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        if (context.isAtArg(0)) {
            return SupportedLanguage.getInstalled().stream().map(SupportedLanguage::getNativeName).collect(Collectors.toList());
        }
        return CommandLanguage.emptyTab();
    }

    public static InteractiveGUI openLanguageGUI(Player player) {
        InteractiveGUI gui = GUIAccessor.prepare(player, KingdomsGUI.LANGUAGES);
        if (gui == null) {
            return null;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Language lang = kp.getLanguage();
        ConfigSection skulls = gui.getConfig().getSection("skulls");
        String currentLangSkull = skulls.getString(lang.getLowerCaseName());
        gui.option("current-language").editItem(item -> {
            if (!Strings.isNullOrEmpty((String)currentLangSkull)) {
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                XSkull.of((ItemMeta)meta).profile(Profileable.detect((String)currentLangSkull)).apply();
                item.setItemMeta((ItemMeta)meta);
            }
            return item;
        }).done();
        ReusableOptionHandler langOpt = gui.getReusableOption("language");
        for (SupportedLanguage otherLangs : SupportedLanguage.VALUES) {
            if (lang == otherLangs || !otherLangs.isInstalled()) continue;
            String name = otherLangs.getLowerCaseName();
            ((ReusableOptionHandler)langOpt.editItem(item -> {
                SkullMeta meta = (SkullMeta)item.getItemMeta();
                String skull = skulls.getString(name);
                if (skull == null) {
                    skull = UNKNOWN_LANG_SKULL;
                }
                XSkull.of((ItemMeta)meta).profile(Profileable.detect((String)skull)).apply();
                item.setItemMeta((ItemMeta)meta);
                return item;
            })).onNormalClicks(() -> {
                String oldLang = kp.getLanguage().getNativeName();
                kp.setLanguage(otherLangs);
                KingdomsLang.COMMAND_LANGUAGE_SET.sendMessage((CommandSender)player, "old-lang", oldLang);
                InteractiveGUI guiAgain = CommandLanguage.openLanguageGUI(player);
                if (guiAgain != null) {
                    guiAgain.open();
                }
                if (otherLangs != Language.getDefault()) {
                    KingdomsLang.COMMAND_LANGUAGE_NOT_ENGLISH_WARN.sendMessage((CommandSender)player);
                }
            }).setEdits("lang", otherLangs.getNativeName()).done();
        }
        return gui;
    }
}

