/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsCommandHandler;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.Language;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.PaginatedCommandHelp;
import org.kingdoms.utils.internal.nonnull.NonNullSet;
import org.kingdoms.utils.internal.string.StringMatcher;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeFormatter;

public class CommandHelp
extends KingdomsCommand {
    public CommandHelp() {
        super("help", true);
    }

    private static int getPageNumbers(int commands) {
        return commands % 5 != 0 ? commands / 5 + 1 : commands / 5;
    }

    private static KingdomsCommand[] filterAccessiblePages(CommandSender sender) {
        Map<String, KingdomsCommand> all = KingdomsCommandHandler.getCommands(Language.getDefault());
        NonNullSet<KingdomsCommand> orderedCommands = new NonNullSet<KingdomsCommand>(new LinkedHashSet(all.size()));
        orderedCommands.addAll(KingdomsConfig.HELP_ORDER.getManager().getStringList().stream().map(x -> {
            KingdomsCommand res = (KingdomsCommand)all.get(x);
            if (res == null) {
                KLogger.warn("Unknown command for /k help order: " + x);
            }
            return res;
        }).filter(Objects::nonNull).collect(Collectors.toList()));
        orderedCommands.addAll(all.values());
        return (KingdomsCommand[])orderedCommands.stream().filter(c -> c.hasPermission(sender)).toArray(KingdomsCommand[]::new);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertArgs(1) && !context.isNumber(0)) {
            CommandHelp.showInfoOf(context, KingdomsLang.COMMAND_HELP_INFO);
            return CommandResult.FAILED;
        }
        new PaginatedCommandHelp(context, KingdomsConfig.HELP_COMMANDS.getInt(), KingdomsLang.COMMAND_HELP_GROUP, () -> CommandHelp.filterAccessiblePages(context.getMessageReceiver())).execute();
        return CommandResult.SUCCESS;
    }

    public static void showInfoOf(CommandContext context, Messenger infoMsg) {
        KingdomsLang permScope;
        int skipArgs = 0;
        List<String> aliases = KingdomsConfig.COMMAND_ALIASES.getManager().getStringList();
        String mainName = KingdomsConfig.COMMAND_NAME.getManager().getString();
        String[] hardNames = new String[]{"k", "kingdom", "kingdoms", "kingdomsx", "xkingdom", "xkingdoms"};
        Set<String> combinedNames = new HashSet<String>(aliases);
        combinedNames.add(mainName);
        combinedNames.addAll(Arrays.asList(hardNames));
        combinedNames = combinedNames.stream().map(x -> x.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        String first = context.arg(0);
        if (first.startsWith("/")) {
            first = first.substring(1);
        }
        if (combinedNames.contains(first.toLowerCase(Locale.ENGLISH))) {
            skipArgs = 1;
        }
        KingdomsCommandHandler.CommandInformation cmdInfo = KingdomsCommandHandler.getCommand(context.getMessageContext().getLanguage(), (String[])Arrays.stream(context.args).skip(skipArgs).toArray(String[]::new));
        KingdomsCommand cmd = cmdInfo.command;
        context.var("command", context.joinArgs());
        if (cmd == null) {
            context.sendError(KingdomsLang.COMMAND_HELP_NOT_FOUND, new Object[0]);
            return;
        }
        Object usage = cmd.getUsage().parse(context.getMessageReceiver(), new Object[0]);
        if (usage == null) {
            usage = KingdomsLang.NONE;
        }
        switch (cmd.getPermission().getDefault()) {
            case TRUE: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_EVERYONE;
                break;
            }
            case FALSE: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_NO_ONE;
                break;
            }
            case OP: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_OP;
                break;
            }
            case NOT_OP: {
                permScope = KingdomsLang.PLUGIN_PERMISSION_SCOPE_NOT_OP;
                break;
            }
            default: {
                KLogger.error("Unknown permission type: " + cmd.getPermission().getDefault());
                permScope = KingdomsLang.UNKNOWN;
            }
        }
        context.getMessageContext().resetPlaceholders();
        context.getMessageContext().raws("main-name", cmd.getName(), "parent", cmd.getParent() != null ? cmd.getParent().getName() : KingdomsLang.NONE, "command-displayname", cmd.getDisplayName(), "description", cmd.getDescription().parse(context.getMessageReceiver(), new Object[0]), "usage", usage, "permission", cmd.getPermission().getName(), "permission-scope", permScope, "cooldown", cmd.getCooldown() >= 0L ? KingdomsLang.NONE : TimeFormatter.of(cmd.getCooldown()));
        List<String> aliases2 = cmd.getAliases().get(context.getMessageContext().getLanguage());
        if (aliases2.isEmpty()) {
            context.getMessageContext().raw("aliases", KingdomsLang.NONE);
        } else {
            context.getMessageContext().parse("aliases", Strings.join("&8, ", aliases2, (Function<String, String>)((Function)x -> "&9" + x)));
        }
        if (cmd.getDisabledWorlds() == null) {
            context.getMessageContext().raw("disabled-worlds", KingdomsLang.NONE);
        } else {
            context.getMessageContext().parse("disabled-worlds", Strings.join("&8, ", cmd.getDisabledWorlds().unwrap().stream().map(StringMatcher::asString).collect(Collectors.toList()), (Function<String, String>)((Function)x -> "&9" + x)));
        }
        context.sendMessage(infoMsg, new Object[0]);
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        int maxPages = CommandHelp.getPageNumbers(context.isPlayer() ? KingdomsCommandHandler.getCommands(context.getMessageContext().getLanguage()).size() : CommandHelp.filterAccessiblePages((CommandSender)context.senderAsPlayer()).length);
        ArrayList<String> numbers = new ArrayList<String>(maxPages);
        for (int i = 0; i < maxPages; ++i) {
            numbers.add(Integer.toString(i));
        }
        return numbers;
    }
}

