/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.MessageHandler;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.display.scoreboard.Glow;
import org.kingdoms.utils.display.scoreboard.GlowScoreboard;
import org.kingdoms.utils.hash.EntityHashSet;
import org.kingdoms.utils.hash.EntityUUIDHashSet;

public class CommandGlow
extends KingdomsCommand
implements Listener {
    public static final EntityUUIDHashSet<Entity> ACTIVATED = ((EntityHashSet.UUIDBuilder)EntityHashSet.uuidBuilder(Entity.class).onLeave(EntityHashSet::remove)).build();

    public CommandGlow() {
        super("glow");
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (!ACTIVATED.remove((Entity)player)) {
            return;
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        Kingdom kingdom = kp.getKingdom();
        if (kingdom == null) {
            return;
        }
        for (Player entity2 : kingdom.getOnlineMembers()) {
            Glow.removeGlow(player);
        }
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (XReflection.supports((int)17)) {
            MessageHandler.sendMessage(context.getMessageReceiver(), "&4This command is currently not supported in 1.17+");
            return CommandResult.FAILED;
        }
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        Kingdom kingdom = context.getKingdom();
        if (kingdom == null) {
            context.sendError(KingdomsLang.NO_KINGDOM_DEFAULT, new Object[0]);
            return CommandResult.FAILED;
        }
        if (ACTIVATED.remove((Entity)player)) {
            Glow.removeGlow(player);
            context.sendMessage((Messenger)KingdomsLang.COMMAND_GLOW_DISABLED, new Object[0]);
        } else {
            ACTIVATED.add((Entity)player);
            for (Player member : kingdom.getOnlineMembers()) {
                if (member == player) continue;
                Glow.setGlowing(player, GlowScoreboard.Color.DARK_RED, new Entity[]{member});
            }
            context.sendMessage((Messenger)KingdomsLang.COMMAND_GLOW_ENABLED, new Object[0]);
        }
        return CommandResult.SUCCESS;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
    }
}

