/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.bukkit.command.CommandSender;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.Nation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.gui.GUIConfig;
import org.kingdoms.gui.InteractiveGUI;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.buildings.structures.NexusManager;
import org.kingdoms.utils.string.Strings;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0006\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lorg/kingdoms/commands/general/others/CommandGUI;", "Lorg/kingdoms/commands/KingdomsCommand;", "<init>", "()V", "execute", "Lorg/kingdoms/commands/CommandResult;", "context", "Lorg/kingdoms/commands/CommandContext;", "tabComplete", "", "", "Lorg/kingdoms/commands/CommandTabContext;", "ExtraCommandContext", "core"})
@SourceDebugExtension(value={"SMAP\nCommandGUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandGUI.kt\norg/kingdoms/commands/general/others/CommandGUI\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n37#2:89\n36#2,3:90\n37#2:93\n36#2,3:94\n1557#3:97\n1628#3,3:98\n*S KotlinDebug\n*F\n+ 1 CommandGUI.kt\norg/kingdoms/commands/general/others/CommandGUI\n*L\n42#1:89\n42#1:90,3\n61#1:93\n61#1:94,3\n84#1:97\n84#1:98,3\n*E\n"})
public final class CommandGUI
extends KingdomsCommand {
    public CommandGUI() {
        super("gui", true);
        NexusManager.init();
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull CommandContext context) {
        Collection thisCollection$iv;
        int $i$f$toTypedArray;
        Function<CommandContext, InteractiveGUI> fn;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(1)) {
            return CommandResult.FAILED;
        }
        if (context.assertHasKingdom()) {
            return CommandResult.FAILED;
        }
        String string = context.arg(0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"arg(...)");
        String string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)string, (char)'.', (char)'/', (boolean)false, (int)4, null), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String guiName = Strings.remove(string3, ".yml");
        Function<CommandContext, InteractiveGUI> function = GUIConfig.getIndependentGuis().get(guiName);
        if (function == null) {
            function = GUIConfig.getIndependentGuis().get("structures/nexus/" + guiName);
        }
        if ((fn = function) == null) {
            Object[] objectArray = new Object[]{"gui", guiName};
            context.sendError(KingdomsLang.COMMAND_GUI_NOT_FOUND, objectArray);
            return CommandResult.FAILED;
        }
        Kingdom kingdomContext = null;
        int dropArgs = 1;
        if (context.assertArgs(2)) {
            Intrinsics.checkNotNullExpressionValue((Object)context.args, (String)"args");
            Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])context.args, (int)dropArgs);
            $i$f$toTypedArray = 0;
            thisCollection$iv = $this$toTypedArray$iv;
            for (String arg : thisCollection$iv.toArray(new String[0])) {
                Intrinsics.checkNotNull((Object)arg);
                if (!StringsKt.contains$default((CharSequence)arg, (char)'=', (boolean)false, (int)2, null)) break;
                char[] cArray = new char[]{'='};
                List split = StringsKt.split$default((CharSequence)arg, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                String key = (String)split.get(0);
                String value = (String)split.get(1);
                if (((CharSequence)value).length() > 0) {
                    if (Intrinsics.areEqual((Object)key, (Object)"kingdom")) {
                        kingdomContext = Kingdom.getKingdom(value);
                    } else {
                        CommandResult commandResult = context.fail(new StaticMessenger("&cUnknown context " + key + '=' + value));
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)commandResult), (String)"fail(...)");
                        return commandResult;
                    }
                }
                ++dropArgs;
            }
        }
        Kingdoms kingdoms = KingdomsCommand.plugin;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)kingdoms), (String)"plugin");
        KingdomsCommand kingdomsCommand = this;
        CommandSender commandSender = context.getMessageReceiver();
        Intrinsics.checkNotNullExpressionValue((Object)commandSender, (String)"getMessageReceiver(...)");
        Intrinsics.checkNotNullExpressionValue((Object)context.args, (String)"args");
        Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])context.args, (int)dropArgs);
        $i$f$toTypedArray = 0;
        thisCollection$iv = $this$toTypedArray$iv;
        ExtraCommandContext newContext = new ExtraCommandContext(null, kingdomContext, null, kingdoms, kingdomsCommand, commandSender, thisCollection$iv.toArray(new String[0]));
        return fn.apply(newContext) == null ? CommandResult.FAILED : CommandResult.SUCCESS;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> tabComplete(@NotNull CommandTabContext context) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.isAtArg(0)) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = GUIConfig.getIndependentGuis().keySet();
            int n = 0;
            CommandTabContext commandTabContext = context;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void x;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)x);
                collection.add(StringsKt.removePrefix((String)x, (CharSequence)"structures/nexus/"));
            }
            collection = (List)destination$iv$iv;
            List<String> list2 = commandTabContext.suggest(n, collection);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"suggest(...)");
        } else {
            List<String> list3 = KingdomsCommand.emptyTab();
            list = list3;
            Intrinsics.checkNotNullExpressionValue(list3, (String)"emptyTab(...)");
        }
        return list;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001BK\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/commands/general/others/CommandGUI$ExtraCommandContext;", "Lorg/kingdoms/commands/CommandContext;", "player", "Lorg/kingdoms/constants/player/KingdomPlayer;", "kingdom", "Lorg/kingdoms/constants/group/Kingdom;", "nation", "Lorg/kingdoms/constants/group/Nation;", "plugin", "Lorg/kingdoms/main/Kingdoms;", "command", "Lorg/kingdoms/commands/KingdomsCommand;", "sender", "Lorg/bukkit/command/CommandSender;", "args", "", "", "<init>", "(Lorg/kingdoms/commands/general/others/CommandGUI;Lorg/kingdoms/constants/player/KingdomPlayer;Lorg/kingdoms/constants/group/Kingdom;Lorg/kingdoms/constants/group/Nation;Lorg/kingdoms/main/Kingdoms;Lorg/kingdoms/commands/KingdomsCommand;Lorg/bukkit/command/CommandSender;[Ljava/lang/String;)V", "getKingdom", "getNation", "index", "", "core"})
    public final class ExtraCommandContext
    extends CommandContext {
        @Nullable
        private final KingdomPlayer player;
        @Nullable
        private final Kingdom kingdom;
        @Nullable
        private final Nation nation;

        public ExtraCommandContext(@Nullable KingdomPlayer player, @Nullable Kingdom kingdom, @NotNull Nation nation, @NotNull Kingdoms plugin, @NotNull KingdomsCommand command, @NotNull CommandSender sender, String[] args) {
            Intrinsics.checkNotNullParameter((Object)((Object)plugin), (String)"plugin");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)sender, (String)"sender");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            super(plugin, command, sender, args);
            this.player = player;
            this.kingdom = kingdom;
            this.nation = nation;
        }

        @Override
        @NotNull
        public Kingdom getKingdom() {
            Kingdom kingdom = this.kingdom;
            if (kingdom == null) {
                Kingdom kingdom2 = super.getKingdom();
                kingdom = kingdom2;
                Intrinsics.checkNotNullExpressionValue((Object)kingdom2, (String)"getKingdom(...)");
            }
            return kingdom;
        }

        @Override
        @NotNull
        public Nation getNation(int index) {
            Nation nation = this.nation;
            if (nation == null) {
                Nation nation2 = super.getNation(index);
                nation = nation2;
                Intrinsics.checkNotNullExpressionValue((Object)nation2, (String)"getNation(...)");
            }
            return nation;
        }
    }
}

