/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.RelationAttribute;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.group.upgradable.MiscUpgrade;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.data.Pair;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.managers.FlyManager;
import org.kingdoms.permissions.KingdomsDefaultPluginPermission;
import org.kingdoms.utils.PlayerUtils;
import org.kingdoms.utils.config.NodeInterpreter;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberConstraint;
import org.kingdoms.utils.internal.string.NumberMatcher;

public class CommandFly
extends KingdomsCommand {
    public CommandFly() {
        super("fly", true);
    }

    @Override
    public CommandResult execute(CommandContext context) {
        Pair<AnyNumber, Messenger> speedResult;
        Player player;
        boolean admin = false;
        Float speed = null;
        if (context.assertArgs(2)) {
            if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_FLY_OTHERS)) {
                context.sendError(KingdomsLang.COMMAND_FLY_OTHERS_PERMISSION, new Object[0]);
                return CommandResult.FAILED;
            }
            player = context.getPlayer(0);
            if (player == null) {
                return CommandResult.FAILED;
            }
            speedResult = context.getNumber(1, new StaticMessenger("speed"), new NumberConstraint[0]);
            if (speedResult.getValue() != null) {
                return context.fail(speedResult.getValue());
            }
            speed = Float.valueOf(speedResult.getKey().getValue().floatValue());
        } else if (context.assertArgs(1)) {
            speedResult = context.getNumber(0, new StaticMessenger("speed"), new NumberConstraint[0]);
            if (speedResult.getValue() != null) {
                Player isPlayer = PlayerUtils.getPlayer(this.name, true);
                if (isPlayer == null) {
                    return context.fail(speedResult.getValue());
                }
                player = isPlayer;
                if (!context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_FLY_OTHERS)) {
                    return context.fail(KingdomsLang.COMMAND_FLY_OTHERS_PERMISSION);
                }
            } else {
                speed = Float.valueOf(speedResult.getKey().getValue().floatValue());
                player = context.senderAsPlayer();
            }
            admin = true;
        } else if (context.isPlayer()) {
            player = context.senderAsPlayer();
        } else {
            return context.fail(KingdomsLang.COMMAND_FLY_USAGE);
        }
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            context.sendError(admin ? KingdomsLang.NO_KINGDOM_TARGET : KingdomsLang.NO_KINGDOM_DEFAULT, "target", player.getName());
            return CommandResult.FAILED;
        }
        if (speed != null) {
            NumberMatcher defaultAllowedSpeed;
            if (speed.floatValue() < -1.0f || speed.floatValue() > 1.0f) {
                return context.fail(KingdomsLang.COMMAND_FLY_INVALID_SPEED);
            }
            AtomicBoolean canUse = new AtomicBoolean(false);
            List<NumberMatcher> usableSpeeds = FlyManager.getUsableSpeeds(player, speed.floatValue(), canUse);
            if (!canUse.get()) {
                context.var("allowed_speeds", usableSpeeds.stream().map(NumberMatcher::getAsString).collect(Collectors.joining(", ")));
                return context.fail(KingdomsLang.COMMAND_FLY_RESTRICTED_SPEED);
            }
            if (usableSpeeds.isEmpty() && (defaultAllowedSpeed = KingdomsConfig.KINGDOM_FLY_ALLOWED_SPEED.getManager().get(NodeInterpreter.NUMBER_MATCHER)) != null && !defaultAllowedSpeed.matches(AnyNumber.of(speed))) {
                context.var("allowed_speeds", defaultAllowedSpeed.getAsString());
                return context.fail(KingdomsLang.COMMAND_FLY_RESTRICTED_SPEED);
            }
            if (kp.isFlying()) {
                player.setFlySpeed(speed.floatValue());
                context.var("speed", speed);
                context.sendMessage((Messenger)KingdomsLang.COMMAND_FLY_CHANGED_SPEED, new Object[0]);
                return CommandResult.SUCCESS;
            }
        }
        if (!kp.isAdmin() && !admin) {
            Kingdom landKingdom;
            if (!kp.hasPermission(StandardKingdomPermission.FLY)) {
                StandardKingdomPermission.FLY.sendDeniedMessage(player);
                return CommandResult.FAILED;
            }
            Land land = Land.getLand(player.getLocation());
            Kingdom kingdom = landKingdom = land == null ? null : land.getKingdom();
            if (landKingdom == null && !KingdomsConfig.KINGDOM_FLY_ALLOW_UNCLAIMED.getBoolean()) {
                KingdomsLang.COMMAND_FLY_UNCLAIMED.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
            Kingdom kingdom2 = kp.getKingdom();
            if (landKingdom != null && !kingdom2.hasAttribute(landKingdom, (RelationAttribute)StandardRelationAttribute.FLY)) {
                KingdomsLang.COMMAND_FLY_NOT_ALLOWED.sendError((CommandSender)player, "kingdom", landKingdom.getName());
                return CommandResult.FAILED;
            }
            if (MiscUpgrade.FLIGHT.isEnabled() && kingdom2.getUpgradeLevel(MiscUpgrade.FLIGHT) <= 0) {
                KingdomsLang.COMMAND_FLY_NOT_UPGRADED.sendError((CommandSender)player, new Object[0]);
                return CommandResult.FAILED;
            }
            int range = KingdomsConfig.KINGDOM_FLY_NEARBY_UNFRIENDLY_RANGE.getInt();
            if (range > 0) {
                for (Entity nearby : player.getNearbyEntities((double)range, (double)range, (double)range)) {
                    Player enemy;
                    KingdomPlayer enemyKp;
                    if (!(nearby instanceof Player) || (enemyKp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)(enemy = (Player)nearby))).isInSneakMode() || kingdom2.hasAttribute(enemyKp.getKingdom(), (RelationAttribute)StandardRelationAttribute.CEASEFIRE)) continue;
                    KingdomsLang.COMMAND_FLY_OWN_ENEMY_NEARBY.sendError((CommandSender)player, new Object[0]);
                    return CommandResult.FAILED;
                }
            }
        }
        if (player.getAllowFlight()) {
            kp.setFlying(false, null);
            FlyManager.notifyAboutCharges(player);
            KingdomsLang.COMMAND_FLY_DISABLED.sendMessage((CommandSender)player);
        } else {
            if (KingdomsConfig.KINGDOM_FLY_CHARGES_ENABLED.getBoolean() && !kp.isAdmin() && !KingdomsDefaultPluginPermission.FLIGHT_BYPASS_CHARGES.hasPermission((CommandSender)player) && !FlyManager.handleCharges(player, kp, Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_PLAYERS_ACTIVATION_COST.getManager(), KingdomsLang.COMMAND_FLY_CANT_AFFORD), Pair.of(KingdomsConfig.KINGDOM_FLY_CHARGES_KINGDOMS_ACTIVATION_COST.getManager(), KingdomsLang.COMMAND_FLY_CANT_AFFORD_KINGDOM))) {
                return CommandResult.FAILED;
            }
            kp.setFlying(true, speed);
            KingdomsLang.COMMAND_FLY_ENABLED.sendMessage((CommandSender)player);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @NonNull List<String> tabComplete(CommandTabContext context) {
        List<String> flySpeed = context.tabComplete(context.tabParameter("speed", false));
        if (context.isAtArg(0)) {
            if (context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_FLY_OTHERS)) {
                return context.merge(context.getPlayers(0), flySpeed);
            }
            return flySpeed;
        }
        if (context.isAtArg(1) && context.hasPermission(KingdomsDefaultPluginPermission.COMMAND_FLY_OTHERS)) {
            return flySpeed;
        }
        return context.emptyTab();
    }
}

