/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.commands.general.others;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.CommandResult;
import org.kingdoms.commands.CommandTabContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.constants.player.StandardKingdomPermission;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;

public class CommandDonate
extends KingdomsCommand {
    public CommandDonate() {
        super("donate");
    }

    @Override
    public CommandResult execute(CommandContext context) {
        if (context.assertPlayer()) {
            return CommandResult.FAILED;
        }
        if (context.requireArgs(2)) {
            return CommandResult.FAILED;
        }
        Player player = context.senderAsPlayer();
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer((OfflinePlayer)player);
        if (!kp.hasKingdom()) {
            KingdomsLang.NO_KINGDOM_DEFAULT.sendMessage((CommandSender)player);
            return CommandResult.FAILED;
        }
        if (!kp.hasPermission(StandardKingdomPermission.WITHDRAW)) {
            StandardKingdomPermission.WITHDRAW.sendDeniedMessage(player);
            return CommandResult.FAILED;
        }
        Kingdom to = context.getKingdom(0);
        Integer donate = context.getInt(1);
        if (donate == null) {
            return CommandResult.FAILED;
        }
        if (donate <= 0) {
            KingdomsLang.COMMAND_DONATE_INVALID.sendMessage((CommandSender)player, "kingdom", to.getName(), "rp", donate);
            return CommandResult.FAILED;
        }
        Kingdom kingdom = kp.getKingdom();
        if (!kingdom.getResourcePoints().has(donate)) {
            KingdomsLang.COMMAND_DONATE_DONT_HAVE.sendMessage((CommandSender)player, "kingdom", to.getName(), "rp", donate);
            return CommandResult.FAILED;
        }
        kingdom.getResourcePoints().add(-donate.intValue());
        to.getResourcePoints().add(donate);
        context.sendMessage((Messenger)KingdomsLang.COMMAND_DONATE_DONE, "kingdom", to.getName(), "rp", donate);
        for (Player member : to.getOnlineMembers()) {
            KingdomsLang.COMMAND_DONATE_DONATED.sendMessage((CommandSender)member, "kingdom", kingdom.getName(), "rp", donate);
        }
        return CommandResult.SUCCESS;
    }

    @Override
    public @Nullable @NonNull List<String> tabComplete(@NonNull CommandTabContext context) {
        if (context.isAtArg(0)) {
            return context.getKingdoms(0);
        }
        if (context.isAtArg(1)) {
            return Collections.singletonList("<amount>");
        }
        return new ArrayList<String>();
    }
}

